/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.util.Random;
import java.util.Vector;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestElementComparator;
import org.eclipse.core.tests.internal.watson.WatsonTest;

abstract class TestUtil
extends WatsonTest
implements IPathConstants {
    static final IElementComparator fComparator = TestElementComparator.getComparator();

    public TestUtil(String name) {
        super(name);
    }

    static void assertAdded(int compare) {
        TestUtil.assertTrue((compare == 1 ? 1 : 0) != 0);
    }

    static void assertChanged(int compare) {
        TestUtil.assertTrue((compare == 4 ? 1 : 0) != 0);
    }

    protected static void assertEqualTrees(String message, ElementTree expected, ElementTree actual) {
        TestUtil.assertEqualTrees(message, expected, actual, (IPath)Path.ROOT, -1);
    }

    protected static void assertEqualTrees(String message, ElementTree expected, ElementTree actual, int depth) {
        TestUtil.assertEqualTrees(message, expected, actual, (IPath)Path.ROOT, depth);
    }

    protected static void assertEqualTrees(String message, ElementTree expected, ElementTree actual, IPath path) {
        TestUtil.assertEqualTrees(message, expected, actual, path, -1);
    }

    protected static void assertEqualTrees(String msg, ElementTree expected, ElementTree actual, IPath path, int depth) {
        TestUtil.assertTrue((String)msg, (boolean)expected.includes(path));
        TestUtil.assertTrue((String)msg, (boolean)actual.includes(path));
        TestUtil.assertEquals((String)msg, (Object)expected.getElementData(path), (Object)actual.getElementData(path));
        if (depth != 0) {
            IPath[] actualChildren;
            IPath[] expectedChildren = expected.getChildren(path);
            TestUtil.assertTrue((String)"Number of children", (expectedChildren.length == (actualChildren = actual.getChildren(path)).length ? 1 : 0) != 0);
            int newDepth = depth;
            if (depth != -1) {
                --newDepth;
            }
            int i = 0;
            while (i < expectedChildren.length) {
                TestUtil.assertEquals((String)"children IDs", (Object)expectedChildren[i], (Object)actualChildren[i]);
                TestUtil.assertEqualTrees("Recursive call", expected, actual, expectedChildren[i], newDepth);
                ++i;
            }
        }
    }

    protected static void assertHasPaths(ElementTree tree, IPath[] paths) {
        int i = 0;
        while (i < paths.length) {
            TestUtil.assertTrue((String)("assertHasPaths" + i), (boolean)tree.includes(paths[i]));
            ++i;
        }
    }

    static void assertNoChange(int compare) {
        TestUtil.assertTrue((compare == 0 ? 1 : 0) != 0);
    }

    protected static void assertNoPaths(ElementTree tree, IPath[] paths) {
        int i = 0;
        while (i < paths.length) {
            TestUtil.assertTrue((String)("assertNoPaths: " + paths[i]), (!tree.includes(paths[i]) ? 1 : 0) != 0);
            ++i;
        }
    }

    static void assertRemoved(int compare) {
        TestUtil.assertTrue((compare == 2 ? 1 : 0) != 0);
    }

    protected static void assertTreeStructure(ElementTree tree) {
        TestUtil.assertHasPaths(tree, TestUtil.getTreePaths());
        IPath[] children = tree.getChildren((IPath)Path.ROOT);
        TestUtil.assertTrue((children.length == 1 ? 1 : 0) != 0);
        children = tree.getChildren(children[0]);
        TestUtil.assertTrue((children.length == 2 ? 1 : 0) != 0);
        TestUtil.assertTrue((tree.getChildren(project1).length == 0 ? 1 : 0) != 0);
        children = tree.getChildren(children[1]);
        TestUtil.assertTrue((children.length == 3 ? 1 : 0) != 0);
        TestUtil.assertTrue((tree.getChildren(file1).length == 0 ? 1 : 0) != 0);
        TestUtil.assertTrue((tree.getChildren(folder2).length == 0 ? 1 : 0) != 0);
        children = tree.getChildren(children[1]);
        TestUtil.assertTrue((children.length == 3 ? 1 : 0) != 0);
        TestUtil.assertTrue((tree.getChildren(file2).length == 0 ? 1 : 0) != 0);
        TestUtil.assertTrue((tree.getChildren(folder4).length == 0 ? 1 : 0) != 0);
        children = tree.getChildren(children[1]);
        TestUtil.assertTrue((children.length == 1 ? 1 : 0) != 0);
        TestUtil.assertTrue((tree.getChildren(file3).length == 0 ? 1 : 0) != 0);
    }

    static ElementTree createTestElementTree() {
        ElementTree tree = new ElementTree();
        tree.createElement(solution, (Object)new String("solution"));
        tree.createElement(project1, (Object)new String("project1"));
        tree.createElement(project2, (Object)new String("project2"));
        tree.createElement(file1, (Object)new String("file1"));
        tree.createElement(folder1, (Object)new String("folder1"));
        tree.createElement(folder2, (Object)new String("folder2"));
        tree.createElement(file2, (Object)new String("file2"));
        tree.createElement(folder3, (Object)new String("folder3"));
        tree.createElement(folder4, (Object)new String("folder4"));
        tree.createElement(file3, (Object)new String("file3"));
        return tree;
    }

    protected static ElementTree[] doManyRoutineOperations(ElementTree tree, IPath path) {
        String data;
        Vector<ElementTree> trees = new Vector<ElementTree>();
        trees.addElement(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] files = TestUtil.getFilePaths(path);
        int i = 0;
        while (i < files.length) {
            data = files[i].toString();
            tree.createElement(files[i], (Object)data);
            tree.immutable();
            trees.addElement(tree);
            tree = tree.newEmptyDelta();
            ++i;
        }
        i = 0;
        while (i < repeat) {
            data = "data" + i;
            int f = 0;
            while (f < files.length) {
                tree.setElementData(files[f], (Object)data);
                tree.immutable();
                trees.addElement(tree);
                tree = tree.newEmptyDelta();
                ++f;
            }
            ++i;
        }
        i = 0;
        while (i < files.length) {
            tree.deleteElement(files[i]);
            tree.immutable();
            trees.addElement(tree);
            tree = tree.newEmptyDelta();
            ++i;
        }
        Object[] results = new ElementTree[trees.size()];
        trees.copyInto(results);
        return results;
    }

    protected static ElementTree[] doRoutineOperations(ElementTree tree, IPath path) {
        String data;
        Vector<ElementTree> trees = new Vector<ElementTree>();
        trees.addElement(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] files = TestUtil.getFilePaths(path);
        int i = 0;
        while (i < files.length) {
            data = files[i].toString();
            tree.createElement(files[i], (Object)data);
            ++i;
        }
        tree.immutable();
        trees.addElement(tree);
        tree = tree.newEmptyDelta();
        i = 0;
        while (i < repeat) {
            data = "data" + i;
            int f = 0;
            while (f < files.length) {
                tree.setElementData(files[f], (Object)data);
                ++f;
            }
            ++i;
        }
        tree.immutable();
        trees.addElement(tree);
        tree = tree.newEmptyDelta();
        i = 0;
        while (i < files.length) {
            tree.deleteElement(files[i]);
            ++i;
        }
        tree.immutable();
        trees.addElement(tree);
        Object[] results = new ElementTree[trees.size()];
        trees.copyInto(results);
        return results;
    }

    static IElementComparator getComparator() {
        return fComparator;
    }

    protected static IPath[] getFilePaths(IPath project3) {
        String[] names = TestUtil.getJavaLangUnits();
        IPath[] paths = new IPath[names.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = project3.append(names[i]);
            ++i;
        }
        return paths;
    }

    protected static String[] getJavaLangUnits() {
        return new String[]{"AbstractMethodError.java", "ArithmeticException.java", "ArrayIndexOutOfBoundsException.java", "ArrayStoreException.java", "Boolean.java", "Byte.java", "Character.java", "Class.java", "ClassCastException.java", "ClassCircularityError.java", "ClassFormatError.java", "ClassLoader.java", "ClassNotFoundException.java", "Cloneable.java", "CloneNotSupportedException.java", "Compiler.java", "Double.java", "Error.java"};
    }

    protected static IPath[] getTreePaths() {
        return new IPath[]{solution, project1, project2, folder1, folder2, folder3, folder4, file1, file2, file3};
    }

    protected static void scramble(Object[] first) {
        Random random = new Random(System.currentTimeMillis());
        int len = first.length;
        int i = 0;
        while (i < len * 100) {
            int off2;
            int off1 = (int)(random.nextFloat() * (float)len);
            if (off1 != len && (off2 = (int)(random.nextFloat() * (float)len)) != len) {
                Object temp = first[off1];
                first[off1] = first[off2];
                first[off2] = temp;
            }
            ++i;
        }
    }

    protected static void scramble(Object[] first, Object[] second) {
        TestUtil.assertTrue((first.length == second.length ? 1 : 0) != 0);
        Random random = new Random(System.currentTimeMillis());
        int len = first.length;
        int i = 0;
        while (i < len * 100) {
            int off2;
            int off1 = (int)(random.nextFloat() * (float)len);
            if (off1 != len && (off2 = (int)(random.nextFloat() * (float)len)) != len) {
                Object temp = first[off1];
                first[off1] = first[off2];
                first[off2] = temp;
                temp = second[off1];
                second[off1] = second[off2];
                second[off2] = temp;
            }
            ++i;
        }
    }
}

