/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.ContentTypeSettings;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.tests.resources.ResourceTest;
import org.osgi.service.prefs.BackingStoreException;

public class ContentDescriptionManagerTest
extends ResourceTest {
    private static final String CONTENT_TYPE_RELATED_NATURE1 = "org.eclipse.core.tests.resources.contentTypeRelated1";
    private static final String CONTENT_TYPE_RELATED_NATURE2 = "org.eclipse.core.tests.resources.contentTypeRelated2";

    public static Test suite() {
        return new TestSuite(ContentDescriptionManagerTest.class);
    }

    public static void waitForCacheFlush() {
        try {
            Job.getJobManager().join((Object)"org.eclipse.core.resources.contentDescriptionCacheFamily", null);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public ContentDescriptionManagerTest(String name) {
        super(name);
    }

    private IContentDescription getDescription(String tag, IFile file) {
        IContentDescription description = null;
        try {
            description = file.getContentDescription();
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)tag, (Throwable)e);
        }
        return description;
    }

    protected InputStream projectDescriptionWithNatures(String project, String[] natures) {
        StringBuffer contents = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>" + project + "</name><natures>");
        int i = 0;
        while (i < natures.length) {
            contents.append("<nature>" + natures[i] + "</nature>");
            ++i;
        }
        contents.append("</natures></projectDescription>");
        return new ByteArrayInputStream(contents.toString().getBytes());
    }

    public void testBug79151() {
        IWorkspace workspace = ContentDescriptionManagerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        String newExtension = "xml_bug_79151";
        IFile file1 = project.getFile("file.xml");
        IFile file2 = project.getFile("file." + newExtension);
        this.ensureExistsInWorkspace(file1, this.getContents("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root/>"));
        this.ensureExistsInWorkspace(file2, this.getContents("<?xml version=\"1.0\" encoding=\"US-ASCII\"?><org.eclipse.core.resources.tests.root/>"));
        ((Workspace)workspace).getContentDescriptionManager().invalidateCache(true, null);
        ContentDescriptionManagerTest.waitForCacheFlush();
        ContentDescriptionManagerTest.assertEquals((String)"0.9", (byte)1, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        IContentDescription description1a = null;
        IContentDescription description1b = null;
        IContentDescription description1c = null;
        IContentDescription description1d = null;
        IContentDescription description2 = null;
        description1a = this.getDescription("1.0a", file1);
        description2 = this.getDescription("1.0b", file2);
        ContentDescriptionManagerTest.assertNotNull((String)"1.1", (Object)description1a);
        ContentDescriptionManagerTest.assertEquals((String)"1.2", (Object)xml, (Object)description1a.getContentType());
        ContentDescriptionManagerTest.assertNull((String)"1.3", (Object)description2);
        description1b = this.getDescription("2.0", file1);
        ContentDescriptionManagerTest.assertNotNull((String)" 2.1", (Object)description1b);
        ContentDescriptionManagerTest.assertSame((String)"2.2", (Object)description1a, (Object)description1b);
        try {
            xml.addFileSpec(newExtension, 8);
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            description1c = this.getDescription("4.0a", file1);
            description2 = this.getDescription("4.0b", file2);
            ContentDescriptionManagerTest.assertNotNull((String)"4.1", (Object)description1c);
            ContentDescriptionManagerTest.assertNotSame((String)"4.2", (Object)description1a, (Object)description1c);
            ContentDescriptionManagerTest.assertEquals((String)"4.3", (Object)xml, (Object)description1c.getContentType());
            ContentDescriptionManagerTest.assertNotNull((String)"4.4", (Object)description2);
            ContentDescriptionManagerTest.assertEquals((String)"4.5", (Object)xml, (Object)description2.getContentType());
        }
        finally {
            try {
                xml.removeFileSpec(newExtension, 8);
            }
            catch (CoreException e) {
                ContentDescriptionManagerTest.fail((String)"4.99", (Throwable)e);
            }
        }
        description1d = this.getDescription("5.0a", file1);
        description2 = this.getDescription("5.0b", file2);
        ContentDescriptionManagerTest.assertNotNull((String)"5.1", (Object)description1d);
        ContentDescriptionManagerTest.assertNotSame((String)"5.2", (Object)description1c, (Object)description1d);
        ContentDescriptionManagerTest.assertEquals((String)"5.3", (Object)xml, (Object)description1d.getContentType());
        ContentDescriptionManagerTest.assertNull((String)"5.4", (Object)description2);
    }

    public void testBug94516() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        ContentDescriptionManagerTest.assertNotNull((String)"0.1", (Object)text);
        IProject project = ContentDescriptionManagerTest.getWorkspace().getRoot().getProject("proj1");
        IFile unrelatedFile = project.getFile("file." + this.getName());
        this.ensureExistsInWorkspace(unrelatedFile, "");
        IContentDescription description = null;
        description = this.getDescription("0.7", unrelatedFile);
        ContentDescriptionManagerTest.assertNull((String)"0.8", (Object)description);
        try {
            try {
                text.addFileSpec(unrelatedFile.getName(), 4);
            }
            catch (CoreException e) {
                ContentDescriptionManagerTest.fail((String)"0.99", (Throwable)e);
            }
            description = this.getDescription("1.0", unrelatedFile);
            ContentDescriptionManagerTest.assertNotNull((String)"1.1", (Object)description);
            ContentDescriptionManagerTest.assertEquals((String)"1.2", (Object)text, (Object)description.getContentType());
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences contentTypePrefs = projectScope.getNode("org.eclipse.core.runtime/content-types");
            contentTypePrefs.putBoolean("enabled", true);
            try {
                contentTypePrefs.flush();
            }
            catch (BackingStoreException e) {
                ContentDescriptionManagerTest.fail((String)"1.99", (Throwable)e);
            }
            description = this.getDescription("2.0", unrelatedFile);
            ContentDescriptionManagerTest.assertNull((String)"2.1", (Object)description);
            IContentTypeSettings settings = null;
            try {
                settings = text.getSettings((IScopeContext)projectScope);
            }
            catch (CoreException e) {
                ContentDescriptionManagerTest.fail((String)"3.0", (Throwable)e);
            }
            ContentDescriptionManagerTest.assertNotNull((String)"3.1", (Object)settings);
            ContentDescriptionManagerTest.assertNotSame((String)"3.2", (Object)text, (Object)settings);
            ContentDescriptionManagerTest.assertTrue((String)"3.3", (boolean)(settings instanceof ContentTypeSettings));
            try {
                settings.addFileSpec(unrelatedFile.getFullPath().getFileExtension(), 8);
            }
            catch (CoreException e) {
                ContentDescriptionManagerTest.fail((String)"4.0", (Throwable)e);
            }
            try {
                contentTypePrefs.flush();
            }
            catch (BackingStoreException e) {
                ContentDescriptionManagerTest.fail((String)"4.1", (Throwable)e);
            }
            description = this.getDescription("5.0", unrelatedFile);
            ContentDescriptionManagerTest.assertNotNull((String)"5.1", (Object)description);
            ContentDescriptionManagerTest.assertEquals((String)"5.2", (Object)text, (Object)description.getContentType());
        }
        finally {
            try {
                text.removeFileSpec(unrelatedFile.getName(), 4);
            }
            catch (CoreException e) {
                ContentDescriptionManagerTest.fail((String)"6.0", (Throwable)e);
            }
        }
    }

    public void testNatureContentTypeAssociation() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType baseType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.nature_associated_1");
        IContentType derivedType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.nature_associated_2");
        ContentDescriptionManagerTest.assertNotNull((String)"0.1", (Object)baseType);
        ContentDescriptionManagerTest.assertNotNull((String)"0.2", (Object)derivedType);
        IProject project = ContentDescriptionManagerTest.getWorkspace().getRoot().getProject("proj1");
        IFile file = project.getFile("file.nature-associated");
        IFile descFile = project.getFile(".project");
        this.ensureExistsInWorkspace(file, "it really does not matter");
        IContentDescription description = null;
        try {
            descFile.setContents(this.projectDescriptionWithNatures(project.getName(), new String[0]), 1, this.getMonitor());
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"1.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = this.getDescription("1.1", file);
        ContentDescriptionManagerTest.assertNotNull((String)"1.2", (Object)description);
        ContentDescriptionManagerTest.assertSame((String)"1.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        try {
            descFile.setContents(this.projectDescriptionWithNatures(project.getName(), new String[]{CONTENT_TYPE_RELATED_NATURE1}), 1, this.getMonitor());
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"2.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = this.getDescription("2.1", file);
        ContentDescriptionManagerTest.assertNotNull((String)"2.2", (Object)description);
        ContentDescriptionManagerTest.assertSame((String)"2.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        try {
            descFile.setContents(this.projectDescriptionWithNatures(project.getName(), new String[]{CONTENT_TYPE_RELATED_NATURE2}), 1, this.getMonitor());
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"3.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = this.getDescription("3.1", file);
        ContentDescriptionManagerTest.assertNotNull((String)"3.2", (Object)description);
        ContentDescriptionManagerTest.assertSame((String)"3.3", (Object)((ContentTypeHandler)derivedType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        try {
            descFile.setContents(this.projectDescriptionWithNatures(project.getName(), new String[]{CONTENT_TYPE_RELATED_NATURE1, CONTENT_TYPE_RELATED_NATURE2}), 1, this.getMonitor());
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"4.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = this.getDescription("4.1", file);
        ContentDescriptionManagerTest.assertNotNull((String)"4.2", (Object)description);
        ContentDescriptionManagerTest.assertSame((String)"4.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
        try {
            descFile.setContents(this.projectDescriptionWithNatures(project.getName(), new String[0]), 1, this.getMonitor());
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"5.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        description = this.getDescription("5.1", file);
        ContentDescriptionManagerTest.assertNotNull((String)"5.2", (Object)description);
        ContentDescriptionManagerTest.assertSame((String)"5.3", (Object)((ContentTypeHandler)baseType).getTarget(), (Object)((ContentTypeHandler)description.getContentType()).getTarget());
    }

    public void testProjectSpecificCharset() throws CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        ContentDescriptionManagerTest.assertNotNull((String)"0.1", (Object)text);
        ContentDescriptionManagerTest.assertNotNull((String)"0.2", (Object)xml);
        IProject project = ContentDescriptionManagerTest.getWorkspace().getRoot().getProject("proj1");
        IFile txtFile = project.getFile(String.valueOf(this.getName()) + ".txt");
        IFile xmlFile = project.getFile(String.valueOf(this.getName()) + ".xml");
        this.ensureExistsInWorkspace(txtFile, "");
        this.ensureExistsInWorkspace(xmlFile, "");
        project.setDefaultCharset("FOO", this.getMonitor());
        ContentDescriptionManagerTest.assertEquals((String)"1.0", (String)"FOO", (String)txtFile.getCharset());
        ContentDescriptionManagerTest.assertEquals((String)"1.1", (String)"UTF-8", (String)xmlFile.getCharset());
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences contentTypePrefs = projectScope.getNode("org.eclipse.core.runtime/content-types");
        contentTypePrefs.putBoolean("enabled", true);
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"2.0", (Throwable)e);
        }
        IContentTypeSettings settings = null;
        settings = text.getSettings((IScopeContext)projectScope);
        settings.setDefaultCharset("BAR");
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"2.1", (Throwable)e);
        }
        ContentDescriptionManagerTest.assertEquals((String)"3.0", (String)"BAR", (String)txtFile.getCharset());
        ContentDescriptionManagerTest.assertEquals((String)"3.1", (String)"UTF-8", (String)xmlFile.getCharset());
        settings = xml.getSettings((IScopeContext)projectScope);
        settings.setDefaultCharset("");
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"4.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.assertEquals((String)"4.1", (String)"BAR", (String)txtFile.getCharset());
        ContentDescriptionManagerTest.assertEquals((String)"4.2", (String)"FOO", (String)xmlFile.getCharset());
    }

    public void testProjectSpecificFileAssociations() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        ContentDescriptionManagerTest.assertNotNull((String)"0.1", (Object)text);
        ContentDescriptionManagerTest.assertNotNull((String)"0.2", (Object)xml);
        IProject project = ContentDescriptionManagerTest.getWorkspace().getRoot().getProject("proj1");
        IFile txtFile = project.getFile(String.valueOf(this.getName()) + ".txt");
        IFile xmlFile = project.getFile(String.valueOf(this.getName()) + ".xml");
        IFile unrelatedFile = project.getFile("file." + this.getName());
        this.ensureExistsInWorkspace(txtFile, "");
        this.ensureExistsInWorkspace(xmlFile, "");
        this.ensureExistsInWorkspace(unrelatedFile, "");
        IContentDescription description = null;
        description = this.getDescription("0.7a", txtFile);
        ContentDescriptionManagerTest.assertNotNull((String)"0.7b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"0.7c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("0.8a", xmlFile);
        ContentDescriptionManagerTest.assertNotNull((String)"0.8b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"0.8c", (Object)xml, (Object)description.getContentType());
        ContentDescriptionManagerTest.assertNull((String)"0.9b", (Object)this.getDescription("0.9a", unrelatedFile));
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences contentTypePrefs = projectScope.getNode("org.eclipse.core.runtime/content-types");
        contentTypePrefs.putBoolean("enabled", true);
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"0.99", (Throwable)e);
        }
        description = this.getDescription("1.0a", txtFile);
        ContentDescriptionManagerTest.assertNotNull((String)"1.0b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"1.0c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("1.1a", xmlFile);
        ContentDescriptionManagerTest.assertNotNull((String)"1.1b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"1.1c", (Object)xml, (Object)description.getContentType());
        ContentDescriptionManagerTest.assertNull((String)"1.2b", (Object)this.getDescription("1.2a", unrelatedFile));
        IContentTypeSettings settings = null;
        try {
            settings = text.getSettings((IScopeContext)projectScope);
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"2.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.assertNotNull((String)"2.1", (Object)settings);
        ContentDescriptionManagerTest.assertNotSame((String)"2.2", (Object)text, (Object)settings);
        ContentDescriptionManagerTest.assertTrue((String)"2.3", (boolean)(settings instanceof ContentTypeSettings));
        try {
            settings.addFileSpec(this.getName(), 8);
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"3.1", (Throwable)e);
        }
        description = this.getDescription("3.2a", unrelatedFile);
        ContentDescriptionManagerTest.assertNotNull((String)"3.2b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"3.2c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("3.3a", txtFile);
        ContentDescriptionManagerTest.assertNotNull((String)"3.3b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"3.3c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("3.4a", xmlFile);
        ContentDescriptionManagerTest.assertNotNull((String)"3.4b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"3.4c", (Object)xml, (Object)description.getContentType());
        contentTypePrefs.putBoolean("enabled", false);
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"3.99", (Throwable)e);
        }
        description = this.getDescription("4.0a", txtFile);
        ContentDescriptionManagerTest.assertNotNull((String)"4.0b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"4.0c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("4.1a", xmlFile);
        ContentDescriptionManagerTest.assertNotNull((String)"4.1b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"4.1c", (Object)xml, (Object)description.getContentType());
        ContentDescriptionManagerTest.assertNull((String)"4.2b", (Object)this.getDescription("4.2a", unrelatedFile));
        contentTypePrefs.putBoolean("enabled", true);
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            settings.addFileSpec(xmlFile.getName(), 4);
        }
        catch (CoreException e) {
            ContentDescriptionManagerTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            contentTypePrefs.flush();
        }
        catch (BackingStoreException e) {
            ContentDescriptionManagerTest.fail((String)"5.1", (Throwable)e);
        }
        description = this.getDescription("5.2a", unrelatedFile);
        ContentDescriptionManagerTest.assertNotNull((String)"5.2b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"5.2c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("5.3a", txtFile);
        ContentDescriptionManagerTest.assertNotNull((String)"5.3b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"5.3c", (Object)text, (Object)description.getContentType());
        description = this.getDescription("5.4a", xmlFile);
        ContentDescriptionManagerTest.assertNotNull((String)"5.4b", (Object)description);
        ContentDescriptionManagerTest.assertEquals((String)"5.4c", (Object)text, (Object)description.getContentType());
    }
}

