/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.TestPerformer;

public class IResourceTest
extends ResourceTest {
    protected static final Boolean[] FALSE_AND_TRUE = new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    protected static IPath[] interestingPaths;
    protected static IResource[] interestingResources;
    protected static Set nonExistingResources;
    static boolean noSideEffects;
    protected static final IProgressMonitor[] PROGRESS_MONITORS;
    protected static final int S_CHANGED = 3;
    protected static final int S_DOES_NOT_EXIST = 4;
    protected static final int S_FILE_TO_FOLDER = 6;
    protected static final int S_FILESYSTEM_ONLY = 1;
    protected static final int S_FOLDER_TO_FILE = 5;
    protected static final int S_UNCHANGED = 2;
    protected static final int S_WORKSPACE_ONLY = 0;
    protected static final Boolean[] TRUE_AND_FALSE;
    protected static Set unsynchronizedResources;
    ResourceDeltaVerifier verifier;

    static {
        nonExistingResources = new HashSet();
        noSideEffects = false;
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[3];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        iProgressMonitorArray[1] = new CancelingProgressMonitor();
        PROGRESS_MONITORS = iProgressMonitorArray;
        TRUE_AND_FALSE = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        unsynchronizedResources = new HashSet();
    }

    protected static Set getAllFilesForDirectory(File dir) {
        HashSet<File> result = new HashSet<File>(50);
        String[] members = dir.list();
        if (members != null) {
            int i = 0;
            while (i < members.length) {
                File member = new File(dir, members[i]);
                result.add(member);
                if (member.isDirectory()) {
                    result.addAll(IResourceTest.getAllFilesForDirectory(member));
                }
                ++i;
            }
        }
        return result;
    }

    protected static Set getAllFilesForResource(IResource resource, boolean considerUnsyncLocalFiles) throws CoreException {
        HashSet<File> result;
        block3: {
            File file;
            block4: {
                result = new HashSet<File>(50);
                if (resource.getLocation() == null || resource.getType() == 4 && !((IProject)resource).isOpen()) break block3;
                file = resource.getLocation().toFile();
                if (!considerUnsyncLocalFiles) break block4;
                if (!file.exists()) break block3;
                result.add(file);
                if (!file.isDirectory()) break block3;
                result.addAll(IResourceTest.getAllFilesForDirectory(file));
                break block3;
            }
            if (resource.exists()) {
                result.add(file);
                if (resource.getType() != 1) {
                    IContainer container = (IContainer)resource;
                    IResource[] children = container.members();
                    int i = 0;
                    while (i < children.length) {
                        IResource member = children[i];
                        result.addAll(IResourceTest.getAllFilesForResource(member, considerUnsyncLocalFiles));
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    protected static Set getAllResourcesForResource(IResource resource) throws CoreException {
        HashSet<IResource> result = new HashSet<IResource>(50);
        if (resource.exists()) {
            result.add(resource);
            if (resource.getType() != 1 && resource.isAccessible()) {
                IContainer container = (IContainer)resource;
                IResource[] children = container.members();
                int i = 0;
                while (i < children.length) {
                    IResource member = children[i];
                    result.addAll(IResourceTest.getAllResourcesForResource(member));
                    ++i;
                }
            }
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(IResourceTest.class);
    }

    public IResourceTest() {
    }

    public IResourceTest(String name) {
        super(name);
    }

    protected IResource[] buildInterestingResources() {
        IProject emptyProject = IResourceTest.getWorkspace().getRoot().getProject("EmptyProject");
        IProject fullProject = IResourceTest.getWorkspace().getRoot().getProject("FullProject");
        IResource[] resources = this.buildResources((IContainer)fullProject, new String[]{"1", "2/", "3/", "3/1", "3/2/"});
        IResource[] result = new IResource[resources.length + 3];
        result[0] = IResourceTest.getWorkspace().getRoot();
        result[1] = emptyProject;
        result[2] = fullProject;
        System.arraycopy(resources, 0, result, 3, resources.length);
        this.ensureExistsInWorkspace(result, true);
        return result;
    }

    private IResource[] buildSampleResources(IContainer root) {
        IResource[] result = this.buildResources(root, new String[]{"1/", "1/1/", "1/1/1/", "1/1/1/1", "1/1/2/", "1/1/2/1/", "1/1/2/2/", "1/1/2/3/", "1/2/", "1/2/1", "1/2/2", "1/2/3/", "1/2/3/1", "1/2/3/2", "1/2/3/3", "1/2/3/4", "2", "2"});
        this.ensureExistsInWorkspace(result, true);
        result[result.length - 1] = root.getFolder((IPath)new Path("2/"));
        nonExistingResources.add(result[result.length - 1]);
        IResource[] deleted = this.buildResources(root, new String[]{"1/1/2/1/", "1/2/3/1"});
        this.ensureDoesNotExistInWorkspace(deleted);
        int i = 0;
        while (i < deleted.length) {
            nonExistingResources.add(deleted[i]);
            ++i;
        }
        IResource[] unsynchronized = this.buildResources(root, new String[]{"1/2/3/3"});
        this.ensureOutOfSync((IFile)unsynchronized[0]);
        unsynchronizedResources.add(unsynchronized[0]);
        unsynchronized = this.buildResources(root, new String[]{"1/1/2/2/1"});
        this.ensureExistsInFileSystem(unsynchronized);
        unsynchronizedResources.add(unsynchronized[0]);
        return result;
    }

    protected boolean checkAfterState(IResource receiver, IResource target, int state, int depth) {
        IResourceTest.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
        switch (state) {
            case 1: {
                this.assertExistsInFileSystem(target);
                if (this.hasParent(target, receiver, depth) || target.equals((Object)receiver)) {
                    this.assertExistsInWorkspace(target);
                    break;
                }
                this.assertDoesNotExistInWorkspace(target);
                break;
            }
            case 2: 
            case 3: {
                this.assertExistsInWorkspace(target);
                this.assertExistsInFileSystem(target);
                break;
            }
            case 0: {
                this.assertDoesNotExistInFileSystem(target);
                if (this.hasParent(target, receiver, depth) || target.equals((Object)receiver)) {
                    this.assertDoesNotExistInWorkspace(target);
                    break;
                }
                this.assertExistsInWorkspace(target);
                break;
            }
            case 4: {
                this.assertDoesNotExistInWorkspace(target);
                this.assertDoesNotExistInFileSystem(target);
                break;
            }
            case 5: {
                break;
            }
        }
        return true;
    }

    public void cleanUpAfterRefreshTest(Object[] args) {
        int depth;
        IResource receiver = (IResource)args[0];
        IResource target = (IResource)args[1];
        int state = (Integer)args[2];
        if (!this.makesSense(receiver, target, state, depth = ((Integer)args[3]).intValue())) {
            return;
        }
        try {
            IResourceTest.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"Exception tearing down in cleanUpAfterRefreshTest", (Throwable)e);
        }
        IResource changedTarget = IResourceTest.getWorkspace().getRoot().findMember(target.getFullPath());
        if (changedTarget != null && changedTarget.getType() != target.getType()) {
            this.ensureDoesNotExistInWorkspace(changedTarget);
        }
        this.ensureExistsInWorkspace(interestingResources, true);
    }

    protected IProject[] getProjects(IResource[] resources) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 4) {
                list.add(resources[i]);
            }
            ++i;
        }
        return list.toArray(new IProject[list.size()]);
    }

    protected boolean hasParent(IResource resource1, IResource resource2, int depth) {
        if (depth == 0) {
            return false;
        }
        if (depth == 1) {
            return resource2.equals((Object)resource1.getParent());
        }
        IContainer parent = resource1.getParent();
        while (parent != null) {
            if (parent.equals((Object)resource2)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected Integer[] interestingDepths() {
        return new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    }

    protected Integer[] interestingStates() {
        return new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};
    }

    protected boolean isFile(IResource r) {
        return r.getType() == 1;
    }

    protected boolean isFolder(IResource r) {
        return r.getType() == 2;
    }

    protected boolean isProject(IResource r) {
        return r.getType() == 4;
    }

    protected boolean makesSense(IResource receiver, IResource target, int state, int depth) {
        if (target.getType() == 4 || target.getType() == 8) {
            return false;
        }
        if (this.hasParent(receiver, target, 2)) {
            return false;
        }
        switch (state) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.isFile(target);
            }
            case 4: {
                return true;
            }
            case 5: {
                return this.isFolder(target);
            }
            case 6: {
                return this.isFile(target);
            }
        }
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceDescription description = IResourceTest.getWorkspace().getDescription();
        description.setAutoBuilding(false);
        IResourceTest.getWorkspace().setDescription(description);
        if (noSideEffects) {
            noSideEffects = false;
            return;
        }
        try {
            IProject openProject = IResourceTest.getWorkspace().getRoot().getProject("openProject");
            openProject.create(null);
            openProject.open(null);
            IResource[] resourcesInOpenProject = this.buildSampleResources((IContainer)openProject);
            IProject closedProject = IResourceTest.getWorkspace().getRoot().getProject("ClosedProject");
            closedProject.create(null);
            closedProject.open(null);
            IResource[] resourcesInClosedProject = this.buildSampleResources((IContainer)closedProject);
            closedProject.close(null);
            IProject nonExistingProject = IResourceTest.getWorkspace().getRoot().getProject("nonExistingProject");
            nonExistingProject.create(null);
            nonExistingProject.open(null);
            nonExistingProject.delete(true, null);
            Vector<Object> resources = new Vector<Object>();
            resources.addElement(openProject);
            int i = 0;
            while (i < resourcesInOpenProject.length) {
                resources.addElement(resourcesInOpenProject[i]);
                ++i;
            }
            resources.addElement(closedProject);
            i = 0;
            while (i < resourcesInClosedProject.length) {
                resources.addElement(resourcesInClosedProject[i]);
                nonExistingResources.add(resourcesInClosedProject[i]);
                ++i;
            }
            resources.addElement(nonExistingProject);
            nonExistingResources.add(nonExistingProject);
            interestingResources = new IResource[resources.size()];
            resources.copyInto(interestingResources);
            String[] interestingPathnames = new String[]{"1/", "1/1/", "1/1/1/", "1/1/1/1", "1/1/2/1/", "1/1/2/2/", "1/1/2/3/", "1/2/", "1/2/1", "1/2/2", "1/2/3/", "1/2/3/1", "1/2/3/2", "1/2/3/3", "1/2/3/4", "2", "2/1", "2/2", "2/3", "2/4", "2/1/", "2/2/", "2/3/", "2/4/", ".."};
            interestingPaths = new IPath[interestingPathnames.length];
            int i2 = 0;
            while (i2 < interestingPathnames.length) {
                IResourceTest.interestingPaths[i2] = new Path(interestingPathnames[i2]);
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void setupBeforeState(IResource receiver, IResource target, int state, int depth, boolean addVerifier) throws CoreException {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        }
        catch (InterruptedException interruptedException) {
            IResourceTest.fail((String)"interrupted unexpectedly");
        }
        if (addVerifier && this.verifier == null) {
            this.verifier = new ResourceDeltaVerifier();
            IResourceTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier);
        }
        this.ensureExistsInWorkspace((IResource)target.getParent(), true);
        switch (state) {
            case 0: {
                this.ensureExistsInWorkspace(target, true);
                this.ensureDoesNotExistInFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedDeletion(target);
                break;
            }
            case 1: {
                this.ensureDoesNotExistInWorkspace(target);
                this.ensureExistsInFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 1, 0);
                break;
            }
            case 2: {
                this.ensureExistsInWorkspace(target, true);
                if (!addVerifier) break;
                this.verifier.reset();
                break;
            }
            case 3: {
                this.ensureExistsInWorkspace(target, true);
                this.touchInFilesystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 4, 256);
                break;
            }
            case 4: {
                this.ensureDoesNotExistInWorkspace(target);
                this.ensureDoesNotExistInFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                break;
            }
            case 5: {
                this.ensureExistsInWorkspace(target, true);
                this.ensureDoesNotExistInFileSystem(target);
                this.ensureExistsInFileSystem(target);
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 4, 295168);
                break;
            }
            case 6: {
                this.ensureExistsInWorkspace(target, true);
                this.ensureDoesNotExistInFileSystem(target);
                target.getLocation().toFile().mkdirs();
                if (!addVerifier) break;
                this.verifier.reset();
                if (!this.hasParent(target, receiver, depth) && !target.equals((Object)receiver)) break;
                this.verifier.addExpectedChange(target, 4, 295168);
            }
        }
    }

    protected void tearDown() throws Exception {
        if (noSideEffects) {
            return;
        }
        if (this.verifier != null) {
            IResourceTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
        }
        IResourceTest.getWorkspace().getRoot().refreshLocal(2, null);
        this.ensureDoesNotExistInWorkspace((IResource)IResourceTest.getWorkspace().getRoot());
        interestingPaths = null;
        interestingResources = null;
        super.tearDown();
    }

    public void testAccept2() {
        noSideEffects = true;
        class LoggingResourceVisitor
        implements IResourceVisitor {
            Vector visitedResources = new Vector();

            LoggingResourceVisitor() {
            }

            void clear() {
                this.visitedResources.removeAllElements();
            }

            void recordVisit(IResource r) {
                this.visitedResources.addElement(r);
            }

            public boolean visit(IResource r) {
                throw new RuntimeException("this class is abstract");
            }
        }
        final LoggingResourceVisitor deepVisitor = new LoggingResourceVisitor(this){
            {
            }

            public boolean visit(IResource r) {
                this.recordVisit(r);
                return true;
            }
        };
        final LoggingResourceVisitor shallowVisitor = new LoggingResourceVisitor(this){
            {
            }

            public boolean visit(IResource r) {
                this.recordVisit(r);
                return false;
            }
        };
        LoggingResourceVisitor[] interestingVisitors = new LoggingResourceVisitor[]{shallowVisitor, deepVisitor};
        Object[][] inputs = new Object[][]{interestingResources, interestingVisitors, TRUE_AND_FALSE};
        new TestPerformer("IResourceTest.testAccept2"){
            {
                super($anonymous0);
            }

            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                IResourceVisitor visitor = (IResourceVisitor)args[1];
                Boolean includePhantoms = (Boolean)args[2];
                resource.accept(visitor, 2, includePhantoms.booleanValue());
                return null;
            }

            public boolean shouldFail(Object[] args, int count) {
                deepVisitor.clear();
                shallowVisitor.clear();
                IResource resource = (IResource)args[0];
                return nonExistingResources.contains(resource) || !resource.isAccessible();
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                IResource resource = (IResource)args[0];
                LoggingResourceVisitor visitor = (LoggingResourceVisitor)args[1];
                Vector visitedResources = visitor.visitedResources;
                if (visitor == shallowVisitor) {
                    return visitedResources.size() == 1 && visitedResources.elementAt(0).equals(resource);
                }
                if (visitor == deepVisitor) {
                    if (resource.getType() == 1) {
                        return visitedResources.size() == 1 && visitedResources.elementAt(0).equals(resource);
                    }
                    IContainer container = (IContainer)resource;
                    int memberCount = 0;
                    try {
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                    return visitedResources.size() >= (memberCount += container.members().length) + 1 && visitedResources.elementAt(0).equals(resource);
                }
                return false;
            }
        }.performTest(inputs);
    }

    public void testAcceptDoNotCheckExistence() throws CoreException {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder a = project.getFolder("a");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            a.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    IResourceTest.fail((String)"1.0");
                    return true;
                }
            }, 1, 0);
            IResourceTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            a.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) {
                    IResourceTest.fail((String)"2.0");
                    return true;
                }
            }, 0);
            IResourceTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        a.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                IResourceTest.fail((String)"3.0");
                return true;
            }
        }, 1, 16);
        a.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) {
                IResourceTest.fail((String)"4.0");
                return true;
            }
        }, 16);
    }

    public void testAcceptProxyVisitorWithDepth() throws CoreException {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder a = project.getFolder("a");
        IFile a1 = a.getFile("a1.txt");
        IFile a2 = a.getFile("a2.txt");
        IFolder b = a.getFolder("b");
        IFile b1 = b.getFile("b1.txt");
        IFile b2 = b.getFile("b2.txt");
        IFolder c = b.getFolder("c");
        IFile c1 = c.getFile("c1.txt");
        IFile c2 = c.getFile("c2.txt");
        final HashSet<IResource> toVisit = new HashSet<IResource>();
        final int[] toVisitCount = new int[1];
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) {
                toVisit.remove(proxy.requestResource());
                toVisitCount[0] = toVisitCount[0] - 1;
                return true;
            }
        };
        this.ensureExistsInWorkspace(new IResource[]{project, a, a1, a2, b, b1, b2, c, c1, c2}, true);
        toVisit.addAll(Arrays.asList(a));
        toVisitCount[0] = 1;
        a.accept(visitor, 0, 0);
        IResourceTest.assertTrue((String)"1.0", (boolean)toVisit.isEmpty());
        IResourceTest.assertTrue((String)"1.1", (toVisitCount[0] == 0 ? 1 : 0) != 0);
        toVisit.addAll(Arrays.asList(a, a1, a2, b));
        toVisitCount[0] = 4;
        a.accept(visitor, 1, 0);
        IResourceTest.assertTrue((String)"2.0", (boolean)toVisit.isEmpty());
        IResourceTest.assertTrue((String)"2.1", (toVisitCount[0] == 0 ? 1 : 0) != 0);
        toVisit.addAll(Arrays.asList(a, a1, a2, b, b1, b2, c, c1, c2));
        toVisitCount[0] = 9;
        a.accept(visitor, 2, 0);
        IResourceTest.assertTrue((String)"3.0", (boolean)toVisit.isEmpty());
        IResourceTest.assertTrue((String)"3.1", (toVisitCount[0] == 0 ? 1 : 0) != 0);
    }

    public void testAddLocalProject() throws CoreException {
        IProject project1 = IResourceTest.getWorkspace().getRoot().getProject("Project");
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        IProject project2 = IResourceTest.getWorkspace().getRoot().getProject("NewProject");
        IPath projectPath = project1.getLocation().removeLastSegments(1).append("NewProject");
        try {
            projectPath.toFile().mkdirs();
            project1.refreshLocal(2, this.getMonitor());
            project2.refreshLocal(2, this.getMonitor());
            IResourceTest.assertTrue((String)"1.1", (boolean)project1.exists());
            IResourceTest.assertTrue((String)"1.2", (boolean)project1.isSynchronized(2));
            IResourceTest.assertTrue((String)"1.3", (!project2.exists() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"1.4", (boolean)project2.isSynchronized(2));
        }
        finally {
            Workspace.clear((File)projectPath.toFile());
        }
    }

    public void testConstants() {
        IResourceTest.assertEquals((String)"1.0", (int)0, (int)0);
        IResourceTest.assertEquals((String)"2.1", (int)1, (int)1);
        IResourceTest.assertEquals((String)"2.2", (int)2, (int)2);
        IResourceTest.assertEquals((String)"2.3", (int)4, (int)4);
        IResourceTest.assertEquals((String)"2.4", (int)8, (int)8);
        IResourceTest.assertEquals((String)"3.1", (int)0, (int)0);
        IResourceTest.assertEquals((String)"3.2", (int)1, (int)1);
        IResourceTest.assertEquals((String)"3.1", (int)2, (int)2);
        IResourceTest.assertEquals((String)"4.1", (int)-1, (int)-1);
        IResourceTest.assertEquals((String)"5.1", (int)1, (int)1);
        IResourceTest.assertEquals((String)"5.2", (int)2, (int)2);
        IResourceTest.assertEquals((String)"5.3", (int)4, (int)4);
        IResourceTest.assertEquals((String)"5.4", (int)8, (int)8);
        IResourceTest.assertEquals((String)"6.1", (int)1, (int)1);
        IResourceTest.assertEquals((String)"6.2", (int)2, (int)2);
        IResourceTest.assertEquals((String)"6.2", (int)8, (int)8);
    }

    public void testCopy() {
        try {
            IResourceTest.getWorkspace().getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.isAccessible()) {
                        resource.createMarker("org.eclipse.core.resources.taskmarker");
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        Object[][] inputs = new Object[][]{interestingResources, interestingPaths, TRUE_AND_FALSE, PROGRESS_MONITORS};
        new TestPerformer("IResourceTest.testCopy"){

            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                Boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                resource.copy(destination, force.booleanValue(), monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            public boolean shouldFail(Object[] args, int count) {
                File destinationFile;
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                if (!resource.isAccessible()) {
                    return true;
                }
                if (IResourceTest.this.isProject(resource) && destination.segmentCount() > 1 && !IResourceTest.getWorkspace().validatePath(destination.toString(), 2).isOK()) {
                    return true;
                }
                File destinationParent = destination.isAbsolute() ? destination.removeLastSegments(1).toFile() : resource.getLocation().removeLastSegments(1).append(destination.removeLastSegments(1)).toFile();
                File file = destinationFile = destination.isAbsolute() ? destination.toFile() : resource.getLocation().removeLastSegments(1).append(destination).removeTrailingSeparator().toFile();
                return !destinationParent.exists() || !destinationParent.isDirectory() || destinationFile.exists() || destinationFile.toString().startsWith(resource.getLocation().toFile().toString());
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws CoreException {
                IResource source = (IResource)args[0];
                IPath destination = (IPath)args[1];
                IPath path = destination.isAbsolute() ? destination : source.getParent().getFullPath().append(destination);
                IResource copy = IResourceTest.getWorkspace().getRoot().findMember(path);
                if (copy == null) {
                    return false;
                }
                if (!copy.exists()) {
                    return false;
                }
                return copy.findMarkers("org.eclipse.core.resources.taskmarker", true, 2).length <= 0;
            }
        }.performTest(inputs);
    }

    public void testDelete() {
        IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[2];
        iProgressMonitorArray[0] = new FussyProgressMonitor();
        IProgressMonitor[] monitors = iProgressMonitorArray;
        Object[][] inputs = new Object[][]{FALSE_AND_TRUE, monitors, interestingResources};
        new TestPerformer("IResourceTest.testDelete"){

            public Object[] interestingOldState(Object[] args) throws Exception {
                Boolean force = (Boolean)args[0];
                IResource resource = (IResource)args[2];
                return new Object[]{new Boolean(resource.isAccessible()), IResourceTest.getAllFilesForResource(resource, force), IResourceTest.getAllResourcesForResource(resource)};
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                Boolean force = (Boolean)args[0];
                IProgressMonitor monitor = (IProgressMonitor)args[1];
                IResource resource = (IResource)args[2];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                try {
                    resource.delete(force.booleanValue(), monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return "canceled";
                }
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean shouldFail(Object[] args, int count) {
                Boolean force = (Boolean)args[0];
                IProgressMonitor monitor = (IProgressMonitor)args[1];
                IResource resource = (IResource)args[2];
                if (monitor instanceof CancelingProgressMonitor) {
                    return false;
                }
                if (force != false) return false;
                if (!resource.exists()) {
                    return false;
                }
                if (resource.getType() == 4) {
                    IProject project = (IProject)resource;
                    try {
                        if (!project.isOpen()) {
                            return false;
                        }
                        IResource[] children = project.members();
                        int i = 0;
                        while (true) {
                            if (i >= children.length) {
                                return false;
                            }
                            IResource member = children[i];
                            if (this.shouldFail(new Object[]{args[0], args[1], member}, count)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("there is a problem in the testing method 'shouldFail'");
                    }
                }
                final boolean[] hasUnsynchronizedResources = new boolean[1];
                try {
                    resource.accept(new IResourceVisitor(){

                        public boolean visit(IResource toVisit) throws CoreException {
                            File target = toVisit.getLocation().toFile();
                            if (target.exists() != toVisit.exists()) {
                                hasUnsynchronizedResources[0] = true;
                                return false;
                            }
                            if (target.isFile() != (toVisit.getType() == 1)) {
                                hasUnsynchronizedResources[0] = true;
                                return false;
                            }
                            if (unsynchronizedResources.contains(toVisit)) {
                                hasUnsynchronizedResources[0] = true;
                                return false;
                            }
                            if (target.isFile()) {
                                return false;
                            }
                            String[] list = target.list();
                            if (list == null) {
                                return true;
                            }
                            IContainer container = (IContainer)toVisit;
                            int i = 0;
                            while (i < list.length) {
                                IFile child;
                                File file = new File(target, list[i]);
                                Object object = child = file.isFile() ? container.getFile((IPath)new Path(list[i])) : container.getFolder((IPath)new Path(list[i]));
                                if (!child.exists()) {
                                    this.visit((IResource)child);
                                }
                                ++i;
                            }
                            return true;
                        }
                    });
                    return hasUnsynchronizedResources[0];
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("there is a problem in the testing method 'shouldFail'");
                }
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                Boolean force = (Boolean)args[0];
                IProgressMonitor monitor = (IProgressMonitor)args[1];
                IResource resource = (IResource)args[2];
                if (result == "canceled") {
                    return monitor instanceof CancelingProgressMonitor;
                }
                if (resource.getType() != 4 && ((Boolean)oldState[0]).booleanValue()) {
                    IResource[] children = ((IContainer)IResourceTest.getWorkspace().getRoot().findMember(resource.getFullPath().removeLastSegments(1))).members();
                    int i = 0;
                    while (i < children.length) {
                        if (resource == children[i]) {
                            return false;
                        }
                        ++i;
                    }
                }
                if (!IResourceTest.getAllFilesForResource(resource, force).isEmpty()) {
                    return false;
                }
                Set oldFiles = (Set)oldState[1];
                for (File oldFile : oldFiles) {
                    if (!oldFile.exists()) continue;
                    return false;
                }
                Set oldResources = (Set)oldState[2];
                for (IResource oldResource : oldResources) {
                    if (!oldResource.exists() && IResourceTest.getWorkspace().getRoot().findMember(oldResource.getFullPath()) == null) continue;
                    return false;
                }
                return true;
            }
        }.performTest(inputs);
    }

    public void testDerived() {
        IWorkspaceRoot root = IResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("target");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            folder.create(true, true, this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        this.verifier = new ResourceDeltaVerifier();
        IResourceTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier, 1);
        try {
            IResourceTest.assertTrue((String)"2.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.4", (!file.isDerived() ? 1 : 0) != 0);
            root.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"2.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("2.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            root.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"2.3.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("2.3.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            project.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"3.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("3.1.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            project.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"3.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("3.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)folder, 4, 0x400000);
            folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"4.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.1.3", (boolean)folder.isDerived());
            IResourceTest.assertTrue((String)"4.1.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("4.1.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)folder, 4, 0x400000);
            folder.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"4.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("4.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)file, 4, 0x400000);
            file.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"5.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.4", (boolean)file.isDerived());
            IResourceTest.assertTrue((String)("5.1.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
            this.verifier.addExpectedChange((IResource)file, 4, 0x400000);
            file.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"5.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.4", (!file.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)("5.2.5" + this.verifier.getMessage()), (boolean)this.verifier.isDeltaValid());
            this.verifier.reset();
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"7.0", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"8.1", (!project.isDerived() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"8.2", (!folder.isDerived() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"8.3", (!file.isDerived() ? 1 : 0) != 0);
        try {
            project.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"9.1", (boolean)false);
        }
        catch (CoreException coreException) {}
        try {
            folder.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"9.2", (boolean)false);
        }
        catch (CoreException coreException) {}
        try {
            file.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
            IResourceTest.assertTrue((String)"9.3", (boolean)false);
        }
        catch (CoreException coreException) {}
    }

    public void testDeprecatedDerived() {
        IWorkspaceRoot root = IResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("target");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            folder.create(true, true, this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IResourceTest.assertTrue((String)"2.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.4", (!file.isDerived() ? 1 : 0) != 0);
            root.setDerived(true);
            IResourceTest.assertTrue((String)"2.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.4", (!file.isDerived() ? 1 : 0) != 0);
            root.setDerived(false);
            IResourceTest.assertTrue((String)"2.3.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.4", (!file.isDerived() ? 1 : 0) != 0);
            project.setDerived(true);
            IResourceTest.assertTrue((String)"3.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.4", (!file.isDerived() ? 1 : 0) != 0);
            project.setDerived(false);
            IResourceTest.assertTrue((String)"3.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.4", (!file.isDerived() ? 1 : 0) != 0);
            folder.setDerived(true);
            IResourceTest.assertTrue((String)"4.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.1.3", (boolean)folder.isDerived());
            IResourceTest.assertTrue((String)"4.1.4", (!file.isDerived() ? 1 : 0) != 0);
            folder.setDerived(false);
            IResourceTest.assertTrue((String)"4.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.4", (!file.isDerived() ? 1 : 0) != 0);
            file.setDerived(true);
            IResourceTest.assertTrue((String)"5.1.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.4", (boolean)file.isDerived());
            file.setDerived(false);
            IResourceTest.assertTrue((String)"5.2.1", (!root.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.2", (!project.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.3", (!folder.isDerived() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.4", (!file.isDerived() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"7.0", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"8.1", (!project.isDerived() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"8.2", (!folder.isDerived() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"8.3", (!file.isDerived() ? 1 : 0) != 0);
        try {
            project.setDerived(false);
            IResourceTest.assertTrue((String)"9.1", (boolean)false);
        }
        catch (CoreException coreException) {}
        try {
            folder.setDerived(false);
            IResourceTest.assertTrue((String)"9.2", (boolean)false);
        }
        catch (CoreException coreException) {}
        try {
            file.setDerived(false);
            IResourceTest.assertTrue((String)"9.3", (boolean)false);
        }
        catch (CoreException coreException) {}
    }

    public void testDerivedUsingAncestors() {
        IResource resource;
        IWorkspaceRoot root = IResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IResource[] resources = new IResource[]{project, folder, file1, file2};
        this.ensureExistsInWorkspace(resources, true);
        int i = 0;
        while (i < resources.length) {
            resource = resources[i];
            IResourceTest.assertTrue((String)("1.0: " + resource.getFullPath()), (!resource.isDerived() ? 1 : 0) != 0);
            ++i;
        }
        try {
            root.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)("2.0: " + root.getFullPath()), (Throwable)e);
        }
        IResourceTest.assertTrue((String)("2.1: " + root.getFullPath()), (!root.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("2.2: " + project.getFullPath()), (!project.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("2.3: " + folder.getFullPath()), (!folder.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("2.4: " + file1.getFullPath()), (!file1.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("2.5: " + file2.getFullPath()), (!file2.isDerived(512) ? 1 : 0) != 0);
        try {
            project.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)("3.0: " + project.getFullPath()), (Throwable)e);
        }
        IResourceTest.assertTrue((String)("3.0: " + project.getFullPath()), (!project.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("3.1: " + folder.getFullPath()), (!folder.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("3.2: " + file1.getFullPath()), (!file1.isDerived(512) ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("3.3: " + file2.getFullPath()), (!file2.isDerived(512) ? 1 : 0) != 0);
        try {
            folder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)("4.0: " + folder.getFullPath()), (Throwable)e);
        }
        IResourceTest.assertTrue((String)("4.1: " + folder.getFullPath()), (boolean)folder.isDerived());
        IResourceTest.assertTrue((String)("4.2: " + file1.getFullPath()), (!file1.isDerived() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("4.3: " + file2.getFullPath()), (!file2.isDerived() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)("4.4: " + folder.getFullPath()), (boolean)folder.isDerived(512));
        IResourceTest.assertTrue((String)("4.5: " + file1.getFullPath()), (boolean)file1.isDerived(512));
        IResourceTest.assertTrue((String)("4.6: " + file2.getFullPath()), (boolean)file2.isDerived(512));
        try {
            folder.setDerived(false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)("6.0: " + folder.getFullPath()), (Throwable)e);
        }
        i = 0;
        while (i < resources.length) {
            resource = resources[i];
            IResourceTest.assertTrue((String)("7.0: " + resource.getFullPath()), (!resource.isDerived() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testEquals() {
        noSideEffects = true;
        Object[][] inputs = new Object[][]{interestingResources, interestingResources};
        new TestPerformer("IResourceTest.testEquals"){

            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource0 = (IResource)args[0];
                IResource resource1 = (IResource)args[1];
                return resource0.equals((Object)resource1) ? Boolean.TRUE : Boolean.FALSE;
            }

            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                boolean expectedResult;
                IResource resource0 = (IResource)args[0];
                IResource resource1 = (IResource)args[1];
                boolean booleanResult = (Boolean)result;
                boolean bl = expectedResult = resource0.getFullPath().equals((Object)resource1.getFullPath()) && resource0.getType() == resource1.getType() && resource0.getWorkspace().equals(resource1.getWorkspace());
                if (booleanResult) {
                    IResourceTest.assertTrue((String)"hashCode should be equal if equals returns true", (resource0.hashCode() == resource1.hashCode() ? 1 : 0) != 0);
                }
                return booleanResult == expectedResult;
            }
        }.performTest(inputs);
    }

    public void testExists() {
        noSideEffects = true;
        Object[][] inputs = new Object[][]{interestingResources};
        new TestPerformer("IResourceTest.testExists"){

            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                return resource.exists() ? Boolean.TRUE : Boolean.FALSE;
            }

            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                boolean booleanResult = (Boolean)result;
                IResource resource = (IResource)args[0];
                return booleanResult ^ nonExistingResources.contains(resource);
            }
        }.performTest(inputs);
    }

    public void testGetLocation() {
        noSideEffects = true;
        Object[][] inputs = new Object[][]{interestingResources};
        new TestPerformer("IResourceTest.testGetLocation"){

            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                return resource.getLocation();
            }

            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                IResource resource = (IResource)args[0];
                IPath resultPath = (IPath)result;
                if (resource.getType() == 4) {
                    if (!resource.exists()) {
                        return resultPath == null;
                    }
                    return resultPath != null;
                }
                if (!resource.getProject().exists()) {
                    return resultPath == null;
                }
                return resultPath != null;
            }
        }.performTest(inputs);
    }

    public void testGetModificationStamp() {
        IResource resource;
        IProject project;
        try {
            IResourceTest.getWorkspace().getRoot().delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"0.0", (Throwable)e);
        }
        IResource[] resources = this.buildResources((IContainer)IResourceTest.getWorkspace().getRoot(), new String[]{"/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1"});
        HashMap<Object, Long> table = new HashMap<Object, Long>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource2 = resources[i];
            if (resource2.getType() != 8) {
                IResourceTest.assertEquals((String)("1.0." + resource2.getFullPath()), (long)-1L, (long)resource2.getModificationStamp());
            }
            ++i;
        }
        IProject[] projects = this.getProjects(resources);
        int i2 = 0;
        while (i2 < projects.length) {
            project = projects[i2];
            try {
                project.create(this.getMonitor());
            }
            catch (CoreException e) {
                IResourceTest.fail((String)("2.0." + project.getFullPath()), (Throwable)e);
            }
            IResourceTest.assertEquals((String)("2.1." + project.getFullPath()), (long)-1L, (long)project.getModificationStamp());
            ++i2;
        }
        i2 = 0;
        while (i2 < projects.length) {
            project = projects[i2];
            IResourceTest.assertEquals((String)("3.1." + project.getFullPath()), (long)-1L, (long)project.getModificationStamp());
            try {
                project.open(this.getMonitor());
            }
            catch (CoreException e) {
                IResourceTest.fail((String)"3.2", (Throwable)e);
            }
            IResourceTest.assertTrue((String)("3.3." + project.getFullPath()), (project.getModificationStamp() != -1L ? 1 : 0) != 0);
            table.put(project.getFullPath(), new Long(project.getModificationStamp()));
            ++i2;
        }
        i2 = 0;
        while (i2 < resources.length) {
            resource = resources[i2];
            if (resource.getType() != 4) {
                IResourceTest.assertEquals((String)("3.4." + resource.getFullPath()), (long)-1L, (long)resource.getModificationStamp());
                this.ensureExistsInWorkspace(resource, true);
                IResourceTest.assertTrue((String)("3.5." + resource.getFullPath()), (resource.getModificationStamp() != -1L ? 1 : 0) != 0);
                table.put(resource.getFullPath(), new Long(resource.getModificationStamp()));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < projects.length) {
            project = projects[i2];
            try {
                project.close(this.getMonitor());
            }
            catch (CoreException e) {
                IResourceTest.fail((String)("4.0." + project.getFullPath()), (Throwable)e);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < resources.length) {
            resource = resources[i2];
            if (resource.getType() != 8) {
                IResourceTest.assertEquals((String)("4.1." + resource.getFullPath()), (long)-1L, (long)resource.getModificationStamp());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < projects.length) {
            project = projects[i2];
            try {
                project.open(this.getMonitor());
            }
            catch (CoreException e) {
                IResourceTest.fail((String)("5.0." + project.getFullPath()), (Throwable)e);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < resources.length) {
            resource = resources[i2];
            if (resource.getType() != 4) {
                Object v = table.get(resource.getFullPath());
                IResourceTest.assertNotNull((String)("5.1." + resource.getFullPath()), v);
                long old = (Long)v;
                IResourceTest.assertEquals((String)("5.2." + resource.getFullPath()), (long)old, (long)resource.getModificationStamp());
            }
            ++i2;
        }
        HashMap<IPath, Long> tempTable = new HashMap<IPath, Long>(resources.length);
        int i3 = 0;
        while (i3 < resources.length) {
            IResource resource3 = resources[i3];
            if (resource3.getType() != 8) {
                try {
                    resource3.touch(this.getMonitor());
                }
                catch (CoreException e) {
                    IResourceTest.fail((String)"6.2", (Throwable)e);
                }
                long stamp = resource3.getModificationStamp();
                Object v = table.get(resource3.getFullPath());
                IResourceTest.assertNotNull((String)("6.0." + resource3.getFullPath()), v);
                long old = (Long)v;
                IResourceTest.assertTrue((String)("6.1." + resource3.getFullPath()), (old != stamp ? 1 : 0) != 0);
                tempTable.put(resource3.getFullPath(), new Long(stamp));
            }
            ++i3;
        }
        table.clear();
        table.putAll(tempTable);
        try {
            IResourceTest.getWorkspace().getRoot().setLocal(false, 2, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"7.1", (Throwable)e);
        }
        Object visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (resource.getType() == 8 || resource.getType() == 4) {
                    IResourceTest.assertTrue((String)("7.2" + resource.getFullPath()), (-1L != resource.getModificationStamp() ? 1 : 0) != 0);
                } else {
                    IResourceTest.assertEquals((String)("7.3." + resource.getFullPath()), (long)-1L, (long)resource.getModificationStamp());
                }
                return true;
            }
        };
        try {
            IResourceTest.getWorkspace().getRoot().accept(visitor, 2, false);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"7.4", (Throwable)e);
        }
        try {
            IResourceTest.getWorkspace().getRoot().setLocal(true, 2, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"8.1", (Throwable)e);
        }
        tempTable.clear();
        int i4 = 0;
        while (i4 < resources.length) {
            IResource resource4 = resources[i4];
            if (resource4.getType() != 8) {
                long stamp = resource4.getModificationStamp();
                IResourceTest.assertTrue((String)("8.2." + resource4.getFullPath()), (stamp != -1L ? 1 : 0) != 0);
                Object v = table.get(resource4.getFullPath());
                IResourceTest.assertNotNull((String)("8.3." + resource4.getFullPath()), v);
                long old = (Long)v;
                IResourceTest.assertTrue((String)("8.4." + resource4.getFullPath()), (old != -1L ? 1 : 0) != 0);
                tempTable.put(resource4.getFullPath(), new Long(stamp));
            }
            ++i4;
        }
        table.clear();
        table.putAll(tempTable);
        try {
            IResourceTest.getWorkspace().getRoot().setLocal(true, 2, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"9.1", (Throwable)e);
        }
        i = 0;
        while (i < resources.length) {
            IResource resource5 = resources[i];
            if (resource5.getType() != 8) {
                long newStamp = resource5.getModificationStamp();
                IResourceTest.assertTrue((String)("9.2." + resource5.getFullPath()), (newStamp != -1L ? 1 : 0) != 0);
                Object v = table.get(resource5.getFullPath());
                IResourceTest.assertNotNull((String)("9.3." + resource5.getFullPath()), v);
                long oldStamp = (Long)v;
                IResourceTest.assertEquals((String)("9.4." + resource5.getFullPath()), (long)oldStamp, (long)newStamp);
            }
            ++i;
        }
        try {
            IResourceTest.getWorkspace().getRoot().delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"10.0", (Throwable)e);
        }
        i = 0;
        while (i < resources.length) {
            IResource resource6 = resources[i];
            if (resource6.getType() != 8) {
                IResourceTest.assertEquals((String)("10.1" + resource6.getFullPath()), (long)-1L, (long)resource6.getModificationStamp());
            }
            ++i;
        }
        this.ensureExistsInWorkspace(resources, false);
        i = 0;
        while (i < resources.length) {
            IResource resource7 = resources[i];
            switch (resource7.getType()) {
                case 8: {
                    break;
                }
                case 4: {
                    IResourceTest.assertTrue((String)("11.1." + resource7.getFullPath()), (resource7.getModificationStamp() != -1L ? 1 : 0) != 0);
                    break;
                }
                default: {
                    IResourceTest.assertEquals((String)("11.2." + resource7.getFullPath()), (long)-1L, (long)resource7.getModificationStamp());
                }
            }
            ++i;
        }
        try {
            IResourceTest.getWorkspace().getRoot().setLocal(true, 2, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"12.0", (Throwable)e);
        }
        visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (resource.getType() != 8) {
                    IResourceTest.assertTrue((String)("12.1." + resource.getFullPath()), (-1L != resource.getModificationStamp() ? 1 : 0) != 0);
                }
                return true;
            }
        };
        try {
            IResourceTest.getWorkspace().getRoot().accept(visitor, 2, false);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"12.2", (Throwable)e);
        }
    }

    public void testGetModificationStampAfterReplace() throws Exception {
        final IFile file = IResourceTest.getWorkspace().getRoot().getFile((IPath)new Path("/project/f"));
        this.create((IResource)file, true);
        long modificationStamp = file.getModificationStamp();
        IResourceTest.assertTrue((String)"1.1", (modificationStamp != -1L ? 1 : 0) != 0);
        IResourceTest.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.delete(false, IResourceTest.this.getMonitor());
                IResourceTest.this.create((IResource)file, true);
            }
        }, this.getMonitor());
        IResourceTest.assertTrue((String)"1.0", (modificationStamp != file.getModificationStamp() ? 1 : 0) != 0);
    }

    public void testGetRawLocation() {
        block13: {
            IProject project = IResourceTest.getWorkspace().getRoot().getProject("Project");
            IFolder topFolder = project.getFolder("TopFolder");
            IFile topFile = project.getFile("TopFile");
            IFile deepFile = topFolder.getFile("DeepFile");
            IResource[] allResources = new IResource[]{project, topFolder, topFile, deepFile};
            IResourceTest.assertNull((String)"2.0", (Object)project.getRawLocation());
            IResourceTest.assertNull((String)"2.1", (Object)topFolder.getRawLocation());
            IResourceTest.assertNull((String)"2.2", (Object)topFile.getRawLocation());
            IResourceTest.assertNull((String)"2.3", (Object)deepFile.getRawLocation());
            this.ensureExistsInWorkspace(allResources, true);
            IResourceTest.assertNull((String)"2.0", (Object)project.getRawLocation());
            IPath workspaceLocation = IResourceTest.getWorkspace().getRoot().getLocation();
            IResourceTest.assertEquals((String)"2.1", (Object)workspaceLocation.append(topFolder.getFullPath()), (Object)topFolder.getRawLocation());
            IResourceTest.assertEquals((String)"2.2", (Object)workspaceLocation.append(topFile.getFullPath()), (Object)topFile.getRawLocation());
            IResourceTest.assertEquals((String)"2.3", (Object)workspaceLocation.append(deepFile.getFullPath()), (Object)deepFile.getRawLocation());
            try {
                project.close(this.getMonitor());
            }
            catch (CoreException e) {
                IResourceTest.fail((String)"1.99", (Throwable)e);
            }
            IResourceTest.assertNull((String)"3.0", (Object)project.getRawLocation());
            IResourceTest.assertEquals((String)"3.1", (Object)workspaceLocation.append(topFolder.getFullPath()), (Object)topFolder.getRawLocation());
            IResourceTest.assertEquals((String)"3.2", (Object)workspaceLocation.append(topFile.getFullPath()), (Object)topFile.getRawLocation());
            IResourceTest.assertEquals((String)"3.3", (Object)workspaceLocation.append(deepFile.getFullPath()), (Object)deepFile.getRawLocation());
            IPath projectLocation = this.getRandomLocation();
            IPath folderLocation = this.getRandomLocation();
            IPath fileLocation = this.getRandomLocation();
            IPath variableLocation = this.getRandomLocation();
            IPathVariableManager varMan = IResourceTest.getWorkspace().getPathVariableManager();
            try {
                try {
                    varMan.setValue("IResourceTest_VariableName", variableLocation);
                    project.open(this.getMonitor());
                    IProjectDescription description = project.getDescription();
                    description.setLocation(projectLocation);
                    project.move(description, 0, this.getMonitor());
                    IResourceTest.assertEquals((String)"4.0", (Object)projectLocation, (Object)project.getRawLocation());
                    IResourceTest.assertEquals((String)"4.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
                    IResourceTest.assertEquals((String)"4.2", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
                    IResourceTest.assertEquals((String)"4.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
                    project.close(this.getMonitor());
                    IResourceTest.assertEquals((String)"5.0", (Object)projectLocation, (Object)project.getRawLocation());
                    IResourceTest.assertEquals((String)"5.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
                    IResourceTest.assertEquals((String)"5.2", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
                    IResourceTest.assertEquals((String)"5.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
                    project.open(this.getMonitor());
                    this.ensureDoesNotExistInWorkspace((IResource)topFolder);
                    this.ensureDoesNotExistInWorkspace((IResource)topFile);
                    this.createFileInFileSystem(EFS.getFileSystem((String)"file").getStore(fileLocation));
                    folderLocation.toFile().mkdirs();
                    topFolder.createLink(folderLocation, 0, this.getMonitor());
                    topFile.createLink(fileLocation, 0, this.getMonitor());
                    this.ensureExistsInWorkspace((IResource)deepFile, true);
                    IResourceTest.assertEquals((String)"6.0", (Object)fileLocation, (Object)topFile.getRawLocation());
                    IResourceTest.assertEquals((String)"6.1", (Object)folderLocation, (Object)topFolder.getRawLocation());
                    IResourceTest.assertEquals((String)"6.2", (Object)folderLocation.append(deepFile.getName()), (Object)deepFile.getRawLocation());
                    project.close(this.getMonitor());
                    IResourceTest.assertEquals((String)"7.0", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
                    IResourceTest.assertEquals((String)"7.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
                    IResourceTest.assertEquals((String)"7.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
                    project.open(this.getMonitor());
                    IPath variableFolderLocation = new Path("IResourceTest_VariableName").append("/VarFolderName");
                    IPath variableFileLocation = new Path("IResourceTest_VariableName").append("/VarFileName");
                    this.ensureDoesNotExistInWorkspace((IResource)topFolder);
                    this.ensureDoesNotExistInWorkspace((IResource)topFile);
                    this.createFileInFileSystem(EFS.getFileSystem((String)"file").getStore(varMan.resolvePath(variableFileLocation)));
                    varMan.resolvePath(variableFolderLocation).toFile().mkdirs();
                    topFolder.createLink(variableFolderLocation, 0, this.getMonitor());
                    topFile.createLink(variableFileLocation, 0, this.getMonitor());
                    this.ensureExistsInWorkspace((IResource)deepFile, true);
                    IResourceTest.assertEquals((String)"8.0", (Object)variableFileLocation, (Object)topFile.getRawLocation());
                    IResourceTest.assertEquals((String)"8.1", (Object)variableFolderLocation, (Object)topFolder.getRawLocation());
                    IResourceTest.assertEquals((String)"8.3", (Object)varMan.resolvePath(variableFolderLocation).append(deepFile.getName()), (Object)deepFile.getRawLocation());
                    project.close(this.getMonitor());
                    IResourceTest.assertEquals((String)"9.0", (Object)projectLocation.append(topFile.getProjectRelativePath()), (Object)topFile.getRawLocation());
                    IResourceTest.assertEquals((String)"9.1", (Object)projectLocation.append(topFolder.getProjectRelativePath()), (Object)topFolder.getRawLocation());
                    IResourceTest.assertEquals((String)"9.3", (Object)projectLocation.append(deepFile.getProjectRelativePath()), (Object)deepFile.getRawLocation());
                }
                catch (CoreException e) {
                    IResourceTest.fail((String)"99.99", (Throwable)e);
                    try {
                        IResourceTest.getWorkspace().getRoot().delete(5, this.getMonitor());
                        varMan.setValue("IResourceTest_VariableName", null);
                    }
                    catch (CoreException coreException) {}
                    Workspace.clear((File)projectLocation.toFile());
                    Workspace.clear((File)folderLocation.toFile());
                    Workspace.clear((File)fileLocation.toFile());
                    Workspace.clear((File)variableLocation.toFile());
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    IResourceTest.getWorkspace().getRoot().delete(5, this.getMonitor());
                    varMan.setValue("IResourceTest_VariableName", null);
                }
                catch (CoreException coreException) {}
                Workspace.clear((File)projectLocation.toFile());
                Workspace.clear((File)folderLocation.toFile());
                Workspace.clear((File)fileLocation.toFile());
                Workspace.clear((File)variableLocation.toFile());
                throw throwable;
            }
            try {
                IResourceTest.getWorkspace().getRoot().delete(5, this.getMonitor());
                varMan.setValue("IResourceTest_VariableName", null);
            }
            catch (CoreException coreException) {}
            Workspace.clear((File)projectLocation.toFile());
            Workspace.clear((File)folderLocation.toFile());
            Workspace.clear((File)fileLocation.toFile());
            Workspace.clear((File)variableLocation.toFile());
        }
    }

    public void testIsConflicting() throws CoreException {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("Project");
        IFolder a = project.getFolder("a");
        IFolder b = project.getFolder("b");
        this.ensureExistsInWorkspace(new IResource[]{project, a, b}, true);
        ISchedulingRule multi = MultiRule.combine((ISchedulingRule)a, (ISchedulingRule)b);
        IResourceTest.assertEquals((boolean)false, (boolean)a.isConflicting((ISchedulingRule)b));
        IResourceTest.assertEquals((boolean)false, (boolean)b.isConflicting((ISchedulingRule)a));
        IResourceTest.assertEquals((boolean)true, (boolean)a.isConflicting(multi));
        IResourceTest.assertEquals((boolean)true, (boolean)multi.isConflicting((ISchedulingRule)a));
        IResourceTest.assertEquals((boolean)true, (boolean)b.isConflicting(multi));
        IResourceTest.assertEquals((boolean)true, (boolean)multi.isConflicting((ISchedulingRule)b));
        project.delete(true, this.getMonitor());
    }

    public void testIsConflicting2() throws CoreException {
        final IProject project = IResourceTest.getWorkspace().getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        ISchedulingRule wrapper = new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return this == rule || project.isConflicting(rule);
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule || project.contains(rule);
            }
        };
        ISchedulingRule multi = MultiRule.combine((ISchedulingRule)wrapper, (ISchedulingRule)new ISchedulingRule(){

            public boolean isConflicting(ISchedulingRule rule) {
                return this == rule;
            }

            public boolean contains(ISchedulingRule rule) {
                return this == rule;
            }
        });
        IResourceTest.assertEquals((boolean)false, (boolean)project.isConflicting(wrapper));
        IResourceTest.assertEquals((boolean)false, (boolean)project.isConflicting(multi));
        IResourceTest.assertEquals((boolean)true, (boolean)wrapper.isConflicting((ISchedulingRule)project));
        IResourceTest.assertEquals((boolean)true, (boolean)multi.isConflicting((ISchedulingRule)project));
        project.delete(true, this.getMonitor());
    }

    public void testIsSynchronized() {
        try {
            IResourceTest.getWorkspace().getRoot().delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        interestingResources = this.buildInterestingResources();
        Object[][] inputs = new Object[][]{interestingResources, interestingResources, this.interestingStates(), this.interestingDepths()};
        new TestPerformer("IResourceTest.testRefreshLocal"){

            public void cleanUp(Object[] args, int count) {
                IResourceTest.this.cleanUpAfterRefreshTest(args);
            }

            public Object invokeMethod(Object[] args, int count) throws CoreException {
                int depth;
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                if (!IResourceTest.this.makesSense(receiver, target, state, depth = ((Integer)args[3]).intValue())) {
                    return null;
                }
                IResourceTest.this.setupBeforeState(receiver, target, state, depth, false);
                boolean result = receiver.isSynchronized(depth);
                return result ? Boolean.TRUE : Boolean.FALSE;
            }

            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                if (result == null) {
                    return true;
                }
                boolean bResult = (Boolean)result;
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                int depth = (Integer)args[3];
                if (!receiver.equals((Object)target) && !IResourceTest.this.hasParent(target, receiver, depth)) {
                    return bResult;
                }
                switch (state) {
                    case 2: 
                    case 4: {
                        return bResult;
                    }
                    case 0: 
                    case 1: 
                    case 3: 
                    case 5: 
                    case 6: {
                        return !bResult;
                    }
                }
                return false;
            }
        }.performTest(inputs);
    }

    public void testMove() {
        Object[][] inputs = new Object[][]{interestingResources, interestingPaths, TRUE_AND_FALSE, PROGRESS_MONITORS};
        new TestPerformer("IResourceTest.testMove"){

            public Object[] interestingOldState(Object[] args) {
                return null;
            }

            public Object invokeMethod(Object[] args, int count) throws Exception {
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                Boolean force = (Boolean)args[2];
                IProgressMonitor monitor = (IProgressMonitor)args[3];
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).prepare();
                }
                resource.move(destination, force.booleanValue(), monitor);
                if (monitor instanceof FussyProgressMonitor) {
                    ((FussyProgressMonitor)monitor).sanityCheck();
                }
                return null;
            }

            public boolean shouldFail(Object[] args, int count) {
                File destinationFile;
                IResource resource = (IResource)args[0];
                IPath destination = (IPath)args[1];
                if (!resource.isAccessible()) {
                    return true;
                }
                if (IResourceTest.this.isProject(resource)) {
                    if (destination.isAbsolute() ? destination.segmentCount() != 2 : destination.segmentCount() != 1) {
                        return true;
                    }
                    return !IResourceTest.getWorkspace().validateName(destination.segment(0), 4).isOK();
                }
                File destinationParent = destination.isAbsolute() ? destination.removeLastSegments(1).toFile() : resource.getLocation().removeLastSegments(1).append(destination.removeLastSegments(1)).toFile();
                File file = destinationFile = destination.isAbsolute() ? destination.toFile() : resource.getLocation().removeLastSegments(1).append(destination).removeTrailingSeparator().toFile();
                return !destinationParent.exists() || !destinationParent.isDirectory() || destinationFile.exists() || destinationFile.toString().startsWith(resource.getLocation().toFile().toString());
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                return true;
            }
        }.performTest(inputs);
    }

    public void testMultiCreation() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("bar");
        IResource[] resources = this.buildResources((IContainer)project, new String[]{"a/", "a/b"});
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("1.3", (IResource)project);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            try {
                switch (resource.getType()) {
                    case 1: {
                        ((IFile)resource).create(null, false, this.getMonitor());
                        break;
                    }
                    case 2: {
                        ((IFolder)resource).create(false, true, this.getMonitor());
                        break;
                    }
                    case 4: {
                        ((IProject)resource).create(this.getMonitor());
                    }
                }
            }
            catch (CoreException e) {
                IResourceTest.fail((String)("1.4: " + resource.getFullPath()), (Throwable)e);
            }
            ++i;
        }
        this.assertExistsInWorkspace("1.5", resources);
        try {
            project.delete(true, false, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.0", (Throwable)e);
        }
    }

    public void testProjectDescriptionFileModification() throws CoreException {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("P1");
        IFile file = project.getFile(".project");
        project.create(null);
        project.open(null);
        long stamp = file.getModificationStamp();
        project.close(null);
        project.open(null);
        IResourceTest.assertEquals((long)stamp, (long)file.getModificationStamp());
    }

    public void testProperties() throws CoreException {
        QualifiedName qn1 = new QualifiedName("package", "property1");
        QualifiedName qn2 = new QualifiedName("package", "property2");
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("P1");
        IProject project2 = IResourceTest.getWorkspace().getRoot().getProject("P2");
        project.create(null);
        project.open(null);
        project.setPersistentProperty(qn1, "value1");
        project.setPersistentProperty(qn2, "value2");
        project.setSessionProperty(qn1, (Object)"value1");
        project.setSessionProperty(qn2, (Object)"value2");
        IResourceTest.assertEquals((String)"value1", (String)project.getPersistentProperty(qn1));
        IResourceTest.assertEquals((String)"value2", (String)project.getPersistentProperty(qn2));
        IResourceTest.assertEquals((Object)"value1", (Object)project.getSessionProperty(qn1));
        IResourceTest.assertEquals((Object)"value2", (Object)project.getSessionProperty(qn2));
        Map props = project.getPersistentProperties();
        IResourceTest.assertEquals((int)2, (int)props.size());
        IResourceTest.assertEquals((Object)"value1", props.get(qn1));
        IResourceTest.assertEquals((Object)"value2", props.get(qn2));
        props = project.getSessionProperties();
        IResourceTest.assertEquals((Object)"value1", props.get(qn1));
        IResourceTest.assertEquals((Object)"value2", props.get(qn2));
        project.setPersistentProperty(qn1, null);
        project.setSessionProperty(qn1, null);
        props = project.getPersistentProperties();
        IResourceTest.assertEquals((int)1, (int)props.size());
        IResourceTest.assertNull(props.get(qn1));
        IResourceTest.assertEquals((Object)"value2", props.get(qn2));
        props = project.getSessionProperties();
        IResourceTest.assertNull(props.get(qn1));
        IResourceTest.assertEquals((Object)"value2", props.get(qn2));
        project.copy(project2.getFullPath(), true, null);
        props = project2.getPersistentProperties();
        IResourceTest.assertEquals((int)1, (int)props.size());
        IResourceTest.assertNull(props.get(qn1));
        IResourceTest.assertEquals((Object)"value2", props.get(qn2));
        props = project2.getSessionProperties();
        IResourceTest.assertNull(props.get(qn1));
        IResourceTest.assertNull(props.get(qn2));
        project.close(null);
        project.open(null);
        props = project.getPersistentProperties();
        IResourceTest.assertEquals((int)1, (int)props.size());
        IResourceTest.assertNull(props.get(qn1));
        IResourceTest.assertEquals((Object)"value2", props.get(qn2));
        props = project.getSessionProperties();
        IResourceTest.assertNull(props.get(qn1));
        IResourceTest.assertNull(props.get(qn2));
    }

    public void testReadOnly() {
        if (!this.isReadOnlySupported()) {
            return;
        }
        IProject project = IResourceTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFile file = project.getFile("target");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"1.0", (!file.isReadOnly() ? 1 : 0) != 0);
        file.setReadOnly(true);
        IResourceTest.assertTrue((String)"1.2", (boolean)file.isReadOnly());
        file.setReadOnly(false);
        IResourceTest.assertTrue((String)"1.4", (!file.isReadOnly() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"2.0", (!project.isReadOnly() ? 1 : 0) != 0);
        project.setReadOnly(true);
        IResourceTest.assertTrue((String)"2.2", (boolean)project.isReadOnly());
        project.setReadOnly(false);
        IResourceTest.assertTrue((String)"2.4", (!project.isReadOnly() ? 1 : 0) != 0);
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testRefreshLocal() {
        try {
            IResourceTest.getWorkspace().getRoot().delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        interestingResources = this.buildInterestingResources();
        Object[][] inputs = new Object[][]{interestingResources, interestingResources, this.interestingStates(), this.interestingDepths()};
        new TestPerformer("IResourceTest.testRefreshLocal"){

            public void cleanUp(Object[] args, int count) {
                IResourceTest.this.cleanUpAfterRefreshTest(args);
            }

            public Object invokeMethod(Object[] args, int count) throws CoreException {
                int depth;
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                if (!IResourceTest.this.makesSense(receiver, target, state, depth = ((Integer)args[3]).intValue())) {
                    return null;
                }
                IResourceTest.this.setupBeforeState(receiver, target, state, depth, true);
                receiver.refreshLocal(depth, IResourceTest.this.getMonitor());
                return Boolean.TRUE;
            }

            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                if (result == null) {
                    return true;
                }
                IResource receiver = (IResource)args[0];
                IResource target = (IResource)args[1];
                int state = (Integer)args[2];
                int depth = (Integer)args[3];
                return IResourceTest.this.checkAfterState(receiver, target, state, depth);
            }
        }.performTest(inputs);
    }

    public void testRefreshLocalWithDepth() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("Project");
        IFolder folder = project.getFolder("Folder");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            folder.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        String[] hierarchy = new String[]{"Folder/", "Folder/Folder/", "Folder/Folder/Folder/", "Folder/Folder/Folder/Folder/"};
        IResource[] resources = this.buildResources((IContainer)folder, hierarchy);
        this.ensureExistsInFileSystem(resources);
        this.assertDoesNotExistInWorkspace("3.0", resources);
        try {
            folder.refreshLocal(1, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("5.0", (IResource)folder.getFolder("Folder"));
        this.assertDoesNotExistInWorkspace("5.1", (IResource)folder.getFolder("Folder/Folder"));
    }

    public void testRefreshWithMissingParent() throws CoreException {
        IProject project1 = IResourceTest.getWorkspace().getRoot().getProject("Project");
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        IFolder folder = project1.getFolder("Folder");
        IFile file = folder.getFile("File");
        this.ensureExistsInFileSystem(file);
        file.refreshLocal(2, this.getMonitor());
    }

    public void testRevertModificationStamp() {
        try {
            IResourceTest.getWorkspace().getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!resource.isAccessible()) {
                        return false;
                    }
                    long oldStamp = resource.getModificationStamp();
                    resource.touch(null);
                    long newStamp = resource.getModificationStamp();
                    if (resource.getType() == 8) {
                        IResourceTest.assertTrue((String)("1.0." + resource.getFullPath()), (oldStamp == newStamp ? 1 : 0) != 0);
                    } else {
                        IResourceTest.assertTrue((String)("1.0." + resource.getFullPath()), (oldStamp != newStamp ? 1 : 0) != 0);
                    }
                    resource.revertModificationStamp(oldStamp);
                    IResourceTest.assertEquals((String)("1.1." + resource.getFullPath()), (long)oldStamp, (long)resource.getModificationStamp());
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IResource[] resources = this.buildInterestingResources();
        long[] illegal = new long[]{-1L, -10L, -100L};
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isAccessible()) {
                int j = 0;
                while (j < illegal.length) {
                    try {
                        resources[i].revertModificationStamp(illegal[j]);
                        IResourceTest.fail((String)("2." + j + "." + resources[i].getFullPath()));
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    catch (CoreException e) {
                        IResourceTest.fail((String)"2.99", (Throwable)e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        try {
            IResourceTest.getWorkspace().getRoot().delete(4, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.99", (Throwable)e);
        }
        i = 0;
        while (i < resources.length) {
            block14: {
                try {
                    resources[i].revertModificationStamp(1L);
                    if (resources[i].getType() != 8) {
                        IResourceTest.fail((String)("4." + resources[i].getFullPath()));
                    }
                }
                catch (CoreException coreException) {
                    if (resources[i].getType() != 8) break block14;
                    IResourceTest.fail((String)"4.99");
                }
            }
            ++i;
        }
    }

    public void testSetLocalTimeStamp() {
        try {
            IResourceTest.getWorkspace().getRoot().delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        interestingResources = this.buildInterestingResources();
        Long[] interestingTimes = new Long[]{new Long(-1L), new Long(System.currentTimeMillis() - 1000L), new Long(System.currentTimeMillis() - 100L), new Long(System.currentTimeMillis()), new Long(0xFFFFFFFE00L)};
        Object[][] inputs = new Object[][]{interestingResources, interestingTimes};
        new TestPerformer("IResourceTest.testRefreshLocal"){

            public void cleanUp(Object[] args, int count) {
            }

            public Object invokeMethod(Object[] args, int count) throws CoreException {
                IResource receiver = (IResource)args[0];
                long time = (Long)args[1];
                long actual = receiver.setLocalTimeStamp(time);
                return new Long(actual);
            }

            public boolean shouldFail(Object[] args, int count) {
                long time = (Long)args[1];
                return time < 0L;
            }

            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) {
                IResource receiver = (IResource)args[0];
                if (receiver.getType() == 8) {
                    return true;
                }
                long time = (Long)args[1];
                long actual = (Long)result;
                if (actual != receiver.getLocalTimeStamp()) {
                    return false;
                }
                return Math.abs(actual - time) <= 2000L;
            }
        }.performTest(inputs);
    }

    public void testTeamPrivateMember() {
        IWorkspaceRoot root = IResourceTest.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("target");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            folder.create(true, true, this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IResourceTest.assertTrue((String)"2.1.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.1.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            root.setTeamPrivateMember(true);
            IResourceTest.assertTrue((String)"2.2.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.2.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            root.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"2.3.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"2.3.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            project.setTeamPrivateMember(true);
            IResourceTest.assertTrue((String)"3.1.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.1.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            project.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"3.2.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"3.2.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            folder.setTeamPrivateMember(true);
            IResourceTest.assertTrue((String)"4.1.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.1.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.1.3", (boolean)folder.isTeamPrivateMember());
            IResourceTest.assertTrue((String)"4.1.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            folder.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"4.2.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"4.2.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
            file.setTeamPrivateMember(true);
            IResourceTest.assertTrue((String)"5.1.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.1.4", (boolean)file.isTeamPrivateMember());
            file.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"5.2.1", (!root.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.2", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.3", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
            IResourceTest.assertTrue((String)"5.2.4", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"7.0", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"8.1", (!project.isTeamPrivateMember() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"8.2", (!folder.isTeamPrivateMember() ? 1 : 0) != 0);
        IResourceTest.assertTrue((String)"8.3", (!file.isTeamPrivateMember() ? 1 : 0) != 0);
        try {
            project.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"9.1", (boolean)false);
        }
        catch (CoreException coreException) {}
        try {
            folder.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"9.2", (boolean)false);
        }
        catch (CoreException coreException) {}
        try {
            file.setTeamPrivateMember(false);
            IResourceTest.assertTrue((String)"9.3", (boolean)false);
        }
        catch (CoreException coreException) {}
    }
}

