/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;

public class MarkerAttributeChangeListener
extends Assert
implements IResourceChangeListener {
    private Map attributeMap = new HashMap();
    private AssertionFailedError error;

    public void expectChanges(IMarker marker) throws CoreException {
        this.expectChanges(new IMarker[]{marker});
    }

    public void expectChanges(IMarker[] markers) throws CoreException {
        this.error = null;
        this.attributeMap.clear();
        int i = 0;
        while (i < markers.length) {
            this.attributeMap.put(new Long(markers[i].getId()), markers[i].getAttributes());
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] deltas = event.findMarkerDeltas(null, true);
        try {
            this.checkDelta(deltas);
        }
        catch (AssertionFailedError e) {
            this.error = e;
        }
    }

    private void checkDelta(IMarkerDelta[] deltas) throws AssertionFailedError {
        MarkerAttributeChangeListener.assertEquals((String)"wrong number of changes", (int)this.attributeMap.size(), (int)deltas.length);
        int i = 0;
        while (i < deltas.length) {
            Map values = (Map)this.attributeMap.get(new Long(deltas[i].getId()));
            MarkerAttributeChangeListener.assertEquals((String)"Changes different from expecations", (Object)deltas[i].getAttributes(), (Object)values);
            ++i;
        }
    }

    public void verifyChanges() {
        if (this.error != null) {
            throw this.error;
        }
    }
}

