/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MarkersChangeListener
implements IResourceChangeListener {
    protected Hashtable changes;

    public MarkersChangeListener() {
        this.reset();
    }

    public boolean checkChanges(IResource resource, IMarker[] added, IMarker[] removed, IMarker[] changed) {
        int numChanges;
        Object path = resource == null ? Path.ROOT : resource.getFullPath();
        Vector v = (Vector)this.changes.get(path);
        if (v == null) {
            v = new Vector();
        }
        if ((numChanges = (added == null ? 0 : added.length) + (removed == null ? 0 : removed.length) + (changed == null ? 0 : changed.length)) != v.size()) {
            return false;
        }
        int i = 0;
        while (i < v.size()) {
            IMarkerDelta delta = (IMarkerDelta)v.elementAt(i);
            switch (delta.getKind()) {
                case 1: {
                    if (this.contains(added, delta.getMarker())) break;
                    return false;
                }
                case 2: {
                    if (this.contains(removed, delta.getMarker())) break;
                    return false;
                }
                case 4: {
                    if (this.contains(changed, delta.getMarker())) break;
                    return false;
                }
                default: {
                    throw new Error();
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean contains(IMarker[] markers, IMarker marker) {
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                if (markers[i].equals((Object)marker)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int numAffectedResources() {
        return this.changes.size();
    }

    public void reset() {
        this.changes = new Hashtable(11);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.resourceChanged(event.getDelta());
    }

    protected void resourceChanged(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        if ((delta.getFlags() & 0x20000) != 0) {
            IPath path = delta.getFullPath();
            Vector<IMarkerDelta> v = (Vector<IMarkerDelta>)this.changes.get(path);
            if (v == null) {
                v = new Vector<IMarkerDelta>();
                this.changes.put(path, v);
            }
            IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
            int i = 0;
            while (i < markerDeltas.length) {
                v.addElement(markerDeltas[i]);
                ++i;
            }
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.resourceChanged(children[i]);
            ++i;
        }
    }
}

