/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;

public class ProjectSnapshotPerfManualTest
extends ResourceTest {
    public static final String bigSiteDevice = "c:";
    public static final IPath bigSiteLocation = new Path("c:", "/test");
    private static final String DIR_NAME = ".settings";
    private static final String REFRESH_SNAPSHOT_FILE_LOCATION = ".settings/resource-index.zip";

    public ProjectSnapshotPerfManualTest() {
    }

    public ProjectSnapshotPerfManualTest(String name) {
        super(name);
    }

    protected int countChildren(File root) {
        String[] children = root.list();
        if (children == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < children.length) {
            File child = new File(root, children[i]);
            if (child.isDirectory()) {
                result += this.countChildren(child);
            }
            ++result;
            ++i;
        }
        return result;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ProjectSnapshotPerfManualTest.class.getName());
        suite.addTest((Test)new ProjectSnapshotPerfManualTest("testSnapshotImportPerformance"));
        return suite;
    }

    public void testSnapshotImportPerformance() throws Exception {
        if (!bigSiteLocation.toFile().isDirectory()) {
            return;
        }
        final IProject project = ProjectSnapshotPerfManualTest.getWorkspace().getRoot().getProject("MyTestProject");
        IProjectDescription description = ProjectSnapshotPerfManualTest.getWorkspace().newProjectDescription(project.getName());
        description.setLocation(bigSiteLocation);
        int numberOfFiles = this.countChildren(bigSiteLocation.toFile());
        System.out.println("Number of local resources: " + numberOfFiles);
        project.create(description, null);
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    project.open(null);
                }
                catch (CoreException e) {
                    ProjectSnapshotPerfManualTest.fail((String)"Original open", (Throwable)e);
                }
            }
        }.run((TestCase)new ProjectSnapshotPerfManualTest("Original open"), 1, 1);
        this.ensureExistsInWorkspace((IResource)project.getFolder(DIR_NAME), true);
        IPath projPath = project.getLocation();
        projPath = projPath.append(REFRESH_SNAPSHOT_FILE_LOCATION);
        final URI snapshotLocation = URIUtil.toURI((IPath)projPath);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(false, false, null);
        project.create(description, null);
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    project.loadSnapshot(1, snapshotLocation, null);
                    project.open(0, null);
                }
                catch (CoreException e) {
                    ProjectSnapshotPerfManualTest.fail((String)"Snapshot open", (Throwable)e);
                }
            }
        }.run((TestCase)new ProjectSnapshotPerfManualTest("Snapshot open"), 1, 1);
        final ResourceDeltaVerifier[] verifier = new ResourceDeltaVerifier[1];
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    verifier[0] = new ResourceDeltaVerifier();
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier[0]);
                    verifier[0].reset();
                    IFolder settings = project.getFolder(ProjectSnapshotPerfManualTest.DIR_NAME);
                    IFile snapshot = project.getFile(ProjectSnapshotPerfManualTest.REFRESH_SNAPSHOT_FILE_LOCATION);
                    verifier[0].addExpectedChange((IResource)settings, 4, 0);
                    verifier[0].addExpectedChange((IResource)snapshot, 1, 0);
                    project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    ProjectSnapshotPerfManualTest.fail((String)"Forced refresh only", (Throwable)e);
                }
            }
        }.run((TestCase)new ProjectSnapshotPerfManualTest("Forced refresh only"), 1, 1);
        verifier[0].verifyDelta(null);
        ProjectSnapshotPerfManualTest.assertTrue((String)("1.0 " + verifier[0].getMessage()), (boolean)verifier[0].isDeltaValid());
        project.close(null);
        project.delete(false, false, null);
        IPath snapshotFile = bigSiteLocation.append(REFRESH_SNAPSHOT_FILE_LOCATION);
        snapshotFile.toFile().delete();
        project.create(description, null);
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    project.open(null);
                }
                catch (CoreException e) {
                    ProjectSnapshotPerfManualTest.fail((String)"Second refresh open", (Throwable)e);
                }
            }
        }.run((TestCase)new ProjectSnapshotPerfManualTest("Second refresh open"), 1, 1);
        project.close(null);
        project.delete(false, false, null);
    }
}

