/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.EclipseTestHarnessApplication;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.DeltaDebugListener;

public abstract class ResourceTest
extends CoreTest {
    public static IResourceChangeListener deltaListener;
    protected static final String NATURE_29116 = "org.eclipse.core.tests.resources.nature29116";
    protected static final String NATURE_CYCLE1 = "org.eclipse.core.tests.resources.cycle1";
    protected static final String NATURE_CYCLE2 = "org.eclipse.core.tests.resources.cycle2";
    protected static final String NATURE_CYCLE3 = "org.eclipse.core.tests.resources.cycle3";
    protected static final String NATURE_EARTH = "org.eclipse.core.tests.resources.earthNature";
    protected static final String NATURE_INVALID = "org.eclipse.core.tests.resources.invalidNature";
    protected static final String NATURE_MISSING = "no.such.nature.Missing";
    protected static final String NATURE_MISSING_PREREQ = "org.eclipse.core.tests.resources.missingPrerequisiteNature";
    protected static final String NATURE_MUD = "org.eclipse.core.tests.resources.mudNature";
    protected static final String NATURE_SIMPLE = "org.eclipse.core.tests.resources.simpleNature";
    protected static final String NATURE_127562 = "org.eclipse.core.tests.resources.bug127562Nature";
    protected static final String NATURE_SNOW = "org.eclipse.core.tests.resources.snowNature";
    protected static final String NATURE_WATER = "org.eclipse.core.tests.resources.waterNature";
    public static final String PI_RESOURCES_TESTS = "org.eclipse.core.tests.resources";
    protected static final String SET_OTHER = "org.eclipse.core.tests.resources.otherSet";
    protected static final String SET_STATE = "org.eclipse.core.tests.resources.stateSet";
    private final Set<IFileStore> storesToDelete = new HashSet<IFileStore>();

    protected static void gc() {
        int i = 0;
        while (i < 2) {
            System.runFinalization();
            System.gc();
            ++i;
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected static boolean isCaseSensitive(IResource resource) {
        return ((Resource)resource).getStore().getFileSystem().isCaseSensitive();
    }

    protected static boolean isWindows() {
        return Platform.getOS().equals("win32");
    }

    protected static void transferStreams(InputStream source, OutputStream destination, String path, IProgressMonitor monitor) {
        block31: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            try {
                byte[] buffer = new byte[8192];
                while (true) {
                    int bytesRead = -1;
                    try {
                        bytesRead = source.read(buffer);
                    }
                    catch (IOException e) {
                        ResourceTest.fail((String)"Failed to read during transferStreams", (Throwable)e);
                    }
                    if (bytesRead == -1) break;
                    try {
                        destination.write(buffer, 0, bytesRead);
                    }
                    catch (IOException e) {
                        ResourceTest.fail((String)"Failed to write during transferStreams", (Throwable)e);
                    }
                    monitor.worked(1);
                }
            }
            catch (Throwable throwable) {
                block29: {
                    try {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {
                            try {
                                destination.close();
                            }
                            catch (IOException iOException2) {}
                            break block29;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            destination.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException3) {}
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ResourceTest() {
        super(null);
    }

    public ResourceTest(String name) {
        super(name);
    }

    public void assertDoesNotExistInFileSystem(IResource resource) {
        this.assertDoesNotExistInFileSystem("", resource);
    }

    public void assertDoesNotExistInFileSystem(IResource[] resources) {
        this.assertDoesNotExistInFileSystem("", resources);
    }

    public void assertDoesNotExistInFileSystem(String message, IResource resource) {
        if (this.existsInFileSystem(resource)) {
            String formatted = message == null ? "" : String.valueOf(message) + " ";
            ResourceTest.fail((String)(String.valueOf(formatted) + resource.getFullPath() + " unexpectedly exists in the file system"));
        }
    }

    public void assertDoesNotExistInFileSystem(String message, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.assertDoesNotExistInFileSystem(message, resources[i]);
            ++i;
        }
    }

    public void assertDoesNotExistInWorkspace(IResource resource) {
        this.assertDoesNotExistInWorkspace("", resource);
    }

    public void assertDoesNotExistInWorkspace(IResource[] resources) {
        this.assertDoesNotExistInWorkspace("", resources);
    }

    public void assertDoesNotExistInWorkspace(String message, IResource resource) {
        if (this.existsInWorkspace(resource, false)) {
            String formatted = message == null ? "" : String.valueOf(message) + " ";
            ResourceTest.fail((String)(String.valueOf(formatted) + resource.getFullPath().toString() + " unexpectedly exists in the workspace"));
        }
    }

    public void assertDoesNotExistInWorkspace(String message, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.assertDoesNotExistInWorkspace(message, resources[i]);
            ++i;
        }
    }

    public void assertExistsInFileSystem(IResource resource) {
        this.assertExistsInFileSystem("", resource);
    }

    public void assertExistsInFileSystem(IResource[] resources) {
        this.assertExistsInFileSystem("", resources);
    }

    public void assertExistsInFileSystem(String message, IResource resource) {
        if (!this.existsInFileSystem(resource)) {
            String formatted = message == null ? "" : String.valueOf(message) + " ";
            ResourceTest.fail((String)(String.valueOf(formatted) + resource.getFullPath() + " unexpectedly does not exist in the file system"));
        }
    }

    public void assertExistsInFileSystem(String message, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.assertExistsInFileSystem(message, resources[i]);
            ++i;
        }
    }

    public void assertExistsInWorkspace(IResource resource) {
        this.assertExistsInWorkspace("", resource, false);
    }

    public void assertExistsInWorkspace(IResource resource, boolean phantom) {
        this.assertExistsInWorkspace("", resource, phantom);
    }

    public void assertExistsInWorkspace(IResource[] resources) {
        this.assertExistsInWorkspace("", resources, false);
    }

    public void assertExistsInWorkspace(IResource[] resources, boolean phantom) {
        this.assertExistsInWorkspace("", resources, phantom);
    }

    public void assertExistsInWorkspace(String message, IResource resource) {
        this.assertExistsInWorkspace(message, resource, false);
    }

    public void assertExistsInWorkspace(String message, IResource resource, boolean phantom) {
        if (!this.existsInWorkspace(resource, phantom)) {
            String formatted = message == null ? "" : String.valueOf(message) + " ";
            ResourceTest.fail((String)(String.valueOf(formatted) + resource.getFullPath().toString() + " unexpectedly does not exist in the workspace"));
        }
    }

    public void assertExistsInWorkspace(String message, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.assertExistsInWorkspace(message, resources[i], false);
            ++i;
        }
    }

    public void assertExistsInWorkspace(String message, IResource[] resources, boolean phantom) {
        int i = 0;
        while (i < resources.length) {
            this.assertExistsInWorkspace(message, resources[i], phantom);
            ++i;
        }
    }

    public IResource[] buildResources() {
        return this.buildResources((IContainer)ResourceTest.getWorkspace().getRoot(), this.defineHierarchy());
    }

    public IResource[] buildResources(IContainer root, String[] hierarchy) {
        IResource[] result = new IResource[hierarchy.length];
        int i = 0;
        while (i < hierarchy.length) {
            Path path = new Path(hierarchy[i]);
            IPath fullPath = root.getFullPath().append((IPath)path);
            switch (fullPath.segmentCount()) {
                case 0: {
                    result[i] = ResourceTest.getWorkspace().getRoot();
                    break;
                }
                case 1: {
                    result[i] = ResourceTest.getWorkspace().getRoot().getProject(fullPath.segment(0));
                    break;
                }
                default: {
                    result[i] = hierarchy[i].charAt(hierarchy[i].length() - 1) == '/' ? root.getFolder((IPath)path) : root.getFile((IPath)path);
                }
            }
            ++i;
        }
        return result;
    }

    protected void cleanup() throws CoreException {
        final IFileStore[] toDelete = this.storesToDelete.toArray(new IFileStore[0]);
        this.storesToDelete.clear();
        ResourceTest.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ResourceTest.getWorkspace().getRoot().delete(5, ResourceTest.this.getMonitor());
                int i = 0;
                while (i < toDelete.length) {
                    ResourceTest.this.clear(toDelete[i]);
                    ++i;
                }
            }
        }, null);
        ResourceTest.getWorkspace().save(true, null);
        this.waitForBuild();
    }

    protected void clear(IFileStore store) {
        try {
            store.delete(0, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)"IResourceTest#clear.99", (Throwable)e);
        }
    }

    public boolean compareContent(InputStream a, InputStream b) {
        if (a == null && b == null) {
            return true;
        }
        try {
            int d;
            int c;
            if (a == null || b == null) {
                return false;
            }
            while ((c = a.read()) == (d = b.read()) && c != -1 && d != -1) {
            }
            boolean bl = c == -1 && d == -1;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            this.assertClose(a);
            this.assertClose(b);
        }
    }

    private IPath computeDefaultLocation(IResource target) {
        switch (target.getType()) {
            case 8: {
                return Platform.getLocation();
            }
            case 4: {
                return Platform.getLocation().append(target.getFullPath());
            }
        }
        IPath location = this.computeDefaultLocation((IResource)target.getProject());
        location = location.append(target.getFullPath().removeFirstSegments(1));
        return location;
    }

    protected void create(IResource resource, boolean local) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            this.create((IResource)resource.getParent(), local);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)(local ? new ByteArrayInputStream(new byte[0]) : null), true, this.getMonitor());
                break;
            }
            case 2: {
                ((IFolder)resource).create(true, local, this.getMonitor());
                break;
            }
            case 4: {
                ((IProject)resource).create(this.getMonitor());
                ((IProject)resource).open(this.getMonitor());
            }
        }
    }

    public void createFileInFileSystem(IFileStore file) {
        this.createFileInFileSystem(file, this.getRandomContents());
    }

    public void createFileInFileSystem(IFileStore file, InputStream contents) {
        block5: {
            OutputStream output = null;
            try {
                try {
                    file.getParent().mkdir(0, null);
                    output = file.openOutputStream(0, null);
                    this.transferData(contents, output);
                }
                catch (CoreException e) {
                    ResourceTest.fail((String)"ResourceTest#createFileInFileSystem.2", (Throwable)e);
                    this.assertClose(output);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.assertClose(output);
                throw throwable;
            }
            this.assertClose(output);
        }
    }

    public void createFileInFileSystem(IPath path) {
        this.createFileInFileSystem(path, this.getRandomContents());
    }

    public void createFileInFileSystem(IPath path, InputStream contents) {
        try {
            this.createFileInFileSystem(path.toFile(), contents);
        }
        catch (IOException e) {
            ResourceTest.fail((String)"ResourceTest#createFileInFileSystem", (Throwable)e);
        }
    }

    public IResource[] createHierarchy() {
        IResource[] result = this.buildResources();
        this.ensureExistsInWorkspace(result, true);
        return result;
    }

    public String[] defineHierarchy() {
        return new String[0];
    }

    public void ensureDoesNotExistInFileSystem(IResource resource) {
        IPath path = resource.getLocation();
        if (path != null) {
            this.ensureDoesNotExistInFileSystem(path.toFile());
        }
    }

    public void ensureDoesNotExistInFileSystem(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.ensureDoesNotExistInFileSystem(resources[i]);
            ++i;
        }
    }

    public void ensureDoesNotExistInWorkspace(IResource resource) {
        try {
            if (resource.exists()) {
                resource.delete(true, null);
            }
        }
        catch (CoreException e) {
            ResourceTest.fail((String)("#ensureDoesNotExistInWorkspace(IResource): " + resource.getFullPath()), (Throwable)e);
        }
    }

    public void ensureDoesNotExistInWorkspace(final IResource[] resources) {
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                int i = 0;
                while (i < resources.length) {
                    ResourceTest.this.ensureDoesNotExistInWorkspace(resources[i]);
                    ++i;
                }
            }
        };
        try {
            ResourceTest.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)"#ensureDoesNotExistInWorkspace(IResource[])", (Throwable)e);
        }
    }

    public void ensureExistsInFileSystem(IFile file) {
        this.createFileInFileSystem(((Resource)file).getStore());
    }

    public void ensureExistsInFileSystem(IResource resource) {
        if (resource instanceof IFile) {
            this.ensureExistsInFileSystem((IFile)resource);
        } else {
            try {
                ((Resource)resource).getStore().mkdir(0, null);
            }
            catch (CoreException e) {
                ResourceTest.fail((String)"ensureExistsInFileSystem.1", (Throwable)e);
            }
        }
    }

    public void ensureExistsInFileSystem(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.ensureExistsInFileSystem(resources[i]);
            ++i;
        }
    }

    public void ensureExistsInWorkspace(final IFile resource, final InputStream contents) {
        if (resource == null) {
            return;
        }
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (resource.exists()) {
                    resource.setContents(contents, true, false, null);
                } else {
                    ResourceTest.this.ensureExistsInWorkspace((IResource)resource.getParent(), true);
                    resource.create(contents, true, null);
                }
            }
        };
        try {
            ResourceTest.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)("#ensureExistsInWorkspace(IFile, InputStream): " + resource.getFullPath()), (Throwable)e);
        }
    }

    public void ensureExistsInWorkspace(IFile resource, String contents) {
        this.ensureExistsInWorkspace(resource, new ByteArrayInputStream(contents.getBytes()));
    }

    public void ensureExistsInWorkspace(final IResource resource, final boolean local) {
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ResourceTest.this.create(resource, local);
            }
        };
        try {
            ResourceTest.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)("#ensureExistsInWorkspace(IResource): " + resource.getFullPath()), (Throwable)e);
        }
    }

    public void ensureExistsInWorkspace(final IResource[] resources, final boolean local) {
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < resources.length) {
                    ResourceTest.this.create(resources[i], local);
                    ++i;
                }
            }
        };
        try {
            ResourceTest.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)"#ensureExistsInWorkspace(IResource[])", (Throwable)e);
        }
    }

    public void ensureOutOfSync(IFile file) {
        this.modifyInFileSystem(file);
        this.touchInFilesystem((IResource)file);
        ResourceTest.assertTrue((String)("File not out of sync: " + file.getLocation().toOSString()), (file.getLocation().toFile().lastModified() != file.getLocalTimeStamp() ? 1 : 0) != 0);
    }

    public void touchInFilesystem(IResource resource) {
        File osFile = resource.getLocation().toFile();
        if (!osFile.exists()) {
            this.ensureExistsInFileSystem(resource);
        }
        int count = 0;
        while (count < 30 && osFile.lastModified() == resource.getLocalTimeStamp()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            resource.getLocation().toFile().setLastModified(System.currentTimeMillis());
            ++count;
        }
        ResourceTest.assertTrue((String)("File not out of sync: " + resource.getLocation().toOSString()), (osFile.lastModified() != resource.getLocalTimeStamp() ? 1 : 0) != 0);
    }

    private boolean existsInFileSystem(IResource resource) {
        IPath path = resource.getLocation();
        if (path == null) {
            path = this.computeDefaultLocation(resource);
        }
        return path.toFile().exists();
    }

    private boolean existsInWorkspace(IResource resource, boolean phantom) {
        IResource target = ResourceTest.getWorkspace().getRoot().findMember(resource.getFullPath(), phantom);
        return target != null && target.getType() == resource.getType();
    }

    protected String getClassName() {
        String fullClassName = ((Object)((Object)this)).getClass().getName();
        return fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
    }

    protected String[][] getInvalidNatureSets() {
        return new String[][]{{NATURE_SNOW}, {NATURE_WATER, NATURE_EARTH}, {NATURE_WATER, NATURE_MUD}, {NATURE_WATER, NATURE_EARTH, NATURE_MUD}, {NATURE_SIMPLE, NATURE_SNOW, NATURE_WATER, NATURE_MUD}, {NATURE_MISSING}, {NATURE_SIMPLE, NATURE_MISSING}, {NATURE_MISSING_PREREQ}, {NATURE_SIMPLE, NATURE_MISSING_PREREQ}, {NATURE_CYCLE1}, {NATURE_CYCLE2, NATURE_CYCLE3}, {NATURE_CYCLE1, NATURE_SIMPLE, NATURE_CYCLE2, NATURE_CYCLE3}};
    }

    /*
     * Unable to fully structure code
     */
    protected String getLineSeparatorFromFile(IFile file) {
        if (file.exists()) {
            block24: {
                block25: {
                    block23: {
                        input = null;
                        input = file.getContents();
                        c = input.read();
                        while (c != -1 && c != 13 && c != 10) {
                            c = input.read();
                        }
                        if (c != 10) break block23;
                        try {
                            input.close();
                        }
                        catch (IOException v0) {}
                        return "\n";
                    }
                    if (c != 13) break block24;
                    if (input.read() != 10) break block25;
                    try {
                        input.close();
                    }
                    catch (IOException v1) {}
                    return "\r\n";
                }
                try {
                    input.close();
                }
                catch (IOException v2) {}
                return "\r";
                catch (CoreException v3) {
                    ** try [egrp 5[TRYBLOCK] [11 : 105->106)] { 
lbl32:
                    // 1 sources

                    try {
                        input.close();
                    }
                    catch (IOException v4) {}
                }
                catch (IOException v5) {
                    ** try [egrp 7[TRYBLOCK] [12 : 117->118)] { 
lbl-1000:
                    // 4 sources

                    {
                        catch (Throwable var4_4) {
                            try {
                                input.close();
                            }
                            catch (IOException v6) {}
                            throw var4_4;
                        }
                    }
lbl45:
                    // 1 sources

                    try {
                        input.close();
                    }
                    catch (IOException v7) {}
                }
            }
            try {
                input.close();
            }
            catch (IOException v8) {}
        }
        return null;
    }

    protected IFileStore getTempStore() {
        IFileStore store = EFS.getLocalFileSystem().getStore(FileSystemHelper.getRandomLocation((IPath)this.getTempDir()));
        this.storesToDelete.add(store);
        return store;
    }

    public String getUniqueString() {
        return new UniversalUniqueIdentifier().toString();
    }

    protected String[][] getValidNatureSets() {
        return new String[][]{new String[0], {NATURE_SIMPLE}, {NATURE_SNOW, NATURE_WATER}, {NATURE_EARTH}, {NATURE_WATER, NATURE_SIMPLE, NATURE_SNOW}};
    }

    protected boolean isAttributeSupported(int attribute) {
        return (EFS.getLocalFileSystem().attributes() & attribute) != 0;
    }

    protected boolean isReadOnlySupported() {
        return this.isAttributeSupported(2);
    }

    protected void modifyInFileSystem(IFile file) {
        String m = String.valueOf(this.getClassName()) + ".modifyInFileSystem(IFile): ";
        String newContent = String.valueOf(this.readStringInFileSystem(file)) + "f";
        IPath location = file.getLocation();
        if (location == null) {
            ResourceTest.fail((String)("0.1 - null location for file: " + file));
            return;
        }
        File osFile = location.toFile();
        try {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(osFile);
                os.write(newContent.getBytes("UTF8"));
                os.close();
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(os);
                throw throwable;
            }
            FileUtil.safeClose((Closeable)os);
        }
        catch (IOException e) {
            ResourceTest.fail((String)(String.valueOf(m) + "0.0"), (Throwable)e);
        }
    }

    protected void modifyInWorkspace(IFile file) throws CoreException {
        String m = String.valueOf(this.getClassName()) + ".modifyInWorkspace(IFile): ";
        try {
            String newContent = String.valueOf(this.readStringInWorkspace(file)) + "w";
            ByteArrayInputStream is = new ByteArrayInputStream(newContent.getBytes("UTF8"));
            file.setContents((InputStream)is, false, false, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ResourceTest.fail((String)(String.valueOf(m) + "0.0"));
        }
    }

    protected byte[] readBytesInFileSystem(IFile file) {
        IPath location;
        block3: {
            String m = String.valueOf(this.getClassName()) + ".readBytesInFileSystem(IFile): ";
            try {
                location = file.getLocation();
                if (location != null) break block3;
                ResourceTest.fail((String)("0.1 - null location for file: " + file));
                return null;
            }
            catch (IOException e) {
                ResourceTest.fail((String)(String.valueOf(m) + "0.0"), (Throwable)e);
                return null;
            }
        }
        File osFile = location.toFile();
        FileInputStream is = new FileInputStream(osFile);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.transferData(is, os);
        return os.toByteArray();
    }

    protected byte[] readBytesInWorkspace(IFile file) {
        String m = String.valueOf(this.getClassName()) + ".readBytesInWorkspace(IFile): ";
        try {
            InputStream is = file.getContents(false);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.transferData(is, os);
            return os.toByteArray();
        }
        catch (CoreException e) {
            ResourceTest.fail((String)(String.valueOf(m) + "0.0"), (Throwable)e);
            return null;
        }
    }

    protected String readStringInFileSystem(IFile file) {
        String m = String.valueOf(this.getClassName()) + ".readStringInFileSystem(IFile): ";
        try {
            return new String(this.readBytesInFileSystem(file), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            ResourceTest.fail((String)(String.valueOf(m) + "0.0"), (Throwable)e);
            return null;
        }
    }

    protected String readStringInWorkspace(IFile file) {
        String m = String.valueOf(this.getClassName()) + ".readStringInWorkspace(IFile): ";
        try {
            return new String(this.readBytesInWorkspace(file), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            ResourceTest.fail((String)(String.valueOf(m) + "0.0"), (Throwable)e);
            return null;
        }
    }

    protected void setAttribute(IFileStore target, int attribute, boolean value) {
        ResourceTest.assertTrue((String)"setAttribute.1", (boolean)this.isAttributeSupported(attribute));
        IFileInfo fileInfo = target.fetchInfo();
        fileInfo.setAttribute(attribute, value);
        try {
            target.putInfo(fileInfo, 1024, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)"ResourceTest#setAttribute", (Throwable)e);
        }
    }

    protected void setReadOnly(IFileStore target, boolean value) {
        ResourceTest.assertTrue((String)"setReadOnly.1", (boolean)this.isReadOnlySupported());
        IFileInfo fileInfo = target.fetchInfo();
        fileInfo.setAttribute(2, value);
        try {
            target.putInfo(fileInfo, 1024, null);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)"ResourceTest#setReadOnly", (Throwable)e);
        }
    }

    protected void setReadOnly(IResource target, boolean value) {
        ResourceAttributes attributes = target.getResourceAttributes();
        ResourceTest.assertNotNull((String)"setReadOnly for null attributes", (Object)attributes);
        attributes.setReadOnly(value);
        try {
            target.setResourceAttributes(attributes);
        }
        catch (CoreException e) {
            ResourceTest.fail((String)"ResourceTest#setReadOnly", (Throwable)e);
        }
    }

    protected void setUp() throws Exception {
        ResourceTest.assertNotNull((String)"Workspace was not setup", (Object)ResourceTest.getWorkspace());
        if (EclipseTestHarnessApplication.deltasEnabled() && deltaListener == null) {
            deltaListener = new DeltaDebugListener();
            ResourceTest.getWorkspace().addResourceChangeListener(deltaListener);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cleanup();
    }

    protected void waitForBuild() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void waitForRefresh() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public String[] findAvailableDevices() {
        String[] devices = new String[2];
        int i = 97;
        while (i < 123) {
            block9: {
                char c = (char)i;
                File rootFile = new File(String.valueOf(c) + ":\\");
                if (rootFile.exists() && rootFile.canWrite()) {
                    File probe = new File(rootFile, this.getUniqueString());
                    try {
                        try {
                            probe.createNewFile();
                        }
                        catch (IOException iOException) {
                            probe.delete();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        probe.delete();
                        throw throwable;
                    }
                    probe.delete();
                    if (devices[0] == null) {
                        devices[0] = String.valueOf(c) + ":/";
                    } else {
                        devices[1] = String.valueOf(c) + ":/";
                        break;
                    }
                }
            }
            ++i;
        }
        return devices;
    }
}

