/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceVisitorVerifier
extends Assert
implements IResourceVisitor {
    Set expected;
    StringBuffer message;
    boolean success = true;
    boolean verified = false;

    public ResourceVisitorVerifier() {
        this.reset();
    }

    public void addExpected(IResource resource) {
        this.expected.add(resource);
    }

    public void addExpected(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.expected.add(resources[i]);
            ++i;
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean included = this.expected.remove(resource);
        if (!included) {
            this.success = false;
            this.log(resource.getFullPath() + " was not expected.");
        }
        return true;
    }

    private void log(String text) {
        this.message.append("\n" + text);
    }

    private void verify() {
        if (this.verified) {
            return;
        }
        Iterator i = this.expected.iterator();
        while (i.hasNext()) {
            this.success = false;
            this.log(((IResource)i.next()).getFullPath() + " was not visited.");
        }
        this.verified = true;
    }

    public boolean isValid() {
        this.verify();
        return this.success;
    }

    public String getMessage() {
        return this.message.toString();
    }

    public void reset() {
        this.expected = new HashSet();
        this.message = new StringBuffer();
        this.verified = false;
    }
}

