/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTest;

public class ContentDescriptionPerformanceTest
extends ResourceTest {
    private static final String DEFAULT_DESCRIPTION_FILE_NAME = "default.xml";
    private static final String NO_DESCRIPTION_FILE_NAME = "none.some-uncommon-file-extension";
    private static final String NON_DEFAULT_DESCRIPTION_FILE_NAME = "specific.xml";
    private static final int SUBDIRS = 200;
    private static final int TOTAL_FILES = 5000;
    private static final String VALID_XML_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><some-uncommon-root-element/>";
    private static final String VALID_XML_CONTENTS_WITH_NON_DEFAULT_ENCODING = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><some-uncommon-root-element/>";

    private static String getFileName(int number) {
        switch (number %= 3) {
            case 0: {
                return DEFAULT_DESCRIPTION_FILE_NAME;
            }
            case 1: {
                return NON_DEFAULT_DESCRIPTION_FILE_NAME;
            }
        }
        return NO_DESCRIPTION_FILE_NAME;
    }

    public static Test suite() {
        return new TestSuite(ContentDescriptionPerformanceTest.class);
    }

    public ContentDescriptionPerformanceTest(String name) {
        super(name);
    }

    void assertHasExpectedDescription(String fileName, IContentDescription description) {
        if (fileName.endsWith(DEFAULT_DESCRIPTION_FILE_NAME)) {
            ContentDescriptionPerformanceTest.assertTrue((String)("description for " + fileName), (description == description.getContentType().getDefaultDescription() ? 1 : 0) != 0);
        } else if (fileName.endsWith(NON_DEFAULT_DESCRIPTION_FILE_NAME)) {
            ContentDescriptionPerformanceTest.assertTrue((String)("description for " + fileName), (description != description.getContentType().getDefaultDescription() ? 1 : 0) != 0);
        } else {
            ContentDescriptionPerformanceTest.assertNull((String)("description for " + fileName), (Object)description);
        }
    }

    void createFiles() throws CoreException {
        IProject bigProject = ResourcesPlugin.getWorkspace().getRoot().getProject("bigproject");
        ContentDescriptionPerformanceTest.assertTrue((String)"1.0", (!bigProject.exists() ? 1 : 0) != 0);
        bigProject.create(this.getMonitor());
        bigProject.open(this.getMonitor());
        int i = 0;
        while (i < 200) {
            IFolder folder = bigProject.getFolder("folder_" + i);
            folder.create(false, true, this.getMonitor());
            int j = 0;
            while (j < 25) {
                IFile file = folder.getFile("file_" + j + ContentDescriptionPerformanceTest.getFileName(j));
                file.create(this.getContents(this.getContents(j)), false, this.getMonitor());
                ++j;
            }
            ++i;
        }
    }

    public void doTestContentDescription() {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("bigproject");
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 1 && !resource.getName().equals(".project")) {
                                ContentDescriptionPerformanceTest.this.assertHasExpectedDescription(resource.getName(), ((IFile)resource).getContentDescription());
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    CoreTest.fail((String)"Failed visiting resources", (Throwable)e);
                }
            }
        }.run((TestCase)this, 1, 1);
    }

    private String getContents(int number) {
        switch (number %= 3) {
            case 0: {
                return VALID_XML_CONTENTS;
            }
            case 1: {
                return VALID_XML_CONTENTS_WITH_NON_DEFAULT_ENCODING;
            }
        }
        return "whatever";
    }

    protected void tearDown() throws Exception {
    }

    public void test1CreateWorkspace() throws CoreException {
        this.createFiles();
    }

    public void test2ColdContentDescription() {
        this.doTestContentDescription();
    }

    public void test3WarmedUpContentDescription() {
        this.doTestContentDescription();
    }

    public void test4CleanUp() throws CoreException {
        this.cleanup();
    }
}

