/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTest;

public class MarkerPerformanceTest
extends ResourceTest {
    IProject project;
    IFile file;
    IMarker[] markers;
    final int NUM_MARKERS = 5000;
    final int REPEAT = 100;

    public MarkerPerformanceTest() {
    }

    public MarkerPerformanceTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(MarkerPerformanceTest.class);
    }

    public void testSetAttributes1() {
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < 5000) {
                    int j = 0;
                    while (j < 100) {
                        MarkerPerformanceTest.this.markers[i].setAttribute("attrib", (Object)"hello");
                        ++j;
                    }
                    ++i;
                }
            }
        };
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                try {
                    MarkerPerformanceTest.getWorkspace().run(runnable, null);
                }
                catch (CoreException e) {
                    MarkerPerformanceTest.fail((String)"2.0", (Throwable)e);
                }
            }
        };
        runner.setFingerprintName("Set marker attributes");
        runner.run((TestCase)this, 1, 1);
    }

    public void testSetAttributes2() {
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int j = 0;
                while (j < 100) {
                    int i = 0;
                    while (i < 5000) {
                        MarkerPerformanceTest.this.markers[i].setAttribute("attrib", (Object)"hello");
                        ++i;
                    }
                    ++j;
                }
            }
        };
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    MarkerPerformanceTest.getWorkspace().run(runnable, null);
                }
                catch (CoreException e) {
                    MarkerPerformanceTest.fail((String)"2.0", (Throwable)e);
                }
            }
        }.run((TestCase)this, 1, 1);
    }

    protected void setUp() throws Exception {
        super.setUp();
        final IMarker[] createdMarkers = new IMarker[5000];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MarkerPerformanceTest.this.project = MarkerPerformanceTest.getWorkspace().getRoot().getProject("TestProject");
                MarkerPerformanceTest.this.project.create(null);
                MarkerPerformanceTest.this.project.open(null);
                MarkerPerformanceTest.this.file = MarkerPerformanceTest.this.project.getFile(Path.ROOT.append("file.txt"));
                MarkerPerformanceTest.this.file.create(MarkerPerformanceTest.this.getRandomContents(), true, null);
                int i = 0;
                while (i < 5000) {
                    createdMarkers[i] = MarkerPerformanceTest.this.file.createMarker("org.eclipse.core.resources.bookmark");
                    ++i;
                }
            }
        };
        try {
            MarkerPerformanceTest.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            MarkerPerformanceTest.fail((String)"1.0", (Throwable)e);
        }
        this.markers = createdMarkers;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.delete(true, true, null);
    }
}

