/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTest;

public class WorkspacePerformanceTest
extends ResourceTest {
    private static final String chars = "abcdefghijklmnopqrstuvwxyz";
    static final int REPEATS = 5;
    private static final int TREE_WIDTH = 10;
    private static final int DEFAULT_TOTAL_RESOURCES = 10000;
    private final Random random = new Random();
    IFolder testFolder;
    IProject testProject;

    public static Test suite() {
        return new TestSuite(WorkspacePerformanceTest.class);
    }

    public WorkspacePerformanceTest() {
    }

    public WorkspacePerformanceTest(String name) {
        super(name);
    }

    IFolder copyFolder() {
        IFolder destination = this.testProject.getFolder("CopyDestination");
        try {
            this.testFolder.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            WorkspacePerformanceTest.fail((String)"Failed to copy project in performance test", (Throwable)e);
        }
        return destination;
    }

    void createAndPopulateProject(final int totalResources) {
        try {
            WorkspacePerformanceTest.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    WorkspacePerformanceTest.this.testProject.create(WorkspacePerformanceTest.this.getMonitor());
                    WorkspacePerformanceTest.this.testProject.open(WorkspacePerformanceTest.this.getMonitor());
                    WorkspacePerformanceTest.this.createFolder(WorkspacePerformanceTest.this.testFolder, totalResources);
                }
            }, this.getMonitor());
        }
        catch (CoreException e) {
            WorkspacePerformanceTest.fail((String)"Failed to create project in performance test", (Throwable)e);
        }
    }

    private byte[] createBytes(int length) {
        byte[] bytes = new byte[length];
        this.random.nextBytes(bytes);
        return bytes;
    }

    IFolder createFolder(IFolder topFolder, int totalResources) throws CoreException {
        topFolder.create(0, true, this.getMonitor());
        int depth = (int)(Math.log(totalResources) / Math.log(10.0));
        this.recursiveCreateChildren(topFolder, depth - 1);
        return topFolder;
    }

    private String createString(int length) {
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            buf.append(chars.charAt(this.random.nextInt(chars.length())));
            ++i;
        }
        return buf.toString();
    }

    void deleteAndRecreateProject() throws CoreException {
        this.testProject.delete(8, null);
        this.testProject.create(null);
        this.testProject.open(0, null);
    }

    IFolder moveFolder() {
        IFolder destination = this.testFolder.getProject().getFolder("MoveDestination");
        try {
            this.testFolder.move(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            WorkspacePerformanceTest.fail((String)"Failed to move folder during performance test", (Throwable)e);
        }
        return destination;
    }

    private void recursiveCreateChildren(IFolder parentFolder, int depth) throws CoreException {
        int i = 0;
        while (i < 10) {
            IFile file = parentFolder.getFile(this.createString(10));
            file.create((InputStream)new ByteArrayInputStream(this.createBytes(5000)), 0, this.getMonitor());
            ++i;
        }
        if (depth <= 0) {
            return;
        }
        i = 0;
        while (i < 10) {
            IFolder folder = parentFolder.getFolder(this.createString(6));
            folder.create(0, true, this.getMonitor());
            this.recursiveCreateChildren(folder, depth - 1);
            ++i;
        }
    }

    protected void setUp() throws Exception {
        this.testProject = WorkspacePerformanceTest.getWorkspace().getRoot().getProject("Project");
        this.testFolder = this.testProject.getFolder("TopFolder");
    }

    public void testCreateResources() {
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void setUp() {
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
            }
        };
        runner.run((TestCase)this, 5, 1);
    }

    public void testDeleteProject() {
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void setUp() {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void test() {
                try {
                    WorkspacePerformanceTest.this.testProject.delete(0, null);
                }
                catch (CoreException e) {
                    WorkspacePerformanceTest.fail((String)"Failed to delete project during performance test", (Throwable)e);
                }
            }
        };
        runner.run((TestCase)this, 5, 1);
    }

    public void testFolderCopy() {
        new PerformanceTestRunner(){

            protected void setUp() {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() {
                WorkspacePerformanceTest.this.copyFolder();
            }
        }.run((TestCase)this, 5, 1);
    }

    public void testFolderMove() {
        new PerformanceTestRunner(){

            protected void setUp() {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() {
                WorkspacePerformanceTest.this.moveFolder();
            }
        }.run((TestCase)this, 5, 1);
    }

    public void testRefreshProject() {
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(50000);
                WorkspacePerformanceTest.this.deleteAndRecreateProject();
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() {
                try {
                    WorkspacePerformanceTest.this.testProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    WorkspacePerformanceTest.fail((String)"Failed to refresh during testRefreshProject", (Throwable)e);
                }
            }
        };
        runner.setFingerprintName("Refresh Project");
        runner.run((TestCase)this, 5, 1);
    }

    public void testCloseOpenProject() {
        new PerformanceTestRunner(){

            protected void setUp() {
                WorkspacePerformanceTest.this.createAndPopulateProject(50000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() {
                try {
                    WorkspacePerformanceTest.this.testProject.close(null);
                    WorkspacePerformanceTest.this.testProject.open(null);
                }
                catch (CoreException e) {
                    WorkspacePerformanceTest.fail((String)"Failed to close/open during testCloseOpenProject", (Throwable)e);
                }
            }
        }.run((TestCase)this, 5, 3);
    }

    public void testLoadSnapshot() {
        IProject snapProject = WorkspacePerformanceTest.getWorkspace().getRoot().getProject("SnapProject");
        this.ensureExistsInWorkspace((IResource)snapProject, true);
        final URI snapshotLocation = snapProject.getFile("snapshot.zip").getLocationURI();
        this.createAndPopulateProject(50000);
        this.waitForBackgroundActivity();
        try {
            this.testProject.saveSnapshot(1, snapshotLocation, null);
            this.testProject.delete(1, null);
        }
        catch (CoreException coreException) {
            WorkspacePerformanceTest.fail((String)"Failed to create snapshot during testLoadSnapshot");
        }
        this.waitForBackgroundActivity();
        new PerformanceTestRunner(){

            protected void setUp() {
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() {
                try {
                    WorkspacePerformanceTest.this.testProject.create(null);
                    WorkspacePerformanceTest.this.testProject.loadSnapshot(1, snapshotLocation, null);
                    WorkspacePerformanceTest.this.testProject.open(null);
                }
                catch (CoreException e) {
                    WorkspacePerformanceTest.fail((String)"Failed to load snapshot during testLoadSnapshot", (Throwable)e);
                }
            }
        }.run((TestCase)this, 5, 1);
    }

    public void waitForBackgroundActivity() {
        this.waitForSnapshot();
        this.waitForRefresh();
        this.waitForBuild();
    }

    private void waitForSnapshot() {
        Job wait = new Job("Wait"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        wait.setRule((ISchedulingRule)WorkspacePerformanceTest.getWorkspace().getRoot());
        wait.schedule();
        try {
            wait.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

