/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_026294
extends ResourceTest {
    public Bug_026294(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_026294.class);
    }

    public void testDeleteOpenProjectWindows() {
        if (!Bug_026294.isWindows()) {
            return;
        }
        IProject project = null;
        InputStream input = null;
        File projectRoot = null;
        try {
            IWorkspace workspace = Bug_026294.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder folder = project.getFolder("a_folder");
            IFile file1 = folder.getFile("file1.txt");
            IFile file2 = project.getFile("file2.txt");
            IFile file3 = folder.getFile("file3.txt");
            IFile projectFile = project.getFile((IPath)new Path(".project"));
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, file3}, true);
            projectRoot = project.getLocation().toFile();
            this.assertExistsInFileSystem("0.0", (IResource)file1);
            this.assertExistsInFileSystem("0.1", (IResource)file2);
            this.assertExistsInFileSystem("0.2", (IResource)file3);
            this.assertExistsInFileSystem("0.3", (IResource)folder);
            this.assertExistsInFileSystem("0.4", (IResource)projectFile);
            try {
                input = file1.getContents();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"1.0");
            }
            Bug_026294.assertTrue((String)"1.2", (boolean)projectFile.exists());
            Bug_026294.assertTrue((String)"1.3", (boolean)projectFile.isSynchronized(2));
            try {
                project.delete(1, this.getMonitor());
                Bug_026294.fail((String)"2.0 - should have failed");
            }
            catch (CoreException coreException) {}
            this.assertExistsInWorkspace("2.1.1", (IResource)project);
            this.assertExistsInFileSystem("2.1.2", (IResource)project);
            this.assertExistsInWorkspace("2.2.1", (IResource)file1);
            this.assertExistsInFileSystem("2.2.2", (IResource)file1);
            Bug_026294.assertTrue((String)"2.2.3", (boolean)file1.isSynchronized(2));
            this.assertDoesNotExistInWorkspace("2.3.1", (IResource)file2);
            this.assertDoesNotExistInFileSystem("2.3.2", (IResource)file2);
            Bug_026294.assertTrue((String)"2.3.3", (boolean)file2.isSynchronized(2));
            this.assertDoesNotExistInWorkspace("2.4.1", (IResource)file3);
            this.assertDoesNotExistInFileSystem("2.4.2", (IResource)file3);
            Bug_026294.assertTrue((String)"2.4.3", (boolean)file3.isSynchronized(2));
            this.assertExistsInWorkspace("2.5.1", (IResource)folder);
            this.assertExistsInFileSystem("2.5.2", (IResource)folder);
            Bug_026294.assertTrue((String)"2.5.3", (boolean)folder.isSynchronized(2));
            this.assertExistsInWorkspace("2.6.1", (IResource)projectFile);
            this.assertExistsInFileSystem("2.6.2", (IResource)projectFile);
            Bug_026294.assertTrue((String)"2.6.3", (boolean)projectFile.isSynchronized(2));
            Bug_026294.assertTrue((String)"2.7.0", (boolean)project.isSynchronized(0));
            Bug_026294.assertTrue((String)"2.7.1", (boolean)project.isSynchronized(2));
            this.assertClose(input);
            Bug_026294.assertTrue((String)"3.5", (boolean)project.isSynchronized(2));
            try {
                project.delete(1, this.getMonitor());
            }
            catch (CoreException e) {
                Bug_026294.fail((String)"4.0", (Throwable)e);
            }
            Bug_026294.assertTrue((String)"5.1", (!project.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.2", (!file1.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.3", (boolean)file1.isSynchronized(2));
            Bug_026294.assertTrue((String)"5.4", (boolean)project.isSynchronized(2));
            Bug_026294.assertTrue((String)"6.0", (!projectRoot.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            try {
                this.assertClose(input);
            }
            finally {
                if (projectRoot != null) {
                    this.ensureDoesNotExistInFileSystem(projectRoot);
                }
            }
            throw throwable;
        }
        try {
            this.assertClose(input);
        }
        finally {
            if (projectRoot != null) {
                this.ensureDoesNotExistInFileSystem(projectRoot);
            }
        }
    }

    public void testDeleteOpenProjectLinux() {
        if (!Platform.getOS().equals("linux") || !this.isReadOnlySupported()) {
            return;
        }
        IProject project = null;
        File projectRoot = null;
        IFolder folder = null;
        try {
            IWorkspace workspace = Bug_026294.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            folder = project.getFolder("a_folder");
            IFile file1 = folder.getFile("file1.txt");
            IFile file2 = project.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            projectRoot = project.getLocation().toFile();
            this.setReadOnly((IResource)folder, true);
            IFile projectFile = project.getFile(".project");
            Bug_026294.assertTrue((String)"1.2", (boolean)projectFile.exists());
            Bug_026294.assertTrue((String)"1.3", (boolean)projectFile.isSynchronized(2));
            try {
                project.delete(1, this.getMonitor());
                Bug_026294.fail((String)"2.0 - should have failed");
            }
            catch (CoreException coreException) {}
            Bug_026294.assertTrue((String)"2.1", (boolean)project.exists());
            Bug_026294.assertTrue((String)"2.2", (boolean)file1.exists());
            Bug_026294.assertTrue((String)"2.3", (!file2.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"2.5", (boolean)folder.exists());
            Bug_026294.assertTrue((String)"2.6", (boolean)projectFile.exists());
            Bug_026294.assertTrue((String)"2.7", (boolean)project.isSynchronized(2));
            this.setReadOnly((IResource)folder, false);
            Bug_026294.assertTrue((String)"3.5", (boolean)project.isSynchronized(2));
            try {
                project.delete(1, this.getMonitor());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"4.0", (Throwable)ce);
            }
            Bug_026294.assertTrue((String)"5.1", (!project.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.2", (!file1.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.3", (boolean)file1.isSynchronized(2));
            Bug_026294.assertTrue((String)"5.4", (boolean)project.isSynchronized(2));
            Bug_026294.assertTrue((String)"6.0", (!projectRoot.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            if (folder != null && folder.exists()) {
                this.setReadOnly((IResource)folder, false);
            }
            if (projectRoot != null) {
                this.ensureDoesNotExistInFileSystem(projectRoot);
            }
            throw throwable;
        }
        if (folder != null && folder.exists()) {
            this.setReadOnly((IResource)folder, false);
        }
        if (projectRoot != null) {
            this.ensureDoesNotExistInFileSystem(projectRoot);
        }
    }

    public void testDeleteClosedProjectWindows() {
        if (!Bug_026294.isWindows()) {
            return;
        }
        IProject project = null;
        InputStream input = null;
        File projectRoot = null;
        IFile file1 = null;
        try {
            IWorkspace workspace = Bug_026294.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder folder = project.getFolder("a_folder");
            file1 = folder.getFile("file1.txt");
            IFile file2 = project.getFile("file2.txt");
            IFile file3 = folder.getFile("file3.txt");
            IFile projectFile = project.getFile((IPath)new Path(".project"));
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, file3}, true);
            projectRoot = project.getLocation().toFile();
            try {
                input = file1.getContents();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"1.0");
            }
            try {
                project.close(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_026294.fail((String)"1.1", (Throwable)e);
            }
            try {
                project.delete(5, this.getMonitor());
                Bug_026294.fail((String)"2.0 - should have failed");
            }
            catch (CoreException coreException) {}
            Bug_026294.assertTrue((String)"2.1", (boolean)project.exists());
            Bug_026294.assertTrue((String)"2.7", (boolean)project.isSynchronized(2));
            this.assertExistsInFileSystem("2.8", (IResource)projectFile);
            this.assertClose(input);
            Bug_026294.assertTrue((String)"3.5", (boolean)project.isSynchronized(2));
            try {
                project.delete(5, this.getMonitor());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"4.0", (Throwable)ce);
            }
            Bug_026294.assertTrue((String)"5.1", (!project.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.3", (boolean)project.isSynchronized(2));
            Bug_026294.assertTrue((String)"6.0", (!projectRoot.exists() ? 1 : 0) != 0);
            this.assertDoesNotExistInFileSystem("7.0", (IResource)projectFile);
        }
        catch (Throwable throwable) {
            block28: {
                try {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        Bug_026294.fail((String)"8.0", (Throwable)e);
                        if (projectRoot != null) {
                            this.ensureDoesNotExistInFileSystem(projectRoot);
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable2) {
                    if (projectRoot != null) {
                        this.ensureDoesNotExistInFileSystem(projectRoot);
                    }
                    throw throwable2;
                }
                if (projectRoot != null) {
                    this.ensureDoesNotExistInFileSystem(projectRoot);
                }
            }
            throw throwable;
        }
        try {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Bug_026294.fail((String)"8.0", (Throwable)e);
                if (projectRoot != null) {
                    this.ensureDoesNotExistInFileSystem(projectRoot);
                }
            }
        }
        finally {
            if (projectRoot != null) {
                this.ensureDoesNotExistInFileSystem(projectRoot);
            }
        }
    }

    public void testDeleteClosedProjectLinux() {
        if (!Platform.getOS().equals("linux") || !this.isReadOnlySupported()) {
            return;
        }
        IProject project = null;
        File projectRoot = null;
        IFolder folder = null;
        try {
            IWorkspace workspace = Bug_026294.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            folder = project.getFolder("a_folder");
            IFile file1 = folder.getFile("file1.txt");
            IFile file2 = project.getFile("file2.txt");
            IFile projectFile = project.getFile((IPath)new Path(".project"));
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            projectRoot = project.getLocation().toFile();
            this.setReadOnly((IResource)folder, true);
            try {
                project.close(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_026294.fail((String)"1.0", (Throwable)e);
            }
            try {
                project.delete(5, this.getMonitor());
                Bug_026294.fail((String)"2.0 - should have failed");
            }
            catch (CoreException coreException) {}
            Bug_026294.assertTrue((String)"3.0", (boolean)project.exists());
            Bug_026294.assertTrue((String)"3.1", (boolean)project.isSynchronized(2));
            this.assertExistsInFileSystem("3.2", (IResource)projectFile);
            try {
                project.open(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_026294.fail((String)"4.0", (Throwable)e);
            }
            this.setReadOnly((IResource)folder, false);
            try {
                project.delete(5, this.getMonitor());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"5.0", (Throwable)ce);
            }
            Bug_026294.assertTrue((String)"6.0", (!project.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"6.1", (boolean)project.isSynchronized(2));
            Bug_026294.assertTrue((String)"6.2", (!projectRoot.exists() ? 1 : 0) != 0);
            this.assertDoesNotExistInFileSystem("6.3", (IResource)projectFile);
        }
        catch (Throwable throwable) {
            if (folder != null && folder.exists()) {
                this.setReadOnly((IResource)folder, false);
            }
            if (projectRoot != null) {
                this.ensureDoesNotExistInFileSystem(projectRoot);
            }
            throw throwable;
        }
        if (folder != null && folder.exists()) {
            this.setReadOnly((IResource)folder, false);
        }
        if (projectRoot != null) {
            this.ensureDoesNotExistInFileSystem(projectRoot);
        }
    }

    public void testDeleteFolderWindows() {
        if (!Bug_026294.isWindows()) {
            return;
        }
        IProject project = null;
        InputStream input = null;
        File projectRoot = null;
        try {
            IWorkspace workspace = Bug_026294.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder folder = project.getFolder("a_folder");
            IFile file1 = folder.getFile("file1.txt");
            IFile file3 = folder.getFile("file3.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file3}, true);
            projectRoot = project.getLocation().toFile();
            try {
                input = file1.getContents();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"1.0");
            }
            try {
                folder.delete(1, this.getMonitor());
                Bug_026294.fail((String)"2.0 - should have failed");
            }
            catch (CoreException coreException) {}
            Bug_026294.assertTrue((String)"2.2", (boolean)file1.exists());
            Bug_026294.assertTrue((String)"2.4", (!file3.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"2.5", (boolean)folder.exists());
            Bug_026294.assertTrue((String)"2.7", (boolean)folder.isSynchronized(2));
            this.assertClose(input);
            Bug_026294.assertTrue((String)"3.5", (boolean)project.isSynchronized(2));
            try {
                folder.delete(1, this.getMonitor());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"4.0", (Throwable)ce);
            }
            Bug_026294.assertTrue((String)"5.1", (!file1.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.2", (!folder.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.3", (boolean)file1.isSynchronized(2));
            Bug_026294.assertTrue((String)"5.4", (boolean)folder.isSynchronized(2));
        }
        catch (Throwable throwable) {
            try {
                this.assertClose(input);
            }
            finally {
                if (projectRoot != null) {
                    this.ensureDoesNotExistInFileSystem(projectRoot);
                }
            }
            throw throwable;
        }
        try {
            this.assertClose(input);
        }
        finally {
            if (projectRoot != null) {
                this.ensureDoesNotExistInFileSystem(projectRoot);
            }
        }
    }

    public void testDeleteFolderLinux() {
        if (!Platform.getOS().equals("linux") || !this.isReadOnlySupported()) {
            return;
        }
        IProject project = null;
        File projectRoot = null;
        IFolder subFolder = null;
        try {
            IWorkspace workspace = Bug_026294.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder folder = project.getFolder("a_folder");
            subFolder = folder.getFolder("sub-folder");
            IFile file1 = subFolder.getFile("file1.txt");
            IFile file3 = folder.getFile("file3.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file3}, true);
            projectRoot = project.getLocation().toFile();
            this.setReadOnly((IResource)subFolder, true);
            try {
                folder.delete(1, this.getMonitor());
                Bug_026294.fail((String)"2.0 - should have failed");
            }
            catch (CoreException coreException) {}
            Bug_026294.assertTrue((String)"2.2", (boolean)file1.exists());
            Bug_026294.assertTrue((String)"2.3", (boolean)subFolder.exists());
            Bug_026294.assertTrue((String)"2.4", (!file3.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"2.5", (boolean)folder.exists());
            Bug_026294.assertTrue((String)"2.7", (boolean)folder.isSynchronized(2));
            this.setReadOnly((IResource)subFolder, false);
            Bug_026294.assertTrue((String)"3.5", (boolean)project.isSynchronized(2));
            try {
                folder.delete(1, this.getMonitor());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                Bug_026294.fail((String)"4.0", (Throwable)ce);
            }
            Bug_026294.assertTrue((String)"5.1", (!file1.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.2", (!subFolder.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.3", (!folder.exists() ? 1 : 0) != 0);
            Bug_026294.assertTrue((String)"5.4", (boolean)file1.isSynchronized(2));
            Bug_026294.assertTrue((String)"5.5", (boolean)folder.isSynchronized(2));
        }
        catch (Throwable throwable) {
            if (subFolder != null && subFolder.exists()) {
                this.setReadOnly((IResource)subFolder, false);
            }
            if (projectRoot != null) {
                this.ensureDoesNotExistInFileSystem(projectRoot);
            }
            throw throwable;
        }
        if (subFolder != null && subFolder.exists()) {
            this.setReadOnly((IResource)subFolder, false);
        }
        if (projectRoot != null) {
            this.ensureDoesNotExistInFileSystem(projectRoot);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

