/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_029671
extends ResourceTest {
    public Bug_029671(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_029671.class);
    }

    public void testBug() {
        QualifiedName partner = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        IWorkspace workspace = Bug_029671.getWorkspace();
        ISynchronizer synchronizer = workspace.getSynchronizer();
        synchronizer.add(partner);
        IProject project = workspace.getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("source");
        IFile file = folder.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)file, true);
        try {
            try {
                synchronizer.setSyncInfo(partner, (IResource)folder, this.getRandomString().getBytes());
                synchronizer.setSyncInfo(partner, (IResource)file, this.getRandomString().getBytes());
            }
            catch (CoreException ce) {
                Bug_029671.fail((String)"1.0", (Throwable)ce);
            }
            IFolder targetFolder = project.getFolder("target");
            IFile targetFile = targetFolder.getFile(file.getName());
            try {
                folder.move(targetFolder.getFullPath(), false, false, this.getMonitor());
            }
            catch (CoreException e) {
                Bug_029671.fail((String)"2.0", (Throwable)e);
            }
            Bug_029671.assertTrue((String)"3.0", (boolean)folder.isPhantom());
            Bug_029671.assertTrue((String)"4.0", (boolean)file.isPhantom());
            this.assertExistsInWorkspace("5.0", (IResource)targetFolder);
            Bug_029671.assertTrue((String)"5.1", (!targetFolder.isPhantom() ? 1 : 0) != 0);
            this.assertExistsInWorkspace("6.0", (IResource)targetFile);
            Bug_029671.assertTrue((String)"6.1", (!targetFile.isPhantom() ? 1 : 0) != 0);
        }
        finally {
            synchronizer.remove(partner);
        }
    }
}

