/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_079398
extends ResourceTest {
    public Bug_079398(String name) {
        super(name);
    }

    public void testBug79398() {
        IProject project = Bug_079398.getWorkspace().getRoot().getProject("myproject");
        IFile file1 = project.getFile("myFile.txt");
        IFile file2 = project.getFile("copyOfMyFile.txt");
        IWorkspaceDescription originalDescription = Bug_079398.getWorkspace().getDescription();
        IWorkspaceDescription description = Bug_079398.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(4);
        description.setMaxFileStateSize(0x100000L);
        try {
            Bug_079398.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            Bug_079398.fail((String)"0.1", (Throwable)e);
        }
        try {
            this.ensureExistsInWorkspace(file1, this.getRandomContents());
            try {
                int i = 0;
                while (i < 10) {
                    file1.setContents(this.getRandomContents(), 3, this.getMonitor());
                    ++i;
                }
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"0.2", (Throwable)e);
            }
            IFileState[] sourceStates = null;
            try {
                sourceStates = file1.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"0.3", (Throwable)e);
            }
            Bug_079398.assertEquals((String)"0.4", (int)10, (int)sourceStates.length);
            try {
                file1.copy(file2.getFullPath(), true, this.getMonitor());
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"0.4", (Throwable)e);
            }
            this.assertExistsInWorkspace("1.0", (IResource)file2);
            try {
                sourceStates = file1.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"1.1", (Throwable)e);
            }
            Bug_079398.assertEquals((String)"1.2", (int)10, (int)sourceStates.length);
            IFileState[] destinationStates = null;
            try {
                destinationStates = file2.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"1.3", (Throwable)e);
            }
            Bug_079398.assertEquals((String)"1.4", (int)description.getMaxFileStates(), (int)destinationStates.length);
            try {
                int i = 0;
                while (i <= description.getMaxFileStates()) {
                    file2.setContents(this.getRandomContents(), 3, this.getMonitor());
                    ++i;
                }
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"1.5", (Throwable)e);
            }
            IHistoryStore history = ((Workspace)Bug_079398.getWorkspace()).getFileSystemManager().getHistoryStore();
            history.clean(this.getMonitor());
            try {
                destinationStates = file2.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"1.6", (Throwable)e);
            }
            Bug_079398.assertEquals((String)"1.7", (int)description.getMaxFileStates(), (int)destinationStates.length);
            try {
                sourceStates = file1.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_079398.fail((String)"1.8", (Throwable)e);
            }
            Bug_079398.assertEquals((String)"1.7", (int)description.getMaxFileStates(), (int)sourceStates.length);
            int i = 0;
            while (i < sourceStates.length) {
                Bug_079398.assertTrue((String)("1.8." + i), (boolean)sourceStates[i].exists());
                ++i;
            }
        }
        finally {
            try {
                Bug_079398.getWorkspace().setDescription(originalDescription);
            }
            catch (CoreException e) {
                Bug_079398.log((String)"org.eclipse.core.tests.resources", (Throwable)e);
            }
        }
    }
}

