/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileStore;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_332543
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_332543.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        WrapperFileSystem.setCustomFileStore(null);
        super.tearDown();
    }

    public void testBug() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String proj_name = this.getUniqueString();
        IPath proj_loc = root.getLocation().append(proj_name);
        URI proj_uri = WrapperFileSystem.getWrappedURI(URIUtil.toURI((IPath)proj_loc));
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(proj_name);
        desc.setLocationURI(proj_uri);
        IProject project = root.getProject(desc.getName());
        project.create(desc, this.getMonitor());
        IFile f = project.getFile("foo.txt");
        this.ensureExistsInFileSystem(f);
        WrapperFileSystem.setCustomFileStore(IOErrOnCloseFileStore.class);
        project.open(this.getMonitor());
        try {
            f.setContents((InputStream)new ByteArrayInputStream("Random".getBytes()), false, true, this.getMonitor());
            Bug_332543.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        f = project.getFile("foo1.txt");
        try {
            f.create((InputStream)new ByteArrayInputStream("Random".getBytes()), false, this.getMonitor());
            Bug_332543.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
    }

    public static class IOErrOnCloseFileStore
    extends WrapperFileStore {
        public IOErrOnCloseFileStore(IFileStore store) {
            super(store);
        }

        public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
            OutputStream os = super.openOutputStream(options, monitor);
            os = new BufferedOutputStream(os){

                public void close() throws IOException {
                    super.close();
                    throw new IOException("Whoops I dunno how to close!");
                }
            };
            return os;
        }
    }
}

