/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class IFolderTest
extends ResourceTest {
    public IFolderTest() {
    }

    public IFolderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IFolderTest.class);
    }

    public void testBug25662() {
        if (!this.isReadOnlySupported()) {
            return;
        }
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = IFolderTest.getWorkspace().getRoot().getProject("MyProject");
        IFolder parentFolder = project.getFolder("parentFolder");
        this.ensureExistsInWorkspace(new IResource[]{project, parentFolder}, true);
        IFolder folder = parentFolder.getFolder("folder");
        try {
            parentFolder.setReadOnly(true);
            IFolderTest.assertTrue((String)"0.0", (boolean)parentFolder.isReadOnly());
            try {
                folder.create(true, true, this.getMonitor());
                IFolderTest.fail((String)"0.1");
            }
            catch (CoreException e) {
                IFolderTest.assertEquals((String)"0.2", (int)277, (int)e.getStatus().getCode());
            }
        }
        finally {
            parentFolder.setReadOnly(false);
        }
    }

    public void testBug11510() {
        IWorkspaceRoot root = IFolderTest.getWorkspace().getRoot();
        IProject project = root.getProject("TestProject");
        IFolder folder = project.getFolder("fold1");
        IFile subFile = folder.getFile("f1");
        IFile file = project.getFile("f2");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(new IResource[]{folder, file, subFile}, false);
        IFolderTest.assertTrue((String)"1.0", (!folder.isLocal(0) ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"1.1", (!file.isLocal(0) ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"1.1", (!subFile.isLocal(0) ? 1 : 0) != 0);
        this.ensureExistsInFileSystem(file);
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"2.0", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"2.1", (boolean)file.isLocal(0));
        IFolderTest.assertTrue((String)"2.2", (!folder.isLocal(0) ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"2.3", (!subFile.isLocal(0) ? 1 : 0) != 0);
        folder.getLocation().toFile().mkdir();
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"3.0", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"3.1", (boolean)folder.isLocal(0));
        IFolderTest.assertTrue((String)"3.2", (boolean)file.isLocal(0));
        IFolderTest.assertTrue((String)"3.3", (!subFile.isLocal(0) ? 1 : 0) != 0);
        this.ensureExistsInFileSystem(subFile);
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"4.0", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"4.1", (boolean)subFile.isLocal(0));
        IFolderTest.assertTrue((String)"4.2", (boolean)folder.isLocal(0));
        IFolderTest.assertTrue((String)"4.3", (boolean)file.isLocal(0));
    }
}

