/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;

public class IProjectTest
extends AbstractBuilderTest {
    public static Test suite() {
        return new TestSuite(IProjectTest.class);
    }

    public IProjectTest() {
        super("");
    }

    public IProjectTest(String name) {
        super(name);
    }

    public void test_1G0XIMA() throws CoreException {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        IResourceVisitor renameVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (!resource.exists()) {
                    return false;
                }
                IPath path = resource.getFullPath();
                path = path.removeLastSegments(1);
                long timestamp = System.currentTimeMillis();
                path = path.append(String.valueOf(resource.getName()) + " renamed at " + timestamp);
                resource.move(path, false, null);
                return true;
            }
        };
        try {
            project.accept(renameVisitor);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        project.delete(true, this.getMonitor());
    }

    public void test_1G5I6PV() throws CoreException {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        try {
            project.setLocal(true, 0, this.getMonitor());
        }
        catch (Exception e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        project.delete(true, this.getMonitor());
    }

    public void testAutoBuild_1GC2FKV() {
        try {
            IWorkspaceDescription description = IProjectTest.getWorkspace().getDescription();
            description.setAutoBuilding(false);
            IProjectTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"0.0", (Throwable)e);
        }
        IProject projectONE = IProjectTest.getWorkspace().getRoot().getProject("Project_ONE");
        try {
            IProjectDescription prjDescription = IProjectTest.getWorkspace().newProjectDescription("ProjectONE");
            ICommand command = prjDescription.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
            prjDescription.setBuildSpec(new ICommand[]{command});
            projectONE.create(prjDescription, this.getMonitor());
            projectONE.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"0.1", (Throwable)e);
        }
        IProject projectTWO = IProjectTest.getWorkspace().getRoot().getProject("Project_TWO");
        try {
            IProjectDescription prjDescription = IProjectTest.getWorkspace().newProjectDescription("Project_TWO");
            ICommand command = prjDescription.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
            prjDescription.setBuildSpec(new ICommand[]{command});
            projectTWO.create(prjDescription, this.getMonitor());
            projectTWO.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"0.2", (Throwable)e);
        }
        try {
            IWorkspaceDescription description = IProjectTest.getWorkspace().getDescription();
            description.setAutoBuilding(true);
            IProjectTest.getWorkspace().setDescription(description);
            IProjectTest.getWorkspace().build(6, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"0.0", (Throwable)e);
        }
        SignaledBuilder projectONEbuilder = SignaledBuilder.getInstance(projectONE);
        SignaledBuilder projectTWObuilder = SignaledBuilder.getInstance(projectTWO);
        projectONEbuilder.reset();
        projectTWObuilder.reset();
        try {
            projectONE.build(6, null);
            this.waitForBuild();
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.1", (boolean)projectONEbuilder.wasExecuted());
        IProjectTest.assertTrue((String)"1.2", (!projectTWObuilder.wasExecuted() ? 1 : 0) != 0);
        projectONEbuilder.reset();
        projectTWObuilder.reset();
        try {
            projectTWO.build(6, "org.eclipse.core.tests.resources.sigbuilder", null, null);
            this.waitForBuild();
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.1", (!projectONEbuilder.wasExecuted() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.2", (boolean)projectTWObuilder.wasExecuted());
        projectONEbuilder.reset();
        projectTWObuilder.reset();
        try {
            projectTWO.touch(null);
            this.waitForBuild();
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.1", (!projectONEbuilder.wasExecuted() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.2", (boolean)projectTWObuilder.wasExecuted());
    }

    public void testBug78711() {
        String name = this.getUniqueString();
        IProject project = IProjectTest.getWorkspace().getRoot().getProject(name);
        IFolder folder = project.getFolder("folder");
        IFile file1 = project.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IPath location = Platform.getLocation().append(project.getFullPath());
        location.toFile().mkdirs();
        location.append(folder.getName()).toFile().mkdirs();
        this.createFileInFileSystem(location.append(folder.getName()).append(file2.getName()));
        this.createFileInFileSystem(location.append(file1.getName()));
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.0", (boolean)project.isAccessible());
        IProjectTest.assertTrue((String)"2.1", (boolean)folder.exists());
        IProjectTest.assertTrue((String)"2.2", (boolean)file1.exists());
        IProjectTest.assertTrue((String)"2.3", (boolean)file2.exists());
    }

    public void testDelete_1GDW1RX() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"0.0", (Throwable)e);
        }
        String[] paths = new String[]{"/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1"};
        IResource[] resources = this.buildResources((IContainer)project, paths);
        this.ensureExistsInWorkspace(resources, true);
        IFolder folder = project.getFolder("folder");
        this.ensureExistsInFileSystem((IResource)folder);
        IFile file = folder.getFile("MyFile");
        this.ensureExistsInFileSystem(file);
        try {
            project.delete(false, this.getMonitor());
            IProjectTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testRefreshDotProject() {
        String name = this.getUniqueString();
        IProject project = IProjectTest.getWorkspace().getRoot().getProject(name);
        IFile dotProject = project.getFile(".project");
        try {
            project.create(null);
            project.open(null);
            this.touchInFilesystem((IResource)dotProject);
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            IProjectDescription description = project.getDescription();
            description.setComment("Changed description");
            project.setDescription(description, 0, null);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.99", (Throwable)e);
        }
    }
}

