/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;

public class PR_1GEAB3C_Test
extends ResourceTest {
    ResourceDeltaVerifier verifier;
    protected static final String VERIFIER_NAME = "TestListener";

    public PR_1GEAB3C_Test() {
    }

    public PR_1GEAB3C_Test(String name) {
        super(name);
    }

    public void assertDelta() {
        PR_1GEAB3C_Test.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
    }

    protected void handleCoreException(CoreException e) {
        PR_1GEAB3C_Test.assertTrue((String)("CoreException: " + e.getMessage()), (boolean)false);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForBuild();
        this.waitForRefresh();
        this.verifier = new ResourceDeltaVerifier();
        PR_1GEAB3C_Test.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.verifier);
    }

    public static Test suite() {
        return new TestSuite(PR_1GEAB3C_Test.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ensureDoesNotExistInWorkspace((IResource)PR_1GEAB3C_Test.getWorkspace().getRoot());
        PR_1GEAB3C_Test.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.verifier);
    }

    public void test_1GEAB3C() {
        this.verifier.reset();
        final IProject project = PR_1GEAB3C_Test.getWorkspace().getRoot().getProject("MyAddedAndOpenedProject");
        this.verifier.addExpectedChange((IResource)project, 1, 16384);
        this.verifier.addExpectedChange((IResource)project.getFile(".project"), 1, 0);
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Creating and deleting", 100);
                try {
                    project.create((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    project.open((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PR_1GEAB3C_Test.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            PR_1GEAB3C_Test.fail((String)"1.1", (Throwable)e);
        }
        this.assertDelta();
    }
}

