/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class ProjectDescriptionDynamicTest
extends WorkspaceSessionTest {
    IProject proj;
    String[] configNames;
    IBuildConfiguration[] configs;
    IProject[] dynRefs;
    IBuildConfiguration[] configRefs;
    IProject[] configRefsProjects;

    public ProjectDescriptionDynamicTest() {
    }

    public IBuildConfiguration getRef(IProject project) {
        return ProjectDescriptionDynamicTest.getWorkspace().newBuildConfig(project.getName(), null);
    }

    public IBuildConfiguration getConfig(IProject project, String id) {
        return ProjectDescriptionDynamicTest.getWorkspace().newBuildConfig(project.getName(), id);
    }

    protected void setUp() throws Exception {
        IWorkspaceRoot wr = ProjectDescriptionDynamicTest.getWorkspace().getRoot();
        this.proj = wr.getProject("referencing");
        this.configNames = new String[]{"someConfiguration", "someConfiguration2"};
        this.configs = new IBuildConfiguration[]{this.getConfig(this.proj, "someConfiguration"), this.getConfig(this.proj, "someConfiguration2")};
        this.dynRefs = new IProject[]{wr.getProject("ref1"), wr.getProject("ref2")};
        this.configRefs = new IBuildConfiguration[]{ProjectDescriptionDynamicTest.getWorkspace().newBuildConfig("ref3", "ref3config1"), ProjectDescriptionDynamicTest.getWorkspace().newBuildConfig("ref2", "ref2config1"), ProjectDescriptionDynamicTest.getWorkspace().newBuildConfig("ref1", "ref1config1")};
        this.configRefsProjects = new IProject[]{wr.getProject("ref3"), wr.getProject("ref2"), wr.getProject("ref1")};
        super.setUp();
    }

    public ProjectDescriptionDynamicTest(String name) {
        super(name);
    }

    public void test1() throws Exception {
        this.proj.create(this.getMonitor());
        this.proj.open(this.getMonitor());
        IProjectDescription desc = this.proj.getDescription();
        desc.setBuildConfigs(this.configNames);
        desc.setDynamicReferences(this.dynRefs);
        this.proj.setDescription(desc, this.getMonitor());
        ResourcesPlugin.getWorkspace().save(true, this.getMonitor());
    }

    public void test2() throws Exception {
        ProjectDescriptionDynamicTest.assertTrue((String)"1.0", (boolean)this.proj.isAccessible());
        this.assertEquals("1.1", this.dynRefs, this.proj.getDescription().getDynamicReferences());
        this.assertEquals("1.2", this.configs, this.proj.getBuildConfigs());
        ProjectDescriptionDynamicTest.assertEquals((String)"1.3", (Object)this.configs[0], (Object)this.proj.getActiveBuildConfig());
        IProjectDescription desc = this.proj.getDescription();
        desc.setBuildConfigReferences(this.configs[1].getName(), this.configRefs);
        desc.setActiveBuildConfig(this.configs[1].getName());
        this.proj.setDescription(desc, this.getMonitor());
        ResourcesPlugin.getWorkspace().save(true, this.getMonitor());
    }

    public void test3() throws Exception {
        ProjectDescriptionDynamicTest.assertTrue((String)"2.0", (boolean)this.proj.isAccessible());
        ProjectDescriptionDynamicTest.assertEquals((String)"2.1", (Object)this.configs[1], (Object)this.proj.getActiveBuildConfig());
        this.assertEquals("2.2", this.dynRefs, this.proj.getDescription().getDynamicReferences());
        this.assertEquals("2.4", this.configRefsProjects, this.proj.getReferencedProjects());
        this.assertEquals("2.5", this.configRefs, this.proj.getDescription().getBuildConfigReferences(this.configs[1].getName()));
        Object[] refs = new IBuildConfiguration[]{this.configRefs[0], this.configRefs[1], this.configRefs[2], this.getRef(this.dynRefs[0]), this.getRef(this.dynRefs[1])};
        this.assertEquals("2.6", refs, this.proj.getReferencedBuildConfigs(this.configs[1].getName(), true));
        this.assertEquals("2.7", new IBuildConfiguration[0], this.proj.getReferencedBuildConfigs(this.configs[1].getName(), false));
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", ProjectDescriptionDynamicTest.class);
    }
}

