/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.IOException;
import java.net.URI;
import junit.framework.Test;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug113943
extends WorkspaceSerializationTest {
    IPath location = Platform.getLocation().removeLastSegments(1).append("OtherLocation");

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug113943.class);
    }

    public void test1() {
        IProject project = this.workspace.getRoot().getProject("Project1");
        IFolder link = project.getFolder("link");
        IFile linkChild = link.getFile("child.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            IFileStore parent = EFS.getStore((URI)this.location.toFile().toURI());
            IFileStore child = parent.getChild(linkChild.getName());
            parent.mkdir(0, this.getMonitor());
            child.openOutputStream(0, this.getMonitor()).close();
            link.createLink(this.location, 0, this.getMonitor());
            TestBug113943.assertTrue((String)"1.0", (boolean)link.exists());
            TestBug113943.assertTrue((String)"1.1", (boolean)linkChild.exists());
            TestBug113943.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug113943.fail((String)"1.99", (Throwable)e);
        }
        catch (IOException e) {
            TestBug113943.fail((String)"1.99", (Throwable)e);
        }
    }

    public void test2() {
        IProject project = this.workspace.getRoot().getProject("Project1");
        IFolder link = project.getFolder("link");
        IFile linkChild = link.getFile("child.txt");
        try {
            link.refreshLocal(2, this.getMonitor());
            TestBug113943.assertTrue((String)"1.0", (boolean)link.exists());
            TestBug113943.assertTrue((String)"1.1", (boolean)linkChild.exists());
            this.cleanup();
        }
        catch (CoreException e) {
            TestBug113943.fail((String)"1.0", (Throwable)e);
        }
    }
}

