/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug20127
extends WorkspaceSerializationTest {
    public void test1() {
        IProject project = this.workspace.getRoot().getProject("Project1");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            IWorkspaceDescription desc = this.workspace.getDescription();
            desc.setAutoBuilding(false);
            this.workspace.setDescription(desc);
            IProjectDescription description = project.getDescription();
            ICommand command = description.newCommand();
            Map args = command.getArguments();
            args.put("BuildID", "Project1Build1");
            command.setBuilderName("org.eclipse.core.tests.resources.deltaverifierbuilder");
            command.setArguments(args);
            description.setBuildSpec(new ICommand[]{command});
            project.setDescription(description, this.getMonitor());
            this.workspace.build(6, this.getMonitor());
            TestBug20127.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug20127.fail((String)"1.0", (Throwable)e);
        }
    }

    public void test2() {
        try {
            IProject project = this.workspace.getRoot().getProject("Project1");
            IProjectDescription desc = project.getDescription();
            desc.setName("MovedProject");
            project.move(desc, 0, this.getMonitor());
            this.workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug20127.fail((String)"1.0", (Throwable)e);
        }
    }

    public void test3() {
        IProject oldLocation = this.workspace.getRoot().getProject("Project1");
        IProject newLocation = this.workspace.getRoot().getProject("MovedProject");
        TestBug20127.assertTrue((String)"1.0", (!oldLocation.exists() ? 1 : 0) != 0);
        TestBug20127.assertTrue((String)"1.0", (boolean)newLocation.exists());
        TestBug20127.assertTrue((String)"1.1", (boolean)newLocation.isOpen());
        try {
            this.workspace.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug20127.fail((String)"1.99", (Throwable)e);
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug20127.class);
    }
}

