/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.TestingSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug294854
extends WorkspaceSessionTest {
    private static final String PROJECT_OLD_NAME = "project_old_name";
    private static final String PROJECT_NEW_NAME = "project_new_name";

    public static Test suite() {
        TestSuite suite = new TestSuite(TestBug294854.class.getName());
        WorkspaceSessionTestSuite scenario1 = new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", "renameUsingProjectDescription");
        scenario1.addCrashTest((TestCase)new TestBug294854("testRenameUsingProjectDescription_01"));
        scenario1.addTest((Test)new TestBug294854("testRenameUsingProjectDescription_02"));
        WorkspaceSessionTestSuite scenario2 = new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", "renameUsingResourcePath");
        scenario2.addCrashTest((TestCase)new TestBug294854("testRenameUsingResourcePath_01"));
        scenario2.addTest((Test)new TestBug294854("testRenameUsingResourcePath_02"));
        WorkspaceSessionTestSuite scenario3 = new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", "delete");
        scenario3.addCrashTest((TestCase)new TestBug294854("testDelete_01"));
        scenario3.addTest((Test)new TestBug294854("testDelete_02"));
        suite.addTest((Test)scenario1);
        suite.addTest((Test)scenario2);
        suite.addTest((Test)scenario3);
        return suite;
    }

    public TestBug294854() {
    }

    public TestBug294854(String name) {
        super(name);
    }

    private IProject createProject() throws CoreException {
        IWorkspace workspace = TestBug294854.getWorkspace();
        IProject project = workspace.getRoot().getProject(PROJECT_OLD_NAME);
        this.ensureExistsInWorkspace((IResource)project, true);
        TestBug294854.assertTrue((String)"1.0", (boolean)project.exists());
        TestingSupport.waitForSnapshot();
        workspace.save(true, this.getMonitor());
        return project;
    }

    private boolean checkProjectExists(String name) {
        IProject project = TestBug294854.getWorkspace().getRoot().getProject(name);
        return project.exists();
    }

    public void testRenameUsingProjectDescription_01() throws CoreException, InterruptedException {
        IProject project = this.createProject();
        IProjectDescription description = project.getDescription();
        description.setName(PROJECT_NEW_NAME);
        project.move(description, true, this.getMonitor());
        Thread.sleep(1000L);
        System.exit(1);
    }

    public void testRenameUsingProjectDescription_02() {
        TestBug294854.assertFalse((String)"1.0", (boolean)this.checkProjectExists(PROJECT_OLD_NAME));
        TestBug294854.assertTrue((String)"2.0", (boolean)this.checkProjectExists(PROJECT_NEW_NAME));
    }

    public void testRenameUsingResourcePath_01() throws CoreException, InterruptedException {
        IProject project = this.createProject();
        project.move(project.getFullPath().removeLastSegments(1).append(PROJECT_NEW_NAME), true, this.getMonitor());
        Thread.sleep(1000L);
        System.exit(1);
    }

    public void testRenameUsingResourcePath_02() {
        TestBug294854.assertFalse((String)"1.0", (boolean)this.checkProjectExists(PROJECT_OLD_NAME));
        TestBug294854.assertTrue((String)"2.0", (boolean)this.checkProjectExists(PROJECT_NEW_NAME));
    }

    public void testDelete_01() throws CoreException {
        IProject project = this.createProject();
        project.delete(true, this.getMonitor());
        System.exit(1);
    }

    public void testDelete_02() {
        TestBug294854.assertFalse((String)"1.0", (boolean)this.checkProjectExists(PROJECT_OLD_NAME));
    }
}

