/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug30015
extends WorkspaceSessionTest {
    protected static final String PROJECT_NAME = "Project";
    protected static final String VAR_NAME = "ProjectLocatio";
    protected IPath varValue;
    protected IPath rawLocation;

    public TestBug30015() {
    }

    public TestBug30015(String name) {
        super(name);
    }

    public void test1() {
        this.varValue = Platform.getLocation().removeLastSegments(1);
        this.rawLocation = new Path(VAR_NAME).append("ProjectLocation");
        try {
            TestBug30015.getWorkspace().getPathVariableManager().setValue(VAR_NAME, this.varValue);
        }
        catch (CoreException e) {
            TestBug30015.fail((String)"1.0", (Throwable)e);
        }
        IProject project = TestBug30015.getWorkspace().getRoot().getProject(PROJECT_NAME);
        IProjectDescription description = TestBug30015.getWorkspace().newProjectDescription(PROJECT_NAME);
        description.setLocation(this.rawLocation);
        try {
            project.create(description, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            TestBug30015.fail((String)"9.99", (Throwable)e);
        }
        try {
            TestBug30015.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug30015.fail((String)"9.99", (Throwable)e);
        }
    }

    public void test2() {
        this.varValue = Platform.getLocation().removeLastSegments(1);
        this.rawLocation = new Path(VAR_NAME).append("ProjectLocation");
        IProject project = TestBug30015.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestBug30015.assertEquals((String)"1.0", (Object)this.varValue, (Object)TestBug30015.getWorkspace().getPathVariableManager().getValue(VAR_NAME));
        TestBug30015.assertTrue((String)"1.1", (boolean)project.exists());
        TestBug30015.assertTrue((String)"1.2", (boolean)project.isOpen());
        TestBug30015.assertEquals((String)"1.3", (Object)this.rawLocation, (Object)project.getRawLocation());
        TestBug30015.assertEquals((String)"1.4", (Object)this.varValue.append(this.rawLocation.lastSegment()), (Object)project.getLocation());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug30015.class);
    }
}

