/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;

public class IWorkspaceRunnableUseCaseTest
extends ResourceTest {
    public IWorkspaceRunnableUseCaseTest() {
    }

    public IWorkspaceRunnableUseCaseTest(String name) {
        super(name);
    }

    protected IWorkspaceRunnable createRunnable(final IProject project, final IWorkspaceRunnable nestedOperation, final boolean triggerBuild, final boolean shouldCancel) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (shouldCancel) {
                    throw new OperationCanceledException();
                }
                if (triggerBuild) {
                    project.touch(IWorkspaceRunnableUseCaseTest.this.getMonitor());
                }
                if (nestedOperation != null) {
                    IWorkspaceRunnableUseCaseTest.getWorkspace().run(nestedOperation, IWorkspaceRunnableUseCaseTest.this.getMonitor());
                }
            }
        };
    }

    public static Test suite() {
        return new TestSuite(IWorkspaceRunnableUseCaseTest.class);
    }

    public void testNestedOperationsAndBuilds() {
        IWorkspaceDescription original = IWorkspaceRunnableUseCaseTest.getWorkspace().getDescription();
        IProject project = IWorkspaceRunnableUseCaseTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            IWorkspaceDescription description = IWorkspaceRunnableUseCaseTest.getWorkspace().getDescription();
            description.setAutoBuilding(true);
            IWorkspaceRunnableUseCaseTest.getWorkspace().setDescription(description);
            IProjectDescription prjDescription = IWorkspaceRunnableUseCaseTest.getWorkspace().newProjectDescription("MyProject");
            ICommand command = prjDescription.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
            prjDescription.setBuildSpec(new ICommand[]{command});
            project.create(prjDescription, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"0.0", (Throwable)e);
        }
        this.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project);
        IWorkspaceRunnable op1 = this.createRunnable(project, null, true, false);
        IWorkspaceRunnable op2 = this.createRunnable(project, op1, false, false);
        IWorkspaceRunnable op3 = this.createRunnable(project, op2, false, false);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"1.0", (Throwable)e);
        }
        this.waitForBuild();
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"1.1", (boolean)builder.wasExecuted());
        op1 = this.createRunnable(project, null, true, true);
        op2 = this.createRunnable(project, op1, true, false);
        op3 = this.createRunnable(project, op2, true, false);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"2.0", (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {}
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"2.1", (!builder.wasExecuted() ? 1 : 0) != 0);
        op1 = this.createRunnable(project, null, false, false);
        op2 = this.createRunnable(project, op1, false, false);
        op3 = this.createRunnable(project, op2, false, false);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"3.0", (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {}
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"3.1", (!builder.wasExecuted() ? 1 : 0) != 0);
        try {
            project.delete(true, this.getMonitor());
            IWorkspaceRunnableUseCaseTest.getWorkspace().setDescription(original);
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"20.0", (Throwable)e);
        }
    }
}

