/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipe.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;

public class LaunchFavoriteTests
extends AbstractLaunchTest {
    private ILaunchConfiguration fConfig;

    public LaunchFavoriteTests(String name) {
        super(name);
    }

    private LaunchHistory getRunLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.run");
    }

    private LaunchHistory getDebugLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getRunLaunchHistory().setFavorites(new ILaunchConfiguration[0]);
        this.getDebugLaunchHistory().setFavorites(new ILaunchConfiguration[0]);
        this.fConfig = this.getLaunchConfiguration(this.getName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ILaunchConfiguration configuration = this.getLaunchConfiguration();
        if (configuration.exists()) {
            configuration.delete();
        }
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfig;
    }

    private ILaunchConfigurationWorkingCopy addFavorite(ILaunchConfiguration config, String groupId) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(config);
        ArrayList<String> list = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(groupId);
        wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        return wc;
    }

    private ILaunchConfigurationWorkingCopy removeFavorite(ILaunchConfiguration config, String groupId) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(config);
        List list = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
        if (list != null && list.remove(groupId)) {
            if (list.isEmpty()) {
                list = null;
            }
            wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        }
        return wc;
    }

    private ILaunchConfigurationWorkingCopy getWorkingCopy(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = config.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)config : config.getWorkingCopy();
        return wc;
    }

    private boolean containsFavorite(LaunchHistory history, ILaunchConfiguration configuration, int size) {
        ILaunchConfiguration[] favorites = history.getFavorites();
        LaunchFavoriteTests.assertNotNull((String)"No favorites", (Object)favorites);
        if (size != -1) {
            LaunchFavoriteTests.assertEquals((String)"Favorites wrong size", (int)size, (int)favorites.length);
        }
        int i = 0;
        while (i < favorites.length) {
            if (configuration.equals(favorites[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void testBecomeFavorite() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.addFavorite(this.getLaunchConfiguration(), "org.eclipse.debug.ui.launchGroup.debug");
        this.addFavorite((ILaunchConfiguration)wc, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = wc.doSave();
        LaunchFavoriteTests.assertTrue((String)"Missing from debug favorites", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 1));
        LaunchFavoriteTests.assertTrue((String)"Missing from run favorites", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 1));
    }

    public void testUnFavorite() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfigurationWorkingCopy wc = this.removeFavorite(this.getLaunchConfiguration(), "org.eclipse.debug.ui.launchGroup.debug");
        this.removeFavorite((ILaunchConfiguration)wc, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = wc.doSave();
        LaunchFavoriteTests.assertFalse((String)"Should not be a debug favorite", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 0));
        LaunchFavoriteTests.assertFalse((String)"Should not be a run favorite", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 0));
    }

    public void testDeleteConfiguration() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfiguration configuration = this.getLaunchConfiguration();
        configuration.delete();
        LaunchFavoriteTests.assertFalse((String)"Should not be a debug favorite", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), configuration, 0));
        LaunchFavoriteTests.assertFalse((String)"Should not be a run favorite", (boolean)this.containsFavorite(this.getRunLaunchHistory(), configuration, 0));
    }

    public void testRenameFavorite() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfiguration original = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = original.getWorkingCopy();
        copy.rename("rename" + original.getName());
        ILaunchConfiguration saved = copy.doSave();
        LaunchFavoriteTests.assertTrue((String)"Missing from debug favorites", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 1));
        LaunchFavoriteTests.assertTrue((String)"Missing from run favorites", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 1));
        saved.delete();
    }

    public void testRenameBecomeFavorite() throws CoreException {
        ILaunchConfiguration original = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = original.getWorkingCopy();
        copy.rename("rename" + original.getName());
        this.addFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.debug");
        this.addFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = copy.doSave();
        LaunchFavoriteTests.assertTrue((String)"Missing from debug favorites", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 1));
        LaunchFavoriteTests.assertTrue((String)"Missing from run favorites", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 1));
        saved.delete();
    }

    public void testRenameUnFavorite() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfiguration original = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = original.getWorkingCopy();
        copy.rename("rename" + original.getName());
        this.removeFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.debug");
        this.removeFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = copy.doSave();
        LaunchFavoriteTests.assertFalse((String)"Should not be a debug favorite", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 0));
        LaunchFavoriteTests.assertFalse((String)"Should not be a run favorite", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 0));
        saved.delete();
    }
}

