/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.view.memory;

import junit.framework.TestCase;
import org.eclipe.debug.tests.view.memory.DynamicRenderingBindings;
import org.eclipe.debug.tests.view.memory.MemoryBlockDynamic;
import org.eclipe.debug.tests.view.memory.MemoryBlockOne;
import org.eclipe.debug.tests.view.memory.MemoryBlockThree;
import org.eclipe.debug.tests.view.memory.MemoryBlockTwo;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;

public class MemoryRenderingTests
extends TestCase {
    public MemoryRenderingTests(String name) {
        super(name);
    }

    public void testRenderingTypes() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        Object[] types = manager.getRenderingTypes();
        MemoryRenderingTests.assertTrue((String)"Wrong number of rendering types contributed", (types.length > 6 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type 1", (this.indexOf(manager.getRenderingType("rendering_type_1"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type 2", (this.indexOf(manager.getRenderingType("rendering_type_2"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type 3", (this.indexOf(manager.getRenderingType("rendering_type_3"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.raw_memory"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.ascii"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.signedint"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.unsignedint"), types) >= 0 ? 1 : 0) != 0);
    }

    public void testRenderingTypeNames() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        IMemoryRenderingType type = manager.getRenderingType("rendering_type_1");
        MemoryRenderingTests.assertEquals((String)"Wrong name", (String)"Rendering One", (String)type.getLabel());
        type = manager.getRenderingType("rendering_type_2");
        MemoryRenderingTests.assertEquals((String)"Wrong name", (String)"Rendering Two", (String)type.getLabel());
    }

    public void testSingleBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockOne block = new MemoryBlockOne();
        IMemoryRenderingType[] types = manager.getRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)1, (int)types.length);
        MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_1", (String)types[0].getId());
    }

    public void testDoubleBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockTwo block = new MemoryBlockTwo();
        Object[] types = manager.getRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)2, (int)types.length);
        MemoryRenderingTests.assertTrue((String)"Missing binding", (this.indexOf(manager.getRenderingType("rendering_type_1"), types) >= 0 ? 1 : 0) != 0);
        MemoryRenderingTests.assertTrue((String)"Missing binding", (this.indexOf(manager.getRenderingType("rendering_type_2"), types) >= 0 ? 1 : 0) != 0);
    }

    public void testDefaultBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockOne block = new MemoryBlockOne();
        IMemoryRenderingType[] types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)1, (int)types.length);
        MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_1", (String)types[0].getId());
    }

    public void testNoDefaultBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockTwo block = new MemoryBlockTwo();
        IMemoryRenderingType[] types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)0, (int)types.length);
    }

    public void testPrimaryBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockOne block = new MemoryBlockOne();
        IMemoryRenderingType type = manager.getPrimaryRenderingType((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_1", (String)type.getId());
    }

    public void testNoPrimaryBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockTwo block = new MemoryBlockTwo();
        IMemoryRenderingType type = manager.getPrimaryRenderingType((IMemoryBlock)block);
        MemoryRenderingTests.assertNull((String)"Wrong binding", (Object)type);
    }

    public void testDefaultWithoutPrimaryBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockThree block = new MemoryBlockThree();
        IMemoryRenderingType[] types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)1, (int)types.length);
        MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_3", (String)types[0].getId());
    }

    public void testDynamicBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockDynamic block = new MemoryBlockDynamic();
        IMemoryRenderingType[] types = manager.getRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)1, (int)types.length);
        MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_1", (String)types[0].getId());
        types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)1, (int)types.length);
        MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_1", (String)types[0].getId());
        IMemoryRenderingType type = manager.getPrimaryRenderingType((IMemoryBlock)block);
        MemoryRenderingTests.assertEquals((String)"Wrong bindings", (Object)manager.getRenderingType("rendering_type_1"), (Object)type);
    }

    public void testBindingChangeNotification() {
        final boolean[] changed = new boolean[1];
        IMemoryRenderingBindingsListener listener = new IMemoryRenderingBindingsListener(){

            public void memoryRenderingBindingsChanged() {
                changed[0] = true;
            }
        };
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockDynamic block = new MemoryBlockDynamic();
        IMemoryRenderingType[] types = manager.getRenderingTypes((IMemoryBlock)block);
        try {
            manager.addListener(listener);
            MemoryRenderingTests.assertFalse((String)"Renderings should not have changed yet", (boolean)changed[0]);
            DynamicRenderingBindings.setBinding("rendering_type_2");
            MemoryRenderingTests.assertTrue((String)"Renderings should have changed", (boolean)changed[0]);
            types = manager.getRenderingTypes((IMemoryBlock)block);
            MemoryRenderingTests.assertEquals((String)"Wrong number of bindings", (int)1, (int)types.length);
            MemoryRenderingTests.assertEquals((String)"Wrong binding", (String)"rendering_type_2", (String)types[0].getId());
        }
        finally {
            DynamicRenderingBindings.setBinding("rendering_type_1");
            manager.removeListener(listener);
        }
    }

    protected int indexOf(Object thing, Object[] list) {
        int i = 0;
        while (i < list.length) {
            Object object2 = list[i];
            if (object2.equals(thing)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

