/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class ContentTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public ContentTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, true, true);
        this.fShell.open();
    }

    protected abstract IInternalTreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    public void testSimpleSingleLevel() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        ContentTests.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 6));
    }

    public void testSimpleMultiLevel() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        ContentTests.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 3));
    }

    public void testLabelUpdatesCompletedOutOfSequence1() throws InterruptedException {
        TestModelWithCapturedUpdates model = new TestModelWithCapturedUpdates();
        model.fCaptureLabelUpdates = true;
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0])}));
        this.fViewer.setInput((Object)model.getRootElement());
        while (model.fCapturedUpdates.size() < model.getRootElement().fChildren.length) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        List<IViewerUpdate> firstUpdates = model.fCapturedUpdates;
        model.fCapturedUpdates = new ArrayList<IViewerUpdate>(2);
        model.getElement(model.findElement("1")).setLabelAppendix(" - changed");
        model.getElement(model.findElement("2")).setLabelAppendix(" - changed");
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (model.fCapturedUpdates.size() < model.getRootElement().fChildren.length) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        int i = 0;
        while (i < model.fCapturedUpdates.size()) {
            ((ILabelUpdate)model.fCapturedUpdates.get(i)).done();
            ++i;
        }
        i = 0;
        while (i < firstUpdates.size()) {
            ILabelUpdate capturedUpdate = (ILabelUpdate)firstUpdates.get(i);
            ContentTests.assertTrue((boolean)capturedUpdate.isCanceled());
            capturedUpdate.done();
            ++i;
        }
        while (!this.fListener.isFinished(32)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testLabelUpdatesCompletedOutOfSequence2() throws InterruptedException {
        TestModelWithCapturedUpdates model = new TestModelWithCapturedUpdates();
        model.fCaptureLabelUpdates = true;
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0])}));
        this.fViewer.setInput((Object)model.getRootElement());
        while (model.fCapturedUpdates.size() < model.getRootElement().fChildren.length) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        List<IViewerUpdate> firstUpdates = model.fCapturedUpdates;
        model.fCapturedUpdates = new ArrayList<IViewerUpdate>(2);
        model.setElementChildren(TreePath.EMPTY, new TestModel.TestElement[]{new TestModel.TestElement(model, "1-new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2-new", new TestModel.TestElement[0])});
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (model.fCapturedUpdates.size() < model.getRootElement().fChildren.length) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        int i = 0;
        while (i < model.fCapturedUpdates.size()) {
            ((ILabelUpdate)model.fCapturedUpdates.get(i)).done();
            ++i;
        }
        i = 0;
        while (i < firstUpdates.size()) {
            ILabelUpdate capturedUpdate = (ILabelUpdate)firstUpdates.get(i);
            ContentTests.assertTrue((boolean)capturedUpdate.isCanceled());
            capturedUpdate.done();
            ++i;
        }
        while (!this.fListener.isFinished(32)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void _x_testChildrenUpdatesCompletedOutOfSequence() throws InterruptedException {
        TestModelWithCapturedUpdates model = new TestModelWithCapturedUpdates();
        model.fCaptureChildrenUpdates = true;
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0])}));
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.areCapturedChildrenUpdatesComplete(model.fCapturedUpdates, model.getRootElement().fChildren.length)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        IChildrenUpdate[] firstUpdates = model.fCapturedUpdates.toArray(new IChildrenUpdate[0]);
        model.fCapturedUpdates.clear();
        model.setElementChildren(TreePath.EMPTY, new TestModel.TestElement[]{new TestModel.TestElement(model, "1-new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2-new", new TestModel.TestElement[0])});
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.areCapturedChildrenUpdatesComplete(model.fCapturedUpdates, model.getRootElement().fChildren.length)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        int i = 0;
        while (i < model.fCapturedUpdates.size()) {
            ((IChildrenUpdate)model.fCapturedUpdates.get(i)).done();
            ++i;
        }
        i = 0;
        while (i < firstUpdates.length) {
            firstUpdates[i].done();
            ++i;
        }
        while (!this.fListener.isFinished(32)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    private boolean areCapturedChildrenUpdatesComplete(List<IViewerUpdate> capturedUpdates, int childCount) {
        ArrayList<Integer> expectedChildren = new ArrayList<Integer>();
        int i = 0;
        while (i < childCount) {
            expectedChildren.add(new Integer(i));
            ++i;
        }
        IChildrenUpdate[] updates = capturedUpdates.toArray(new IChildrenUpdate[0]);
        int i2 = 0;
        while (i2 < updates.length) {
            int j = 0;
            while (j < updates[i2].getLength()) {
                expectedChildren.remove(new Integer(updates[i2].getOffset() + j));
                ++j;
            }
            ++i2;
        }
        return expectedChildren.isEmpty();
    }

    class TestModelWithCapturedUpdates
    extends TestModel {
        boolean fCaptureLabelUpdates = false;
        boolean fCaptureChildrenUpdates = false;
        List<IViewerUpdate> fCapturedUpdates = Collections.synchronizedList(new ArrayList());

        TestModelWithCapturedUpdates() {
        }

        @Override
        public void update(IChildrenUpdate[] updates) {
            int i = 0;
            while (i < updates.length) {
                TestModel.TestElement element = (TestModel.TestElement)((Object)updates[i].getElement());
                int endOffset = updates[i].getOffset() + updates[i].getLength();
                int j = updates[i].getOffset();
                while (j < endOffset) {
                    if (j < element.getChildren().length) {
                        updates[i].setChild((Object)element.getChildren()[j], j);
                    }
                    ++j;
                }
                if (this.fCaptureChildrenUpdates) {
                    this.fCapturedUpdates.add((IViewerUpdate)updates[i]);
                } else {
                    updates[i].done();
                }
                ++i;
            }
        }

        @Override
        public void update(ILabelUpdate[] updates) {
            int i = 0;
            while (i < updates.length) {
                TestModel.TestElement element = (TestModel.TestElement)((Object)updates[i].getElement());
                updates[i].setLabel(element.getLabel(), 0);
                if (updates[i] instanceof ICheckUpdate && Boolean.TRUE.equals(updates[i].getPresentationContext().getProperty("org.eclipse.debug.ui.check"))) {
                    ((ICheckUpdate)updates[i]).setChecked(element.getChecked(), element.getGrayed());
                }
                if (this.fCaptureLabelUpdates) {
                    this.fCapturedUpdates.add((IViewerUpdate)updates[i]);
                } else {
                    updates[i].done();
                }
                ++i;
            }
        }
    }
}

