/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class DeltaTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public DeltaTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, false, false);
        this.fShell.open();
    }

    protected abstract IInternalTreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    public void testUpdateLabel() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        TreePath elementPath = new TreePath(new Object[]{element});
        ModelDelta delta = model.appendElementLabel(elementPath, "-modified");
        this.fListener.reset(elementPath, element, -1, true, false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(8261)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testRefreshStruct() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        TreePath elementPath = new TreePath(new Object[]{element});
        TestModel.TestElement[] newChildren = new TestModel.TestElement[]{new TestModel.TestElement(model, "1.1 - new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.2 - new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.3 - new", new TestModel.TestElement[0])};
        ModelDelta delta = model.setElementChildren(elementPath, newChildren);
        this.fListener.reset(elementPath, element, -1, true, false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testRefreshStruct2() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        String prefix = "new - ";
        model.setElementChildren(TreePath.EMPTY, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(prefix) + "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "2", true, false, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(prefix) + "2.1", true, true, new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "2.2", false, true, new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "2.3", true, false, new TestModel.TestElement[0])}), new TestModel.TestElement(model, String.valueOf(prefix) + "3", new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(prefix) + "3.1", new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(prefix) + "3.1.1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "3.1.2", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "3.1.3", new TestModel.TestElement[0])}), new TestModel.TestElement(model, String.valueOf(prefix) + "3.2", new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(prefix) + "3.2.1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "3.2.2", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "3.2.3", new TestModel.TestElement[0])}), new TestModel.TestElement(model, String.valueOf(prefix) + "3.3", new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(prefix) + "3.3.1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "3.3.2", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(prefix) + "3.3.3", new TestModel.TestElement[0])})})});
        TestModel.TestElement element = model.getRootElement();
        this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testRefreshCoalesceStruct() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        TestModel.TestElement[] rootChildren = model.getRootElement().getChildren();
        int i = 0;
        while (i < rootChildren.length) {
            model.setElementChildren(new TreePath(new Object[]{rootChildren[i]}), new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(i) + ".1", new TestModel.TestElement[0])});
            ++i;
        }
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        DeltaTests.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 6));
    }

    public void testInsert() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = new TestModel.TestElement(model, "7", new TestModel.TestElement[0]);
        TreePath elementPath = new TreePath(new Object[]{element});
        ModelDelta delta = model.insertElementChild(TreePath.EMPTY, 6, element);
        this.fListener.reset();
        this.fListener.addChildreUpdate(TreePath.EMPTY, 6);
        this.fListener.addHasChildrenUpdate(elementPath);
        this.fListener.addLabelUpdate(elementPath);
        this.fListener.setFailOnRedundantUpdates(false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testInsertAndSelect() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element0 = new TestModel.TestElement(model, "00", new TestModel.TestElement[0]);
        TestModel.TestElement element1 = new TestModel.TestElement(model, "01", new TestModel.TestElement[0]);
        TreePath elementPath0 = new TreePath(new Object[]{element0});
        TreePath elementPath1 = new TreePath(new Object[]{element1});
        ModelDelta rootDelta = model.insertElementChild(TreePath.EMPTY, 0, element0);
        rootDelta = model.insertElementChild(rootDelta, TreePath.EMPTY, 1, element1);
        ModelDelta delta0 = rootDelta.getChildDelta((Object)element0);
        delta0.setFlags(delta0.getFlags() | 0x200000);
        this.fListener.reset();
        this.fListener.addHasChildrenUpdate(elementPath0);
        this.fListener.addHasChildrenUpdate(elementPath1);
        this.fListener.addLabelUpdate(elementPath0);
        this.fListener.addLabelUpdate(elementPath1);
        this.fListener.setFailOnRedundantUpdates(false);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testInsertAndRemove() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        IModelDelta removeDelta = model.removeElementChild(TreePath.EMPTY, 3).getChildDeltas()[0];
        TestModel.TestElement element = new TestModel.TestElement(model, "00", new TestModel.TestElement[0]);
        TreePath elementPath = new TreePath(new Object[]{element});
        IModelDelta insertDelta = model.insertElementChild(TreePath.EMPTY, 1, element).getChildDeltas()[0];
        ModelDelta combinedDelta = new ModelDelta((Object)model.getRootElement(), 0, 0, model.getRootElement().getChildren().length);
        combinedDelta.addNode(insertDelta.getElement(), insertDelta.getIndex(), insertDelta.getFlags(), insertDelta.getChildCount());
        combinedDelta.addNode(removeDelta.getElement(), removeDelta.getIndex(), removeDelta.getFlags(), removeDelta.getChildCount());
        this.fListener.reset();
        this.fListener.addHasChildrenUpdate(elementPath);
        this.fListener.addLabelUpdate(elementPath);
        this.fListener.setFailOnRedundantUpdates(false);
        model.postDelta((IModelDelta)combinedDelta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testAddElement() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = new TestModel.TestElement(model, "7", new TestModel.TestElement[0]);
        TreePath elementPath = new TreePath(new Object[]{element});
        ModelDelta delta = model.addElementChild(TreePath.EMPTY, null, 6, element);
        this.fListener.reset(elementPath, element, -1, true, false);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 6);
        this.fListener.setFailOnRedundantUpdates(false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void _x_testAddUnexpandedElement() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TreePath parentPath = model.findElement("1");
        ModelDelta rootDelta = model.addElementChild(parentPath, null, 0, new TestModel.TestElement(model, "1.1", new TestModel.TestElement[0]));
        model.addElementChild(parentPath, rootDelta, 1, new TestModel.TestElement(model, "1.2", new TestModel.TestElement[0]));
        model.addElementChild(parentPath, rootDelta, 2, new TestModel.TestElement(model, "1.3", new TestModel.TestElement[0]));
        model.addElementChild(parentPath, rootDelta, 3, new TestModel.TestElement(model, "1.4", new TestModel.TestElement[0]));
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished(66)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset();
        this.fListener.addUpdates((IInternalTreeModelViewer)this.fViewer, TreePath.EMPTY, model.getRootElement(), -1, 12479);
        rootDelta = new ModelDelta((Object)model.getRootElement(), 1024);
        model.getElementDelta(rootDelta, model.findElement("1.1"), true).setFlags(1024);
        model.getElementDelta(rootDelta, model.findElement("1.2"), true).setFlags(1024);
        model.getElementDelta(rootDelta, model.findElement("1.3"), true).setFlags(1024);
        model.getElementDelta(rootDelta, model.findElement("1.4"), true).setFlags(1024);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(parentPath, model.getElement(parentPath), 1, false, true);
        ((IInternalTreeModelViewer)this.fViewer).expandToLevel((Object)parentPath, 1);
        while (this.fListener.isFinished(131072) && !this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, parentPath);
    }

    public void _x_testRefreshUnexpandedElementsChildren() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TreePath parentPath = model.findElement("2");
        this.fListener.reset(parentPath, model.getElement(parentPath), 1, false, true);
        ((IInternalTreeModelViewer)this.fViewer).expandToLevel((Object)parentPath, 1);
        while (this.fListener.isFinished(131072) && !this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ((IInternalTreeModelViewer)this.fViewer).setExpandedState((Object)parentPath, false);
        this.fListener.reset();
        this.fListener.addUpdates((IInternalTreeModelViewer)this.fViewer, TreePath.EMPTY, model.getRootElement(), -1, 12479);
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 1024);
        model.getElementDelta(rootDelta, model.findElement("2.1"), true).setFlags(1024);
        model.getElementDelta(rootDelta, model.findElement("2.2"), true).setFlags(1024);
        model.getElementDelta(rootDelta, model.findElement("2.3"), true).setFlags(1024);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(parentPath, model.getElement(parentPath), 1, false, true);
        ((IInternalTreeModelViewer)this.fViewer).expandToLevel((Object)parentPath, 1);
        while (this.fListener.isFinished(131072) && !this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, parentPath, true);
    }

    public void testRemove() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        ModelDelta delta = model.removeElementChild(TreePath.EMPTY, 5);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testExpandAndSelect() throws InterruptedException {
        ModelDelta delta;
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        TestModel.TestElement element = model.getRootElement();
        TreePath path_root = TreePath.EMPTY;
        ModelDelta deltaRoot = delta = new ModelDelta((Object)model.getRootElement(), -1, 0x100000, element.getChildren().length);
        element = element.getChildren()[2];
        TreePath path_root_3 = path_root.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 2, 0x100000, element.fChildren.length);
        this.fListener.addChildreUpdate(path_root_3, 0);
        TreePath path_root_3_1 = path_root_3.createChildPath((Object)element.getChildren()[0]);
        this.fListener.addHasChildrenUpdate(path_root_3_1);
        this.fListener.addLabelUpdate(path_root_3_1);
        TreePath path_root_3_3 = path_root_3.createChildPath((Object)element.getChildren()[2]);
        this.fListener.addHasChildrenUpdate(path_root_3_3);
        this.fListener.addLabelUpdate(path_root_3_3);
        this.fListener.addChildreUpdate(path_root_3, 2);
        element = element.getChildren()[1];
        TreePath path_root_3_2 = path_root_3.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 1, 0x100000, element.fChildren.length);
        this.fListener.addLabelUpdate(path_root_3_2);
        TreePath path_root_3_2_1 = path_root_3_2.createChildPath((Object)element.getChildren()[0]);
        this.fListener.addHasChildrenUpdate(path_root_3_2_1);
        this.fListener.addLabelUpdate(path_root_3_2_1);
        TreePath path_root_3_2_3 = path_root_3_2.createChildPath((Object)element.getChildren()[2]);
        this.fListener.addHasChildrenUpdate(path_root_3_2_3);
        this.fListener.addLabelUpdate(path_root_3_2_3);
        this.fListener.addChildreUpdate(path_root_3_2, 0);
        this.fListener.addChildreUpdate(path_root_3_2, 2);
        element = element.getChildren()[1];
        TreePath path_root_3_2_2 = path_root_3_2.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 1, 0x200000, element.fChildren.length);
        this.fListener.addLabelUpdate(path_root_3_2_2);
        this.fListener.addHasChildrenUpdate(path_root_3_2_2);
        IInternalTreeModelViewer contentProviderViewer = (IInternalTreeModelViewer)this.fViewer;
        DeltaTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3));
        DeltaTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3_2));
        DeltaTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3_2_2));
        model.postDelta((IModelDelta)deltaRoot);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        DeltaTests.assertTrue((boolean)contentProviderViewer.getExpandedState((Object)path_root_3));
        DeltaTests.assertTrue((boolean)contentProviderViewer.getExpandedState((Object)path_root_3_2));
        DeltaTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3_2_2));
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof ITreeSelection) {
            List<TreePath> selectionPathsList = Arrays.asList(((ITreeSelection)selection).getPaths());
            DeltaTests.assertTrue((boolean)selectionPathsList.contains(path_root_3_2_2));
        } else {
            DeltaTests.fail((String)"Not a tree selection");
        }
    }

    public void testExpandAndSelect_simple() throws InterruptedException {
        ModelDelta delta;
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        TestModel.TestElement element = model.getRootElement();
        TreePath path_root = TreePath.EMPTY;
        ModelDelta deltaRoot = delta = new ModelDelta((Object)model.getRootElement(), -1, 0x100000, element.getChildren().length);
        element = element.getChildren()[2];
        TreePath path_root_3 = path_root.createChildPath((Object)element);
        delta.addNode((Object)element, 2, 0x300000, element.fChildren.length);
        IInternalTreeModelViewer contentProviderViewer = (IInternalTreeModelViewer)this.fViewer;
        DeltaTests.assertFalse((boolean)contentProviderViewer.getExpandedState((Object)path_root_3));
        model.postDelta((IModelDelta)deltaRoot);
        while (!this.fListener.isFinished(64) || !this.fListener.isFinished(3)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        DeltaTests.assertTrue((boolean)contentProviderViewer.getExpandedState((Object)path_root_3));
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof ITreeSelection) {
            List<TreePath> selectionPathsList = Arrays.asList(((ITreeSelection)selection).getPaths());
            DeltaTests.assertTrue((boolean)selectionPathsList.contains(path_root_3));
        } else {
            DeltaTests.fail((String)"Not a tree selection");
        }
    }

    public void testCompositeModelRefreshStruct() throws InterruptedException {
        TestModel model = TestModel.compositeMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        TreePath m4_2_1Path = model.findElement("m4.2.1");
        TestModel.TestElement m4_2_1 = model.getElement(m4_2_1Path);
        TestModel m4 = m4_2_1.getModel();
        TestModel.TestElement[] newChildren = new TestModel.TestElement[]{new TestModel.TestElement(m4, "4.2.1.new-1", new TestModel.TestElement[0]), new TestModel.TestElement(m4, "4.2.1.new-2", new TestModel.TestElement[0]), new TestModel.TestElement(m4, "4.2.1.new-3", new TestModel.TestElement[0])};
        ModelDelta delta = m4.setElementChildren(m4_2_1Path, newChildren);
        this.fListener.reset(m4_2_1Path, m4_2_1, -1, true, false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testCompositeModelAddElement() throws InterruptedException {
        TestModel model = TestModel.compositeMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        TreePath m3_1Path = model.findElement("m3.1");
        TestModel.TestElement m3_1 = model.getElement(m3_1Path);
        TestModel m3 = m3_1.getModel();
        TestModel.TestElement m3_1_new = new TestModel.TestElement(m3, "m3.1-new", new TestModel.TestElement[0]);
        TreePath m3_1_newPath = m3_1Path.createChildPath((Object)m3_1_new);
        ModelDelta delta = m3.addElementChild(m3_1Path, null, 0, m3_1_new);
        this.fListener.reset(m3_1_newPath, m3_1_new, -1, true, false);
        this.fListener.addChildreUpdate(m3_1Path, 0);
        this.fListener.setFailOnRedundantUpdates(false);
        m3.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testBug292322() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        TreePath parentPath = model.findElement("2");
        TestModel.TestElement parentElement = model.getElement(parentPath);
        ModelDelta delta = model.removeElementChild(parentPath, 0);
        this.fListener.reset(parentPath, parentElement, 0, false, false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(4218)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        model.removeElementChild(parentPath, 0);
        this.fListener.reset(parentPath, parentElement, 0, false, false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(4218)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        model.removeElementChild(parentPath, 0);
        this.fListener.reset(parentPath, parentElement, 0, false, false);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(4218)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
    }
}

