/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import junit.framework.TestCase;
import org.eclipse.debug.internal.ui.viewers.model.FilterTransform;
import org.eclipse.jface.viewers.TreePath;

public class FilterTransformTests
extends TestCase {
    public Object root;
    public Object element0;
    public Object element1;
    public Object element2;
    public Object element3;
    public Object element4;
    public Object element5;
    public Object element6;
    public Object element7;
    public FilterTransform transform;

    public FilterTransformTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.transform = new FilterTransform();
        this.root = new Object();
        this.element0 = new Object();
        this.element1 = new Object();
        this.element2 = new Object();
        this.element3 = new Object();
        this.element4 = new Object();
        this.element5 = new Object();
        this.element6 = new Object();
        this.element7 = new Object();
        FilterTransformTests.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 0, this.element0));
        FilterTransformTests.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 2, this.element2));
        FilterTransformTests.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 3, this.element3));
        FilterTransformTests.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 6, this.element6));
        FilterTransformTests.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 7, this.element7));
    }

    protected boolean equals(int[] a, int[] b) {
        if (a.length == b.length) {
            int i = 0;
            while (i < b.length) {
                if (a[i] != b[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void testRemoveMiddleElementFromFilters() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        this.transform.removeElementFromFilters(TreePath.EMPTY, this.element3);
        FilterTransformTests.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 5;
        nArray[3] = 6;
        FilterTransformTests.assertTrue((String)"Wrong filter state", (boolean)this.equals(this.transform.getFilteredChildren(TreePath.EMPTY), nArray));
    }

    public void testRemoveFirstElementFromFilters() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        this.transform.removeElementFromFilters(TreePath.EMPTY, this.element0);
        FilterTransformTests.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        FilterTransformTests.assertTrue((String)"Wrong filter state", (boolean)this.equals(this.transform.getFilteredChildren(TreePath.EMPTY), new int[]{1, 2, 5, 6}));
    }

    public void testRemoveLastFromFilters() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        this.transform.removeElementFromFilters(TreePath.EMPTY, this.element7);
        FilterTransformTests.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 6;
        FilterTransformTests.assertTrue((String)"Wrong filter state", (boolean)this.equals(this.transform.getFilteredChildren(TreePath.EMPTY), nArray));
    }

    public void testClearMiddleElementFromFilters() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        this.transform.clear(TreePath.EMPTY, 3);
        FilterTransformTests.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 6;
        nArray[3] = 7;
        FilterTransformTests.assertTrue((String)"Wrong filter state", (boolean)this.equals(this.transform.getFilteredChildren(TreePath.EMPTY), nArray));
    }

    public void testClearFirstElementFromFilters() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        this.transform.clear(TreePath.EMPTY, 0);
        FilterTransformTests.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        FilterTransformTests.assertTrue((String)"Wrong filter state", (boolean)this.equals(this.transform.getFilteredChildren(TreePath.EMPTY), new int[]{2, 3, 6, 7}));
    }

    public void testClearLastFromFilters() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        this.transform.clear(TreePath.EMPTY, 7);
        FilterTransformTests.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 6;
        FilterTransformTests.assertTrue((String)"Wrong filter state", (boolean)this.equals(this.transform.getFilteredChildren(TreePath.EMPTY), nArray));
    }

    public void testViewToModelCount() {
        FilterTransformTests.assertEquals((String)"Wrong model count", (int)8, (int)this.transform.viewToModelCount(TreePath.EMPTY, 3));
    }

    public void testViewToModelIndex() {
        FilterTransformTests.assertEquals((String)"Wrong model index", (int)1, (int)this.transform.viewToModelIndex(TreePath.EMPTY, 0));
        FilterTransformTests.assertEquals((String)"Wrong model index", (int)4, (int)this.transform.viewToModelIndex(TreePath.EMPTY, 1));
        FilterTransformTests.assertEquals((String)"Wrong model index", (int)5, (int)this.transform.viewToModelIndex(TreePath.EMPTY, 2));
    }

    public void testAddAlreadyFiltered() {
        FilterTransformTests.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        boolean added = this.transform.addFilteredIndex(TreePath.EMPTY, 0, this.element0);
        FilterTransformTests.assertFalse((String)"Filter should not be added - should already have been there", (boolean)added);
    }

    public void testRegression200325() {
        this.transform.setModelChildCount(TreePath.EMPTY, 2);
        try {
            this.transform.addFilteredIndex(TreePath.EMPTY, 3, new Object());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            FilterTransformTests.fail((String)"AIOOBE Exception should not be thrown here, setModelChildCount should leave FilterTransform$Node in a consistent state");
        }
    }
}

