/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipe.debug.tests.viewer.model.VisibleVirtualItemValidator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.ui.PlatformUI;

public abstract class PerformanceTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;
    protected VisibleVirtualItemValidator fVirtualItemValidator;

    public PerformanceTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fVirtualItemValidator = new VisibleVirtualItemValidator(0, Integer.MAX_VALUE);
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, false, false);
        this.fShell.open();
    }

    protected abstract IInternalTreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    protected abstract int getTestModelDepth();

    public void testRefreshStruct() throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements(model, this.getTestModelDepth(), "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            int i = 0;
            while (i < 10) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                while (!this.fListener.isFinished(12543)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    public void testRefreshStruct2() throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements2(model, new int[]{2, 3000, 1}, "model."));
        this.fViewer.setAutoExpandLevel(2);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fVirtualItemValidator.setVisibleRange(0, 50);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset();
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                while (!this.fListener.isFinished(64)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                while (!this.fListener.isFinished(12543)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    public void testRefreshStructReplaceElements() throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements(model, this.getTestModelDepth(), "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            int i = 0;
            while (i < 100) {
                model.setElementChildren(TreePath.EMPTY, TestModel.makeMultiLevelElements(model, this.getTestModelDepth(), "pass " + i + "."));
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                while (!this.fListener.isFinished(12543)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    public void testRefreshList() throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        int numElements = (int)Math.pow(2.0, this.getTestModelDepth());
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, numElements, "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                while (!this.fListener.isFinished(12543)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    public void testSaveAndRestore() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3.2.3")));
        this.fViewer.setAutoExpandLevel(-1);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                this.fListener.reset(true, false);
                meter.start();
                this.fViewer.setInput(null);
                while (!this.fListener.isFinished(256)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
                this.fViewer.setInput((Object)model.getRootElement());
                while (!this.fListener.isFinished(12991)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    public void testRefreshListFiltered() throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        int numElements = (int)Math.pow(2.0, this.getTestModelDepth());
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, numElements, "model."));
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TestModel.TestElement) {
                    String id = ((TestModel.TestElement)((Object)element)).getID();
                    if (id.startsWith("model.")) {
                        id = id.substring("model.".length());
                    }
                    if (id.length() >= 2 && (id.charAt(1) == '1' || id.charAt(1) == '3' || id.charAt(1) == '5' || id.charAt(1) == '7' || id.charAt(1) == '9')) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
        try {
            int i = 0;
            while (i < 100) {
                model.setAllAppendix(" - pass " + i);
                TestModel.TestElement element = model.getRootElement();
                this.fListener.reset(TreePath.EMPTY, element, -1, false, false);
                meter.start();
                model.postDelta((IModelDelta)new ModelDelta((Object)element, 1024));
                while (!this.fListener.isFinished(12543)) {
                    if (this.fDisplay.readAndDispatch()) continue;
                    Thread.sleep(0L);
                }
                meter.stop();
                System.gc();
                ++i;
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }
}

