/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.statushandlers;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.tests.statushandlers.StatusHandler;

public class StatusHandlerTests
extends TestCase {
    public static final IStatus STATUS = new Status(4, "org.eclipse.debug.tests", 333, "", null);

    public void testStatusHandlerExtension() {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(STATUS);
        StatusHandlerTests.assertNotNull((String)"missing status handler extension", (Object)handler);
        StatusHandlerTests.assertTrue((String)"Unexpected handler", (boolean)(handler instanceof StatusHandler));
    }

    public void testDisableStatusHandlers() {
        try {
            Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, (boolean)false, (IScopeContext)InstanceScope.INSTANCE);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(STATUS);
            StatusHandlerTests.assertNull((String)"status handler extension should be disabled", (Object)handler);
        }
        finally {
            Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, (boolean)true, (IScopeContext)InstanceScope.INSTANCE);
        }
    }
}

