/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.launching;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipe.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.tests.TestsPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class LaunchConfigurationTests
extends AbstractLaunchTest
implements ILaunchConfigurationListener {
    public static final String ID_TEST_LAUNCH_TYPE = "org.eclipse.debug.tests.launch.type";
    protected ILaunchConfiguration fFrom;
    protected ILaunchConfiguration fTo;
    protected Object fLock = new Object();
    protected ILaunchConfiguration fAdded;
    protected ILaunchConfiguration fRemoved;

    public static char[] getInputStreamAsCharArray(InputStream stream) throws IOException {
        Charset charset = null;
        try {
            charset = Charset.forName("UTF-8");
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : UTF-8");
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : UTF-8");
            return null;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] contents = LaunchConfigurationTests.getInputStreamAsByteArray(stream, -1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(contents.length);
        byteBuffer.put(contents);
        byteBuffer.flip();
        return charsetDecoder.decode(byteBuffer).array();
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public LaunchConfigurationTests(String name) {
        super(name);
    }

    protected IProject getProject() throws CoreException {
        return TestsPlugin.createProject("LaunchConfigurationTests");
    }

    protected ILaunchConfigurationWorkingCopy newConfiguration(IContainer container, String name) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(ID_TEST_LAUNCH_TYPE);
        LaunchConfigurationTests.assertTrue((String)"Should support debug mode", (boolean)type.supportsMode("debug"));
        LaunchConfigurationTests.assertTrue((String)"Should support run mode", (boolean)type.supportsMode("run"));
        ILaunchConfigurationWorkingCopy wc = type.newInstance(container, name);
        wc.setAttribute("String1", "String1");
        wc.setAttribute("Int1", 1);
        wc.setAttribute("Boolean1", true);
        wc.setAttribute("Boolean2", false);
        LaunchConfigurationTests.assertTrue((String)"Should need saving", (boolean)wc.isDirty());
        return wc;
    }

    protected ILaunchConfigurationWorkingCopy newEmptyConfiguration(IContainer container, String name) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(ID_TEST_LAUNCH_TYPE);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(container, name);
        LaunchConfigurationTests.assertEquals((String)"Should have no attributes", (int)0, (int)wc.getAttributes().size());
        return wc;
    }

    protected boolean existsIn(ILaunchConfiguration[] configs, ILaunchConfiguration config) {
        int i = 0;
        while (i < configs.length) {
            if (configs[i].equals(config)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void testCreateLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertEquals((String)"String1 should be String1", (String)handle.getAttribute("String1", "Missing"), (String)"String1");
        LaunchConfigurationTests.assertEquals((String)"Int1 should be 1", (int)handle.getAttribute("Int1", 0), (int)1);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testLocalName() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "localName");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertEquals((String)"Wrong name", (String)handle.getName(), (String)"localName");
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testSharedName() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "sharedName");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertEquals((String)"Wrong name", (String)handle.getName(), (String)"sharedName");
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testGetAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Map attributes = handle.getAttributes();
        LaunchConfigurationTests.assertEquals((String)"String1 should be String1", (Object)"String1", attributes.get("String1"));
        LaunchConfigurationTests.assertEquals((String)"Int1 should be 1", (Object)new Integer(1), attributes.get("Int1"));
        LaunchConfigurationTests.assertEquals((String)"Boolean1 should be true", (Object)true, attributes.get("Boolean1"));
        LaunchConfigurationTests.assertEquals((String)"Boolean2 should be false", (Object)false, attributes.get("Boolean2"));
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testSetAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ATTR1", "ONE");
        map.put("ATTR2", "TWO");
        wc.setAttributes(map);
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Map attributes = handle.getAttributes();
        LaunchConfigurationTests.assertEquals((String)"should have two attributes", (int)2, (int)attributes.size());
        LaunchConfigurationTests.assertEquals((String)"ATTR1 should be ONE", (Object)"ONE", attributes.get("ATTR1"));
        LaunchConfigurationTests.assertEquals((String)"ATTR2 should be TWO", (Object)"TWO", attributes.get("ATTR2"));
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testSetNullAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        wc.setAttributes(null);
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Map attributes = handle.getAttributes();
        LaunchConfigurationTests.assertEquals((String)"should have no attributes", (int)0, (int)attributes.size());
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testLocalCopy() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "configToCopy");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        ILaunchConfigurationWorkingCopy softCopy = handle.copy("CopyOf" + handle.getName());
        LaunchConfigurationTests.assertNull((String)"Original in copy should be null", (Object)softCopy.getOriginal());
        ILaunchConfiguration hardCopy = softCopy.doSave();
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)hardCopy.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (hardCopy.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)hardCopy.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!hardCopy.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Original should still exist", (boolean)handle.exists());
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
        hardCopy.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!hardCopy.exists() ? 1 : 0) != 0);
    }

    public void testDoubleSave() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "configDoubleSave");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        String name = wc.getName();
        wc.rename("newName");
        wc.rename(name);
        LaunchConfigurationTests.assertTrue((String)"Should be dirty", (boolean)wc.isDirty());
        wc.doSave();
        ILaunchConfiguration[] newConfigs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Should be the same number of configs", (newConfigs.length == configs.length ? 1 : 0) != 0);
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testDeleteLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config2delete");
        ILaunchConfiguration handle = wc.doSave();
        File file = wc.getLocation().toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should not exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
    }

    public void testRenameLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config2rename");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.rename("config-2-rename");
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        LaunchConfigurationTests.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        LaunchConfigurationTests.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        LaunchConfigurationTests.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        LaunchConfigurationTests.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    public void testMoveLocalToSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config2share");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.setContainer((IContainer)this.getProject());
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        LaunchConfigurationTests.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        LaunchConfigurationTests.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        LaunchConfigurationTests.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        LaunchConfigurationTests.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    public void testMoveSharedToLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "config2local");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.setContainer(null);
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        LaunchConfigurationTests.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        LaunchConfigurationTests.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        LaunchConfigurationTests.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        LaunchConfigurationTests.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    public void testCreateSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "config2");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testSharedCopy() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "config2Copy");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        ILaunchConfigurationWorkingCopy softCopy = handle.copy("CopyOf" + handle.getName());
        ILaunchConfiguration hardCopy = softCopy.doSave();
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)hardCopy.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (hardCopy.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)hardCopy.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!hardCopy.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Original should still exist", (boolean)handle.exists());
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
        hardCopy.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!hardCopy.exists() ? 1 : 0) != 0);
    }

    public void testDeleteSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "shared2delete");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should not exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
    }

    public void testRenameSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "shared2rename");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.rename("shared-2-rename");
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        LaunchConfigurationTests.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        LaunchConfigurationTests.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        LaunchConfigurationTests.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        LaunchConfigurationTests.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    protected void closeAllEditors() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        activeWorkbenchWindow.getActivePage().closeAllEditors(false);
    }

    public void testPersistIndex() throws CoreException {
        this.closeAllEditors();
        ILaunchConfigurationWorkingCopy wc1 = this.newConfiguration(null, "persist1local");
        ILaunchConfigurationWorkingCopy wc2 = this.newConfiguration((IContainer)this.getProject(), "persist2shared");
        ILaunchConfiguration lc1 = wc1.doSave();
        ILaunchConfiguration lc2 = wc2.doSave();
        IProject project = this.getProject();
        ILaunchConfiguration[] before = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"config should be in index", (boolean)this.existsIn(before, lc1));
        LaunchConfigurationTests.assertTrue((String)"config should be in index", (boolean)this.existsIn(before, lc2));
        project.close(null);
        ILaunchConfiguration[] during = this.getLaunchManager().getLaunchConfigurations();
        boolean local = true;
        int i = 0;
        while (i < during.length) {
            local = local && (during[i].isLocal() || !during[i].getFile().getProject().equals((Object)project));
            ++i;
        }
        project.open(null);
        LaunchConfigurationTests.assertTrue((String)"Should only be local configs when closed", (boolean)local);
        ILaunchConfiguration[] after = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Should be same number of configs after openning", (after.length == before.length ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < before.length) {
            LaunchConfigurationTests.assertTrue((String)"Config should exist after openning", (boolean)this.existsIn(after, before[i2]));
            ++i2;
        }
        lc1.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!lc1.exists() ? 1 : 0) != 0);
        lc2.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!lc2.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.fFrom = this.getLaunchManager().getMovedFrom(configuration);
        Object object = this.fLock;
        synchronized (object) {
            this.fAdded = configuration;
            this.fLock.notifyAll();
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.fTo = this.getLaunchManager().getMovedTo(configuration);
        Object object = this.fLock;
        synchronized (object) {
            this.fRemoved = configuration;
            this.fLock.notifyAll();
        }
    }

    protected void addConfigListener() {
        this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    protected void removeConfigListener() {
        this.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectWithSharedConfig() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("DeleteSharedConfig");
        try {
            LaunchConfigurationTests.assertFalse((String)"project should not exist yet", (boolean)project.exists());
            project.create(null);
            LaunchConfigurationTests.assertTrue((String)"project should now exist", (boolean)project.exists());
            project.open(null);
            LaunchConfigurationTests.assertTrue((String)"project should be open", (boolean)project.isOpen());
            ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)project, "ToBeDeleted");
            this.addConfigListener();
            ILaunchConfiguration configuration = wc.doSave();
            LaunchConfigurationTests.assertEquals((Object)configuration, (Object)this.fAdded);
            Object object = this.fLock;
            synchronized (object) {
                this.fRemoved = null;
                project.delete(true, false, null);
                if (this.fRemoved == null) {
                    this.fLock.wait(10000L);
                }
            }
            LaunchConfigurationTests.assertEquals((Object)configuration, (Object)this.fRemoved);
        }
        finally {
            if (project.exists()) {
                project.delete(true, false, null);
            }
            this.removeConfigListener();
        }
    }

    public void testNestedWorkingCopyLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config123");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        LaunchConfigurationTests.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        LaunchConfigurationTests.assertEquals((String)"String1 should be String1", (String)handle.getAttribute("String1", "Missing"), (String)"String1");
        LaunchConfigurationTests.assertEquals((String)"Int1 should be 1", (int)handle.getAttribute("Int1", 0), (int)1);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        wc = handle.getWorkingCopy();
        ILaunchConfigurationWorkingCopy nested = wc.getWorkingCopy();
        LaunchConfigurationTests.assertEquals((String)"String1 should be String1", (String)nested.getAttribute("String1", "Missing"), (String)"String1");
        LaunchConfigurationTests.assertEquals((String)"Int1 should be 1", (int)nested.getAttribute("Int1", 0), (int)1);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)nested.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!nested.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        nested.setAttribute("String1", "StringOne");
        LaunchConfigurationTests.assertEquals((String)"Wrong attribute value", (String)nested.getAttribute("String1", "Missing"), (String)"StringOne");
        LaunchConfigurationTests.assertEquals((String)"Wrong attribute value", (String)wc.getAttribute("String1", "Missing"), (String)"String1");
        LaunchConfigurationTests.assertEquals((String)"Wrong attribute value", (String)handle.getAttribute("String1", "Missing"), (String)"String1");
        ILaunchConfigurationWorkingCopy parent = nested.getParent();
        LaunchConfigurationTests.assertEquals((String)"Wrong parent", (Object)wc, (Object)parent);
        LaunchConfigurationTests.assertNull((String)"Should have no parent", (Object)wc.getParent());
        nested.doSave();
        LaunchConfigurationTests.assertEquals((String)"Wrong attribute value", (String)wc.getAttribute("String1", "Missing"), (String)"StringOne");
        LaunchConfigurationTests.assertEquals((String)"Wrong attribute value", (String)handle.getAttribute("String1", "Missing"), (String)"String1");
        LaunchConfigurationTests.assertEquals((String)"Wrong original config", (Object)handle, (Object)wc.getOriginal());
        LaunchConfigurationTests.assertEquals((String)"Wrong original config", (Object)handle, (Object)nested.getOriginal());
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testCreateDeleteEFS() throws CoreException, URISyntaxException {
        IFileSystem fileSystem = EFS.getFileSystem((String)"debug");
        LaunchConfigurationTests.assertNotNull((String)"Missing debug EFS", (Object)fileSystem);
        IFolder folder = this.getProject().getFolder("efs");
        folder.createLink(new URI("debug", Path.ROOT.toString(), null), 0, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)folder, "efsConfig");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        handle.delete();
        LaunchConfigurationTests.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
        folder.delete(0, null);
    }

    public void testCreateDeleteEFSLink() throws CoreException, URISyntaxException {
        IFileSystem fileSystem = EFS.getFileSystem((String)"debug");
        LaunchConfigurationTests.assertNotNull((String)"Missing debug EFS", (Object)fileSystem);
        IFolder folder = this.getProject().getFolder("efs2");
        folder.createLink(new URI("debug", Path.ROOT.toString(), null), 0, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)folder, "efsConfig");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        folder.delete(0, null);
        LaunchConfigurationTests.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testEFSProjectRename() throws Exception {
        IProject pro = ResourcesPlugin.getWorkspace().getRoot().getProject("RenameEFS");
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        IProject project = TestsPlugin.createProject("RenameEFS");
        IFileSystem fileSystem = EFS.getFileSystem((String)"debug");
        LaunchConfigurationTests.assertNotNull((String)"Missing debug EFS", (Object)fileSystem);
        IFolder folder = project.getFolder("efs2");
        folder.createLink(new URI("debug", Path.ROOT.toString(), null), 0, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)folder, "efsConfig");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        IProjectDescription description = project.getDescription();
        description.setName("SFEemaneR");
        project.move(description, 32, null);
        LaunchConfigurationTests.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("SFEemaneR");
        LaunchConfigurationTests.assertTrue((String)"Project should exist", (boolean)project.exists());
        IFile file = project.getFile((IPath)new Path("efs2/efsConfig.launch"));
        LaunchConfigurationTests.assertTrue((String)"launch config file should exist", (boolean)file.exists());
        handle = this.getLaunchManager().getLaunchConfiguration(file);
        LaunchConfigurationTests.assertTrue((String)"launch config should exist", (boolean)handle.exists());
        LaunchConfigurationTests.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        LaunchConfigurationTests.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        LaunchConfigurationTests.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        LaunchConfigurationTests.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        LaunchConfigurationTests.assertEquals((String)"Shared location should be updated", (Object)file, (Object)handle.getFile());
        project.delete(0, null);
        LaunchConfigurationTests.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
    }

    public void testImport() throws Exception {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "Import4");
        ILaunchConfiguration handle = wc.doSave();
        LaunchConfigurationTests.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        File dir = TestsPlugin.getDefault().getFileInPlugin((IPath)new Path("test-import"));
        LaunchConfigurationTests.assertTrue((String)"Import directory does not exist", (boolean)dir.exists());
        LaunchManager manager = (LaunchManager)this.getLaunchManager();
        Listener listener = new Listener();
        try {
            this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)listener);
            manager.importConfigurations(dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith("launch");
                }
            }), null);
            List<ILaunchConfiguration> removed = listener.getRemoved();
            LaunchConfigurationTests.assertEquals((String)"Should be one removed config", (int)1, (int)removed.size());
            LaunchConfigurationTests.assertTrue((String)"Import4 should be removed", (boolean)removed.contains(handle));
            List<ILaunchConfiguration> added = listener.getAdded();
            LaunchConfigurationTests.assertEquals((String)"Should be 5 added configs", (int)5, (int)added.size());
            HashSet<String> names = new HashSet<String>();
            for (ILaunchConfiguration lc : added) {
                names.add(lc.getName());
            }
            LaunchConfigurationTests.assertTrue((String)"Missing Name", (boolean)names.contains("Import1"));
            LaunchConfigurationTests.assertTrue((String)"Missing Name", (boolean)names.contains("Import2"));
            LaunchConfigurationTests.assertTrue((String)"Missing Name", (boolean)names.contains("Import3"));
            LaunchConfigurationTests.assertTrue((String)"Missing Name", (boolean)names.contains("Import4"));
            LaunchConfigurationTests.assertTrue((String)"Missing Name", (boolean)names.contains("Import5"));
            List<ILaunchConfiguration> changed = listener.getChanged();
            LaunchConfigurationTests.assertEquals((String)"Should be 1 changed config", (int)1, (int)changed.size());
            LaunchConfigurationTests.assertEquals((String)"Wrong changed config", (String)"Import4", (String)changed.get(0).getName());
        }
        finally {
            manager.removeLaunchConfigurationListener((ILaunchConfigurationListener)listener);
        }
    }

    public void testWorkingCopyGetLocation() throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "test-get-location");
        IPath location = workingCopy.getLocation();
        LaunchConfigurationTests.assertEquals((String)"Wrong path for local working copy", (Object)LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH.append("test-get-location.launch"), (Object)location);
    }

    public void testLaunchTimeStamp() throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "test-time-stamp");
        ILaunch launch = workingCopy.launch("debug", null);
        try {
            String stamp = launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
            LaunchConfigurationTests.assertNotNull((String)"missing time stamp", (Object)stamp);
            Long.parseLong(stamp);
        }
        finally {
            if (launch != null) {
                this.getLaunchManager().removeLaunch(launch);
            }
        }
    }

    public void testMapAttributePersistence() throws CoreException, IOException {
        ILaunchConfigurationWorkingCopy c1 = this.newEmptyConfiguration((IContainer)this.getProject(), "testMapAttributes1");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Z", "z-value");
        map.put("Y", "y-value");
        map.put("X", "x-value");
        map.put("W", "w-value");
        map.put("V", "v-value");
        map.put("U", "u-value");
        map.put("T", "t-value");
        map.put("S", "s-value");
        map.put("R", "r-value");
        map.put("Q", "q-value");
        map.put("P", "p-value");
        map.put("O", "o-value");
        map.put("N", "n-value");
        map.put("M", "m-value");
        map.put("L", "l-value");
        map.put("K", "k-value");
        map.put("J", "j-value");
        map.put("I", "i-value");
        map.put("H", "h-value");
        map.put("G", "g-value");
        map.put("F", "f-value");
        map.put("E", "e-value");
        map.put("D", "d-value");
        map.put("C", "c-value");
        map.put("B", "b-value");
        map.put("A", "a-value");
        c1.setAttribute("Map-Attribute", map);
        c1.doSave();
        ILaunchConfigurationWorkingCopy c2 = this.newEmptyConfiguration((IContainer)this.getProject(), "testMapAttributes2");
        map = new HashMap();
        map.put("A", "a-value");
        map.put("Z", "z-value");
        map.put("B", "b-value");
        map.put("Y", "y-value");
        map.put("C", "c-value");
        map.put("X", "x-value");
        map.put("D", "d-value");
        map.put("W", "w-value");
        map.put("E", "e-value");
        map.put("V", "v-value");
        map.put("F", "f-value");
        map.put("U", "u-value");
        map.put("G", "g-value");
        map.put("T", "t-value");
        map.put("H", "h-value");
        map.put("S", "s-value");
        map.put("I", "i-value");
        map.put("R", "r-value");
        map.put("J", "j-value");
        map.put("Q", "q-value");
        map.put("K", "k-value");
        map.put("P", "p-value");
        map.put("L", "l-value");
        map.put("M", "m-value");
        map.put("O", "o-value");
        map.put("N", "n-value");
        c2.setAttribute("Map-Attribute", map);
        c2.doSave();
        char[] chars1 = LaunchConfigurationTests.getInputStreamAsCharArray(c1.getFile().getContents());
        char[] chars2 = LaunchConfigurationTests.getInputStreamAsCharArray(c2.getFile().getContents());
        LaunchConfigurationTests.assertEquals((String)"Should be the same characters", (int)chars1.length, (int)chars2.length);
        int i = 0;
        while (i < chars2.length) {
            LaunchConfigurationTests.assertEquals((String)"Should be the same character", (char)chars1[i], (char)chars2[i]);
            ++i;
        }
    }

    public void testSetAttributePersistence() throws CoreException, IOException {
        ILaunchConfigurationWorkingCopy c1 = this.newEmptyConfiguration((IContainer)this.getProject(), "testSetAttributes1");
        HashSet<String> set = new HashSet<String>();
        set.add("z-value");
        set.add("y-value");
        set.add("x-value");
        set.add("w-value");
        set.add("v-value");
        set.add("u-value");
        set.add("t-value");
        set.add("s-value");
        set.add("r-value");
        set.add("q-value");
        set.add("p-value");
        set.add("o-value");
        set.add("n-value");
        set.add("m-value");
        set.add("l-value");
        set.add("k-value");
        set.add("j-value");
        set.add("i-value");
        set.add("h-value");
        set.add("g-value");
        set.add("f-value");
        set.add("e-value");
        set.add("d-value");
        set.add("c-value");
        set.add("b-value");
        set.add("a-value");
        c1.setAttribute("Set-Attribute", set);
        c1.doSave();
        ILaunchConfigurationWorkingCopy c2 = this.newEmptyConfiguration((IContainer)this.getProject(), "testSetAttributes2");
        set = new HashSet();
        set.add("a-value");
        set.add("z-value");
        set.add("b-value");
        set.add("y-value");
        set.add("c-value");
        set.add("x-value");
        set.add("d-value");
        set.add("w-value");
        set.add("e-value");
        set.add("v-value");
        set.add("f-value");
        set.add("u-value");
        set.add("g-value");
        set.add("t-value");
        set.add("h-value");
        set.add("s-value");
        set.add("i-value");
        set.add("r-value");
        set.add("j-value");
        set.add("q-value");
        set.add("k-value");
        set.add("p-value");
        set.add("l-value");
        set.add("m-value");
        set.add("o-value");
        set.add("n-value");
        c2.setAttribute("Set-Attribute", set);
        c2.doSave();
        char[] chars1 = LaunchConfigurationTests.getInputStreamAsCharArray(c1.getFile().getContents());
        char[] chars2 = LaunchConfigurationTests.getInputStreamAsCharArray(c2.getFile().getContents());
        LaunchConfigurationTests.assertEquals((String)"Should be the same characters", (int)chars1.length, (int)chars2.length);
        int i = 0;
        while (i < chars2.length) {
            LaunchConfigurationTests.assertEquals((String)"Should be the same character", (char)chars1[i], (char)chars2[i]);
            ++i;
        }
    }

    public void testIllegalFileSepCharName() {
        try {
            this.newConfiguration(null, new Path("some").append("nested").append("config").toOSString());
        }
        catch (CoreException coreException) {
            return;
        }
        LaunchConfigurationTests.assertTrue((String)"Should be an illegal argument - cannot nest local configurations", (boolean)false);
    }

    public void testLegalFileSepCharName() {
        try {
            this.newConfiguration((IContainer)this.getProject(), new Path("some").append("nested").append("config").toOSString());
        }
        catch (CoreException coreException) {
            LaunchConfigurationTests.assertTrue((String)"Should *not* be an illegal argument - can nest shared cofigurations", (boolean)false);
        }
    }

    public void testIllegalCharName() {
        try {
            this.newConfiguration((IContainer)this.getProject(), "<config>");
        }
        catch (CoreException coreException) {
            return;
        }
        LaunchConfigurationTests.assertTrue((String)"Should be an illegal argument - illegal character used in name", (boolean)false);
    }

    public void testRenameAndMoveShared() throws CoreException {
        IProject project = this.getProject();
        IFolder f1 = project.getFolder("f1");
        IFolder f2 = project.getFolder("f2");
        f1.create(false, true, null);
        f2.create(false, true, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)f1, "start-here");
        ILaunchConfiguration orig = wc.doSave();
        wc = orig.getWorkingCopy();
        wc.setContainer((IContainer)f2);
        wc.rename("end-here");
        ILaunchConfiguration next = wc.doSave();
        LaunchConfigurationTests.assertFalse((String)"Original should not exist", (boolean)orig.exists());
        LaunchConfigurationTests.assertTrue((String)"Renamed and moved config should exist", (boolean)next.exists());
    }

    public void testGetTypeImageFromURI() throws Exception {
        ImageDescriptor descriptor = DebugUITools.getImageDescriptor((String)"org.eclipse.debug.tests.launch.type1");
        LaunchConfigurationTests.assertNotNull((String)"The image descriptior type.image.1 must exist", (Object)descriptor);
        LaunchConfigurationTests.assertNotSame((String)"The image descriptor is not type.image.1", (Object)ImageDescriptor.getMissingImageDescriptor(), (Object)descriptor);
    }

    public void testGetTyeImage() throws Exception {
        ImageDescriptor descriptor = DebugUITools.getImageDescriptor((String)ID_TEST_LAUNCH_TYPE);
        LaunchConfigurationTests.assertNotNull((String)"The image descriptior type.image.2 must exist", (Object)descriptor);
        LaunchConfigurationTests.assertNotSame((String)"The image descriptor is not type.image.2", (Object)ImageDescriptor.getMissingImageDescriptor(), (Object)descriptor);
    }

    public void testGetProjectMappedResource1() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            LaunchConfigurationTests.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("test.project", new Integer(4))});
            IResource[] res = wc.getMappedResources();
            LaunchConfigurationTests.assertNotNull((String)"There should be mapped resources", (Object)res);
            LaunchConfigurationTests.assertTrue((String)"There should be one project", (res.length == 1 ? 1 : 0) != 0);
        }
        finally {
            lc.delete();
        }
    }

    public void testGetProjectMappedResource2() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            LaunchConfigurationTests.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("test/project", new Integer(4))});
            IResource[] res = wc.getMappedResources();
            LaunchConfigurationTests.assertNull((String)"There should be no mapped resources", (Object)res);
        }
        finally {
            lc.delete();
        }
    }

    public void testGetProjectMappedResource3() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            LaunchConfigurationTests.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("test\\project", new Integer(4))});
            IResource[] res = wc.getMappedResources();
            if ("win32".equals(Platform.getOS())) {
                LaunchConfigurationTests.assertNull((String)"There should be no mapped resources", (Object)res);
            } else {
                LaunchConfigurationTests.assertNotNull((String)"There should be mapped resources", (Object)res);
            }
        }
        finally {
            lc.delete();
        }
    }

    public void testGetProjectMappedResource4() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            LaunchConfigurationTests.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("/project", new Integer(4))});
            IResource[] res = wc.getMappedResources();
            LaunchConfigurationTests.assertNotNull((String)"There should be mapped resources", (Object)res);
        }
        finally {
            lc.delete();
        }
    }

    public void testNullLaunchConfigurationInLaunch() throws Exception {
        Launch l = new Launch(null, "run", null);
        LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
        Bundle b = Platform.getBundle((String)"org.eclipse.ui.externaltools");
        LaunchConfigurationTests.assertNotNull((String)"Must have found the external tools bundle", (Object)b);
        if (b.getState() != 32) {
            b.start();
        }
        lm.addLaunch((ILaunch)l);
    }

    protected void setResourceMappings(ILaunchConfigurationWorkingCopy config, ResourceItem[] resources) {
        ArrayList<String> paths = null;
        ArrayList<String> types = null;
        int size = resources.length;
        if (resources != null && size > 0) {
            paths = new ArrayList<String>(size);
            types = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                paths.add(resources[i].path);
                types.add(resources[i].type.toString());
                ++i;
            }
        }
        config.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, paths);
        config.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, types);
    }

    class Listener
    implements ILaunchConfigurationListener {
        private final List<ILaunchConfiguration> addedList = new ArrayList<ILaunchConfiguration>();
        private final List<ILaunchConfiguration> removedList = new ArrayList<ILaunchConfiguration>();
        private final List<ILaunchConfiguration> changedList = new ArrayList<ILaunchConfiguration>();

        Listener() {
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            this.addedList.add(configuration);
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            this.changedList.add(configuration);
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            this.removedList.add(configuration);
        }

        public List<ILaunchConfiguration> getAdded() {
            return this.addedList;
        }

        public List<ILaunchConfiguration> getChanged() {
            return this.changedList;
        }

        public List<ILaunchConfiguration> getRemoved() {
            return this.removedList;
        }
    }

    class ResourceItem {
        String path;
        Integer type;

        public ResourceItem(String path, Integer type) {
            this.path = path;
            this.type = type;
        }
    }
}

