/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.launching;

import org.eclipe.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchManager;

public class LaunchManagerTests
extends AbstractLaunchTest {
    public LaunchManagerTests(String name) {
        super(name);
    }

    public void testGenereateConfigName() {
        String configname = "launch_configuration";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertTrue((String)("the name nust be '" + configname + "'"), (boolean)name.equals(configname));
    }

    public void testGenereateConfigNameBadChar() {
        String configname = "config:name";
        String name = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configname);
        LaunchManagerTests.assertEquals((String)("config name should be '" + configname + "'"), (String)configname, (String)name);
    }

    public void testGenerateValidName() {
        String configname = "thisisavalidname";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"Should be the same as the seed", (String)configname, (String)name);
    }

    public void testGenerateConfigNameReservedName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "aux";
            String name = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'aux'", (String)configname, (String)name);
        }
    }

    public void testGenerateBadConfigName() {
        String configname = "config:name";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"config name should be 'config_name'", (String)"config_name", (String)name);
    }

    public void testGenerateConflictingName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "aux";
            String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'launch_configuration'", (String)"launch_configuration", (String)name);
        }
    }

    public void testGenerateBadCharConflict() throws Exception {
        String configname = "config:name";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"config name should be 'config_name'", (String)"config_name", (String)name);
        this.getLaunchConfiguration(name);
        name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"config name should be 'config_name (1)'", (String)"config_name (1)", (String)name);
        ILaunchConfiguration config = this.getLaunchConfiguration("config_name");
        config.delete();
    }

    public void testGenerateBadNameConflict() throws Exception {
        if ("win32".equals(Platform.getOS())) {
            String configname = "com2";
            String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'launch_configuration'", (String)"launch_configuration", (String)name);
            this.getLaunchConfiguration(name);
            name = this.getLaunchManager().generateLaunchConfigurationName(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'launch_configuration (1)'", (String)"launch_configuration (1)", (String)name);
            ILaunchConfiguration config = this.getLaunchConfiguration("launch_configuration");
            config.delete();
        }
    }

    public void testValidateConfigGoodName() {
        String configname = "configname";
        try {
            this.getLaunchManager().isValidLaunchConfigurationName(configname);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LaunchManagerTests.fail((String)"the config name should not have thrown an exception during validation");
        }
    }

    public void testValidateConfigBadCharName() {
        String configname = "config:name";
        try {
            this.getLaunchManager().isValidLaunchConfigurationName(configname);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        LaunchManagerTests.fail((String)"the config name should have thrown an exception during validation");
    }

    public void testValidateConfigBadName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "com1";
            try {
                this.getLaunchManager().isValidLaunchConfigurationName(configname);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            LaunchManagerTests.fail((String)"the config name should have thrown an exception during validation");
        }
    }

    public void testGenerateNameExistingConfig() throws Exception {
        String configname = "x.y.z.configname";
        this.getLaunchConfiguration(configname);
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)("the configuration name should have been " + configname + " (1)"), (String)(String.valueOf(configname) + " (1)"), (String)name);
        this.getLaunchConfiguration(name);
        name = this.getLaunchManager().generateLaunchConfigurationName(name);
        LaunchManagerTests.assertEquals((String)("the configuration name should have been " + configname + " (2)"), (String)(String.valueOf(configname) + " (2)"), (String)name);
        ILaunchConfiguration config = this.getLaunchConfiguration(configname);
        if (config != null) {
            config.delete();
        }
        if ((config = this.getLaunchConfiguration(String.valueOf(configname) + " (1)")) != null) {
            config.delete();
        }
    }

    public void testRemoveAcc() {
        String text = "&Remove";
        String label = LaunchManager.removeAccelerators((String)text);
        LaunchManagerTests.assertEquals((String)"the label should be 'Remove'", (String)"Remove", (String)label);
        text = "Remo&ve";
        label = LaunchManager.removeAccelerators((String)text);
        LaunchManagerTests.assertEquals((String)"the label should be 'Remove'", (String)"Remove", (String)label);
    }
}

