/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.StateTests;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewerFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class FilterTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public FilterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, true, true);
        this.fShell.open();
    }

    protected abstract IInternalTreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    protected IInternalTreeModelViewer getInternalViewer() {
        return (IInternalTreeModelViewer)this.fViewer;
    }

    public void testSimpleSingleLevel() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestViewerFilter("2")});
    }

    public void testSimpleSingleLevelWithTMVFilter() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestTMVFilter("2", (Object)model.getRootElement())});
    }

    public void testSimpleSingleLevelWithMixedFilters() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestTMVFilter("2", (Object)model.getRootElement()), new TestViewerFilter("1")});
    }

    public void testSimpleMultiLevel() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestViewerFilter(".1"), new TestViewerFilter(".2")});
    }

    public void testSimpleMultiLevelWithTMVFilter() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestTMVFilter(".1", null), new TestTMVFilter(".2", null)});
    }

    public void testSimpleMultiLevelWithMixedFilters() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestViewerFilter(".1"), new TestTMVFilter(".2", null)});
    }

    private void doTestSimpleLevel(TestModel model, ViewerFilter[] filters) throws InterruptedException {
        this.fViewer.setAutoExpandLevel(-1);
        this.fViewer.setFilters(filters);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), filters, -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, false, filters);
    }

    public void testLargeSingleLevel() throws InterruptedException {
        this.doTestLargeSingleLevel(new ViewerFilter[]{new TestViewerFilter("2")});
    }

    public void testLargeSingleLevelWithTMVFilter() throws InterruptedException {
        this.doTestLargeSingleLevel(new ViewerFilter[]{new TestTMVFilter("2", null)});
    }

    private void doTestLargeSingleLevel(ViewerFilter[] filters) throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, 3000, "model."));
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testReplacedUnrealizedFilteredElement() throws InterruptedException {
        this.doTestReplacedUnrealizedFilteredElement(new ViewerFilter[]{new TestViewerFilter("2")});
    }

    public void testReplacedUnrealizedFilteredElementWithTMVFilter() throws InterruptedException {
        this.doTestReplacedUnrealizedFilteredElement(new ViewerFilter[]{new TestTMVFilter("2", null)});
    }

    private void doTestReplacedUnrealizedFilteredElement(ViewerFilter[] filters) throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, 300, "model."));
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TestModel.TestElement replacedElement = new TestModel.TestElement(model, "replaced element", new TestModel.TestElement[0]);
        ModelDelta replaceDelta = model.replaceElementChild(TreePath.EMPTY, 200, replacedElement);
        this.fListener.reset();
        model.postDelta((IModelDelta)replaceDelta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset();
        ((IInternalTreeModelViewer)this.fViewer).reveal(TreePath.EMPTY, 150);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TreePath[] replacedElementPaths = this.fViewer.getElementPaths((Object)replacedElement);
        FilterTests.assertTrue((replacedElementPaths.length != 0 ? 1 : 0) != 0);
    }

    public void testRefreshUnrealizedFilteredElement() throws InterruptedException {
        this.doTestRefreshUnrealizedFilteredElement(new ViewerFilter[]{new TestViewerFilter("2")});
    }

    public void testRefreshUnrealizedFilteredElementWithTMVFilter() throws InterruptedException {
        this.doTestRefreshUnrealizedFilteredElement(new ViewerFilter[]{new TestTMVFilter("2", null)});
    }

    private void doTestRefreshUnrealizedFilteredElement(ViewerFilter[] filters) throws InterruptedException {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, 300, "model."));
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TestModel.TestElement replacedElement = new TestModel.TestElement(model, "replaced element", new TestModel.TestElement[0]);
        model.replaceElementChild(TreePath.EMPTY, 200, replacedElement);
        this.fListener.reset();
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset();
        ((IInternalTreeModelViewer)this.fViewer).reveal(TreePath.EMPTY, 150);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TreePath[] replacedElementPaths = this.fViewer.getElementPaths((Object)replacedElement);
        FilterTests.assertTrue((replacedElementPaths.length != 0 ? 1 : 0) != 0);
    }

    public void testRefreshToUnfilterElements() throws InterruptedException {
        this.doTestRefreshToUnfilterElements(new ViewerFilter[]{new TestViewerFilter(".1"), new TestViewerFilter(".2")});
    }

    public void testRefreshToUnfilterElementsWithTMVFilter() throws InterruptedException {
        this.doTestRefreshToUnfilterElements(new ViewerFilter[]{new TestTMVFilter(".1", null), new TestTMVFilter(".2", null)});
    }

    public void testRefreshToUnfilterElementsWithMixedFilters() throws InterruptedException {
        this.doTestRefreshToUnfilterElements(new ViewerFilter[]{new TestViewerFilter(".1"), new TestTMVFilter(".2", null)});
    }

    private void doTestRefreshToUnfilterElements(ViewerFilter[] filters) throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setAutoExpandLevel(-1);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        filters = new ViewerFilter[]{};
        this.fViewer.setFilters(filters);
        this.fListener.reset();
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, false, filters);
    }

    public void testPreserveExpandedOnMultLevelContent() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(new TreePath[]{model.findElement("5"), model.findElement("5.1"), model.findElement("6")});
        this.fViewer.setSelection((ISelection)originalSelection);
        FilterTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        ViewerFilter[] filters = new ViewerFilter[]{new TestViewerFilter("^1$")};
        this.fViewer.setFilters(filters);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), filters, -1, 12479);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true, filters);
        FilterTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        FilterTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        FilterTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        FilterTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        FilterTests.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 6));
        filters = new ViewerFilter[]{};
        this.fViewer.setFilters(filters);
        this.fListener.reset();
        this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), filters, -1, 12479);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true, filters);
        FilterTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        FilterTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        FilterTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        FilterTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        FilterTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    class TestTMVFilter
    extends TreeModelViewerFilter {
        Pattern fPattern;
        Object fParentElement;

        TestTMVFilter(String pattern, Object parentElement) {
            this.fPattern = Pattern.compile(pattern);
            this.fParentElement = parentElement;
        }

        public boolean isApplicable(ITreeModelViewer viewer, Object parentElement) {
            if (this.fParentElement != null) {
                return this.fParentElement.equals(parentElement);
            }
            return true;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TestModel.TestElement) {
                TestModel.TestElement te = (TestModel.TestElement)((Object)element);
                return !this.fPattern.matcher(te.getLabel()).find();
            }
            return true;
        }
    }

    class TestViewerFilter
    extends ViewerFilter {
        Pattern fPattern;

        TestViewerFilter(String pattern) {
            this.fPattern = Pattern.compile(pattern);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TestModel.TestElement) {
                TestModel.TestElement te = (TestModel.TestElement)((Object)element);
                return !this.fPattern.matcher(te.getLabel()).find();
            }
            return true;
        }
    }
}

