/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipe.debug.tests.viewer.model.TreeModelViewerAutopopulateAgent;
import org.eclipe.debug.tests.viewer.model.TreePathWrapper;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JFaceViewerTopIndexTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    TreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public JFaceViewerTopIndexTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setSize(300, 80);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener((ITreeModelViewer)this.fViewer, false, false);
        this.fShell.open();
    }

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    protected IInternalTreeModelViewer getCTargetViewer() {
        return this.fViewer;
    }

    protected TreeModelViewer createViewer(Display display, Shell shell) {
        return new TreeModelViewer((Composite)this.fShell, 0x10000002, (IPresentationContext)new PresentationContext("TestViewer"));
    }

    public void testRestoreTopIndex() throws InterruptedException {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[8];
        int i = 0;
        while (i < elements.length) {
            String text = Integer.toString(i + 1);
            elements[i] = new TestModel.TestElement(model, text, new TestModel.TestElement[0]);
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        autopopulateAgent.dispose();
        int indexRevealElem = 4;
        this.getCTargetViewer().reveal(TreePath.EMPTY, indexRevealElem);
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates(this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(1280)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRestoreTopAndExpand() throws InterruptedException {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[10];
        int i = 0;
        while (i < elements.length) {
            String text = Integer.toString(i + 1);
            elements[i] = i == 0 ? new TestModel.TestElement(model, text, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(text) + ".1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(text) + ".2", new TestModel.TestElement[0])}) : new TestModel.TestElement(model, text, new TestModel.TestElement[0]);
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        int indexFirstElem = 0;
        TestModel.TestElement firstElem = elements[indexFirstElem];
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta delta = model.getBaseDelta(rootDelta);
        TreePath firstElemPath = model.findElement(firstElem.getLabel());
        this.fListener.addUpdates(firstElemPath, firstElem, 1, 48);
        delta.addNode((Object)firstElem, indexFirstElem, 0x100000, firstElem.getChildren().length);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished(66)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        JFaceViewerTopIndexTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)firstElemPath));
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, 1);
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates(this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRestoreTopTriggersExpand() throws InterruptedException {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[10];
        int i = 0;
        while (i < elements.length) {
            String text = Integer.toString(i + 1);
            elements[i] = i == elements.length - 1 ? new TestModel.TestElement(model, text, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(text) + ".1", new TestModel.TestElement[0]), new TestModel.TestElement(model, String.valueOf(text) + ".2", new TestModel.TestElement[0])}) : new TestModel.TestElement(model, text, new TestModel.TestElement[0]);
            ++i;
        }
        this.fViewer.setAutoExpandLevel(-1);
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        int indexLastElem = elements.length - 1;
        TestModel.TestElement lastElem = elements[indexLastElem];
        TreePath lastElemePath = model.findElement(lastElem.getLabel());
        JFaceViewerTopIndexTests.assertTrue((boolean)this.getCTargetViewer().getExpandedState((Object)lastElemePath));
        this.fViewer.setAutoExpandLevel(0);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, indexLastElem - 1);
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates(this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(1280)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }

    public void testRestoreRevealAfterRevealCancel() throws InterruptedException {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, 2);
        while (this.fDisplay.readAndDispatch()) {
        }
        this.fListener.reset();
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            Thread.sleep(0L);
        }
        this.fListener.reset();
        TreePath elementPath = model.findElement("3");
        this.fListener.addUpdates((IInternalTreeModelViewer)this.fViewer, elementPath, model.getElement(elementPath), 1, 1024);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(1088)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta revealDelta = model.makeElementDelta(model.findElement("2.1"), 0x1000000);
        this.fListener.reset();
        model.postDelta((IModelDelta)revealDelta);
        while (!this.fListener.isFinished(66)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset();
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            Thread.sleep(0L);
        }
        autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(512)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        autopopulateAgent.dispose();
    }

    public void testRestoreRevealAfterRevealCancel2() throws InterruptedException {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(TreePath.EMPTY, 2);
        while (this.fDisplay.readAndDispatch()) {
        }
        this.fListener.reset();
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            Thread.sleep(0L);
        }
        this.fListener.reset();
        TreePath elementPath = model.findElement("2");
        this.fListener.addUpdates((IInternalTreeModelViewer)this.fViewer, elementPath, model.getElement(elementPath), 1, 1060);
        elementPath = model.findElement("3");
        this.fListener.addUpdates((IInternalTreeModelViewer)this.fViewer, elementPath, model.getElement(elementPath), 0, 1024);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(1024)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TreePath pathToBeRevealed = model.findElement("2.1");
        ModelDelta revealDelta = model.makeElementDelta(pathToBeRevealed, 0x1000000);
        revealDelta.accept(new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                ((ModelDelta)delta).setFlags(delta.getFlags() | 0x100000);
                return true;
            }
        });
        model.postDelta((IModelDelta)revealDelta);
        while (!this.fListener.isFinished(100)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(pathToBeRevealed, topPath);
    }

    public void testRestoreDeepTreeAndReveal() throws InterruptedException {
        TreeModelViewerAutopopulateAgent autopopulateAgent = new TreeModelViewerAutopopulateAgent(this.fViewer);
        TestModel model = TestModel.simpleDeepMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        autopopulateAgent.dispose();
        this.getCTargetViewer().reveal(model.findElement("3.6.3.16.16.16.16.16"), 1);
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath originalTopPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)originalTopPath);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates(this.getCTargetViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getCTargetViewer(), originalTopPath, (TestModel.TestElement)((Object)originalTopPath.getLastSegment()), 0, 1024);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(1026)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        while (this.fDisplay.readAndDispatch()) {
        }
        TreePath topPath = this.getCTargetViewer().getTopElementPath();
        JFaceViewerTopIndexTests.assertNotNull((String)"Top item should not be null!", (Object)topPath);
        TreePathWrapper.assertEqual(originalTopPath, topPath);
    }
}

