/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class SelectionTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public SelectionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, false, false);
        this.fShell.open();
    }

    protected abstract ITreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    private TestModel makeMultiLevelModel() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        return model;
    }

    public void testSimpleSetSelection() throws InterruptedException {
        TestModel model = this.makeMultiLevelModel();
        SelectionListener listener = new SelectionListener();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        TreeSelection selection = new TreeSelection(model.findElement("3.3.3"));
        this.fViewer.setSelection((ISelection)selection, true, false);
        SelectionTests.assertTrue((listener.fEvents.size() == 1 ? 1 : 0) != 0);
        ISelection viewerSelection = this.fViewer.getSelection();
        SelectionTests.assertEquals((Object)selection, (Object)viewerSelection);
    }

    public void testSelectionPolicy() throws InterruptedException {
        TestModel model = this.makeMultiLevelModel();
        TreeSelection selection_3_3_3 = new TreeSelection(model.findElement("3.3.3"));
        this.fViewer.setSelection((ISelection)selection_3_3_3, true, false);
        SelectionTests.assertEquals((Object)selection_3_3_3, (Object)this.fViewer.getSelection());
        model.setSelectionPolicy(new IModelSelectionPolicy(){

            public ISelection replaceInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
                return null;
            }

            public boolean overrides(ISelection existing, ISelection candidate, IPresentationContext context) {
                return false;
            }

            public boolean isSticky(ISelection selection, IPresentationContext context) {
                return true;
            }

            public boolean contains(ISelection selection, IPresentationContext context) {
                return true;
            }
        });
        TreeSelection selection_3_3_1 = new TreeSelection(model.findElement("3.3.1"));
        this.fViewer.setSelection((ISelection)selection_3_3_1, true, false);
        SelectionTests.assertEquals((Object)selection_3_3_3, (Object)this.fViewer.getSelection());
        this.fViewer.setSelection((ISelection)selection_3_3_1, true, true);
        SelectionTests.assertEquals((Object)selection_3_3_1, (Object)this.fViewer.getSelection());
        TreePath path_3_3_3 = model.findElement("3.3.3");
        ModelDelta baseDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta delta_3_3_3 = model.getElementDelta(baseDelta, path_3_3_3, false);
        delta_3_3_3.setFlags(0x200000);
        this.fViewer.updateViewer((IModelDelta)baseDelta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        SelectionTests.assertEquals((Object)selection_3_3_1, (Object)this.fViewer.getSelection());
        delta_3_3_3.setFlags(0x4200000);
        this.fViewer.updateViewer((IModelDelta)baseDelta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        SelectionTests.assertEquals((Object)selection_3_3_3, (Object)this.fViewer.getSelection());
    }

    public void testSelectRemove() throws InterruptedException {
        TestModel model = this.makeMultiLevelModel();
        TreePath elementPath = model.findElement("3.3.3");
        TreeSelection selection = new TreeSelection(elementPath);
        this.fViewer.setSelection((ISelection)selection, true, false);
        TreePath removePath = model.findElement("3");
        TreePath parentPath = removePath.getParentPath();
        int removeIndex = model.getElement(parentPath).indexOf(model.getElement(removePath));
        ModelDelta delta = model.removeElementChild(removePath.getParentPath(), removeIndex);
        SelectionListener listener = new SelectionListener();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ISelection viewerSelection = this.fViewer.getSelection();
        SelectionTests.assertTrue((boolean)viewerSelection.isEmpty());
    }

    public void testSelectRemoveRefreshStruct() throws InterruptedException {
        TestModel model = this.makeMultiLevelModel();
        TreePath elementPath = model.findElement("3.3.3");
        TreeSelection selection = new TreeSelection(elementPath);
        this.fViewer.setSelection((ISelection)selection, true, false);
        TreePath removePath = model.findElement("3");
        TreePath parentPath = removePath.getParentPath();
        int removeIndex = model.getElement(parentPath).indexOf(model.getElement(removePath));
        model.removeElementChild(removePath.getParentPath(), removeIndex);
        SelectionListener listener = new SelectionListener();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ISelection viewerSelection = this.fViewer.getSelection();
        SelectionTests.assertTrue((boolean)viewerSelection.isEmpty());
    }

    private static class SelectionListener
    implements ISelectionChangedListener {
        private final List<SelectionChangedEvent> fEvents = new ArrayList<SelectionChangedEvent>(1);

        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fEvents.add(event);
        }
    }
}

