/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class StateTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public StateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, false, false);
        this.fShell.open();
    }

    protected abstract ITreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception, InterruptedException {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    protected IInternalTreeModelViewer getInternalViewer() {
        return (IInternalTreeModelViewer)this.fViewer;
    }

    public void testUpdateViewer() throws InterruptedException {
        ModelDelta delta;
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset();
        this.fListener.addChildreUpdate(TreePath.EMPTY, 0);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 1);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 2);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        TestModel.TestElement element = model.getRootElement();
        TreePath path0 = TreePath.EMPTY;
        ModelDelta updateDelta = delta = new ModelDelta((Object)model.getRootElement(), -1, 0x100000, element.getChildren().length);
        element = element.getChildren()[2];
        TreePath path1 = path0.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 2, 0x100000, element.fChildren.length);
        element = element.getChildren()[1];
        TreePath path2 = path1.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 1, 0x100000, element.fChildren.length);
        element = element.getChildren()[1];
        TreePath path3 = path2.createChildPath((Object)element);
        delta = delta.addNode((Object)element, 1, 0x200000);
        this.fListener.reset(false, false);
        this.fListener.addChildreUpdate(path0, 2);
        this.fListener.addHasChildrenUpdate(path1);
        this.fListener.addChildreCountUpdate(path1);
        this.fListener.addLabelUpdate(path1);
        this.fListener.addChildreUpdate(path1, 1);
        this.fListener.addHasChildrenUpdate(path2);
        this.fListener.addChildreCountUpdate(path2);
        this.fListener.addLabelUpdate(path2);
        this.fListener.addHasChildrenUpdate(path2);
        this.fListener.addChildreCountUpdate(path2);
        this.fListener.addChildreUpdate(path2, 1);
        this.fListener.addHasChildrenUpdate(path3);
        this.fListener.addLabelUpdate(path3);
        this.fViewer.updateViewer((IModelDelta)updateDelta);
        while (!this.fListener.isFinished(6)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta savedDelta = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(path0, savedDelta, 0x300000);
        if (!this.deltaMatches(updateDelta, savedDelta)) {
            StateTests.fail((String)("Expected:\n" + updateDelta.toString() + "\nGot:\n" + savedDelta));
        }
    }

    boolean deltaMatches(ModelDelta requested, ModelDelta received) {
        if (requested.getElement().equals(received.getElement()) && requested.getFlags() == received.getFlags() && (requested.getChildCount() == -1 || requested.getChildCount() == received.getChildCount()) && (requested.getIndex() == -1 || requested.getIndex() == received.getIndex()) && (requested.getReplacementElement() != null && requested.getReplacementElement().equals(received.getReplacementElement()) || requested.getReplacementElement() == null && received.getReplacementElement() == null) && requested.getChildDeltas().length == received.getChildDeltas().length) {
            int i = 0;
            while (i < requested.getChildDeltas().length) {
                ModelDelta requestedChildDelta = (ModelDelta)requested.getChildDeltas()[i];
                ModelDelta receivedChildDelta = received.getChildDelta(requestedChildDelta.getElement());
                if (receivedChildDelta == null || !this.deltaMatches(requestedChildDelta, receivedChildDelta)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static TestModel alternatingSubsreesModel(int size) {
        TestModel model = new TestModel();
        TestModel.TestElement[] elements = new TestModel.TestElement[size];
        int i = 0;
        while (i < size) {
            String text = Integer.toString(i + 1);
            elements[i] = new TestModel.TestElement(model, text, new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(text) + ".1", new TestModel.TestElement[]{new TestModel.TestElement(model, String.valueOf(text) + ".1.1", new TestModel.TestElement[0])})});
            ++i;
        }
        model.setRoot(new TestModel.TestElement(model, "root", elements));
        return model;
    }

    static boolean areTreeSelectionsEqual(ITreeSelection sel1, ITreeSelection sel2) {
        HashSet<TreePath> sel1Set = new HashSet<TreePath>();
        sel1Set.addAll(Arrays.asList(sel1.getPaths()));
        HashSet<TreePath> sel2Set = new HashSet<TreePath>();
        sel2Set.addAll(Arrays.asList(sel2.getPaths()));
        return sel1Set.equals(sel2Set);
    }

    static void expandAlternateElements(TestModelUpdatesListener listener, TestModel model, boolean waitForAllUpdates) throws InterruptedException {
        listener.reset();
        listener.setFailOnRedundantUpdates(false);
        TestModel.TestElement rootElement = model.getRootElement();
        TestModel.TestElement[] children = rootElement.getChildren();
        ModelDelta rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta expandDelta = model.getBaseDelta(rootDelta);
        int i = 0;
        while (i < children.length) {
            if (i % 2 != 1) {
                TestModel.TestElement element = children[i];
                ModelDelta delta = expandDelta;
                int index = i;
                while (element.getChildren().length != 0) {
                    TreePath elementPath = model.findElement(element.getLabel());
                    listener.addUpdates(elementPath, element, 1, 0x10 | (waitForAllUpdates ? 32 : 0));
                    delta = delta.addNode((Object)element, index, 0x100000, element.getChildren().length);
                    element = element.getChildren()[0];
                    index = 0;
                }
            }
            ++i;
        }
        model.postDelta((IModelDelta)rootDelta);
        while (!listener.isFinished(66)) {
            if (Display.getDefault().readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testPreserveExpandedOnRemove() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        ModelDelta delta = model.removeElementChild(TreePath.EMPTY, 0);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    public void testPreserveExpandedOnInsert() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        ModelDelta delta = model.insertElementChild(TreePath.EMPTY, 0, new TestModel.TestElement(model, "0 - new", new TestModel.TestElement[0]));
        TreePath path = model.findElement("0 - new");
        this.fListener.reset(path, (TestModel.TestElement)((Object)path.getLastSegment()), 0, false, false);
        this.fListener.addChildreUpdate(TreePath.EMPTY, 0);
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(12543)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    public void testPreserveExpandedOnMultLevelContent() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(new TreePath[]{model.findElement("5"), model.findElement("5.1"), model.findElement("6")});
        this.fViewer.setSelection((ISelection)originalSelection);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        model.removeElementChild(TreePath.EMPTY, 0);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), -1, 12479);
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 1024);
        ModelDelta elementDelta = model.getElementDelta(rootDelta, model.findElement("3.1.1"), true);
        elementDelta.setFlags(1024);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        StateTests.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 5));
    }

    public void testPreserveExpandedOnSubTreeContent() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        TreeSelection originalSelection = new TreeSelection(model.findElement("3.3.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        model.addElementChild(model.findElement("3"), null, 0, new TestModel.TestElement(model, "3.0 - new", new TestModel.TestElement[0]));
        TreePath elementPath = model.findElement("3");
        ModelDelta rootDelta = new ModelDelta((Object)model.getRootElement(), 0);
        ModelDelta elementDelta = model.getElementDelta(rootDelta, elementPath, true);
        elementDelta.setFlags(1024);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getInternalViewer(), elementPath, model.getElement(elementPath), -1, 12479);
        model.postDelta((IModelDelta)rootDelta);
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.2")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.3")));
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    public void testPreserveExpandedOnContentStress() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        int i = 0;
        while (i < 10) {
            model.removeElementChild(TreePath.EMPTY, 0);
            this.fListener.reset(false, false);
            this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), -1, 12479);
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(12991)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            model.validateData(this.fViewer, TreePath.EMPTY, true);
            StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
            StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
            StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
            StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
            model.addElementChild(TreePath.EMPTY, null, 0, new TestModel.TestElement(model, "1", new TestModel.TestElement[0]));
            this.fListener.reset(false, false);
            this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), -1, 12479);
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(12991)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            model.validateData(this.fViewer, TreePath.EMPTY, true);
            StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
            StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
            StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
            StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
            StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
            ++i;
        }
    }

    public void testPreserveLargeModelOnContent() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(100);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.expandAlternateElements(this.fListener, model, false);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        model.removeElementChild(TreePath.EMPTY, 0);
        this.fListener.reset(false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        model.addElementChild(TreePath.EMPTY, null, 0, new TestModel.TestElement(model, "1", new TestModel.TestElement[0]));
        this.fListener.reset(false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    public void testPreserveSelectionDeltaAfterContent() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3.1.1")));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta selectDelta = model.makeElementDelta(model.findElement("2.1"), 0x200000);
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)selectDelta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertEquals((Object)new TreeSelection(model.findElement("2.1")), (Object)this.fViewer.getSelection());
    }

    public void testPreserveCollapseDeltaAfterContent() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta collapseDelta = model.makeElementDelta(model.findElement("3.1"), 0x2000000);
        this.fListener.resetModelChanged();
        this.fListener.removeLabelUpdate(model.findElement("3.1.1"));
        this.fListener.removeLabelUpdate(model.findElement("3.1.2"));
        this.fListener.removeLabelUpdate(model.findElement("3.1.3"));
        this.fListener.removeHasChildrenUpdate(model.findElement("3.1.1"));
        this.fListener.removeHasChildrenUpdate(model.findElement("3.1.2"));
        this.fListener.removeHasChildrenUpdate(model.findElement("3.1.3"));
        this.fListener.removeChildreCountUpdate(model.findElement("3.1"));
        this.fListener.removeChildrenUpdate(model.findElement("3.1"), 0);
        this.fListener.removeChildrenUpdate(model.findElement("3.1"), 1);
        this.fListener.removeChildrenUpdate(model.findElement("3.1"), 2);
        model.postDelta((IModelDelta)collapseDelta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")) ? 1 : 0) != 0);
    }

    public void testPreserveExpandDeltaAfterContent() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta expandDelta = model.makeElementDelta(model.findElement("3.1"), 0x100000);
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)expandDelta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(12991)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
    }

    public void testSaveAndRestore1() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("5.1"), model.findElement("5.1.1"), model.findElement("6.1.1")}));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(false, false);
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(1280)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            StateTests.fail((String)("Expected:\n" + originalState.toString() + "\nGot:\n" + restoredState));
        }
    }

    public void testSaveAndRestore2() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("3.2"), model.findElement("3.2.1"), model.findElement("2")}));
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3.2.3")));
        this.fViewer.setAutoExpandLevel(-1);
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(true, false);
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(1280)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            StateTests.fail((String)("Expected:\n" + originalState.toString() + "\nGot:\n" + restoredState));
        }
    }

    public void testSaveAndRestoreInputInstance() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("5.1"), model.findElement("5.1.1"), model.findElement("6.1.1")}));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            StateTests.fail((String)("Expected:\n" + originalState.toString() + "\nGot:\n" + restoredState));
        }
    }

    public void testSaveAndRestoreInputInstanceEquals() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("5.1"), model.findElement("5.1.1"), model.findElement("6.1.1")}));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        TestModel.TestElement newRoot = new TestModel.TestElement(model, model.getRootElement().getID(), model.getRootElement().getChildren());
        model.setRoot(newRoot);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        ModelDelta restoredState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, restoredState, 0x300000);
        if (!this.deltaMatches(originalState, restoredState)) {
            StateTests.fail((String)("Expected:\n" + originalState.toString() + "\nGot:\n" + restoredState));
        }
    }

    public void testSaveAndRestoreLarge() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(100);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.expandAlternateElements(this.fListener, model, false);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset();
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(1280)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    public void testSaveAndRestorePartialStateLarge() throws InterruptedException {
        TestModel model = StateTests.alternatingSubsreesModel(100);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(2)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.expandAlternateElements(this.fListener, model, false);
        TreeSelection originalSelection = new TreeSelection(model.findElement("5.1.1"));
        this.fViewer.setSelection((ISelection)originalSelection);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        ModelDelta originalState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, originalState, 0x300000);
        this.fListener.reset();
        this.fListener.addStateUpdates(this.getInternalViewer(), (IModelDelta)originalState, 0x1300000);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(1280)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TestModel.TestElement[] elements = model.getRootElement().getChildren();
        TestModel.TestElement[] newElements = new TestModel.TestElement[10];
        System.arraycopy(elements, 0, newElements, 0, newElements.length);
        model.setElementChildren(TreePath.EMPTY, newElements);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished(514)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("1.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        StateTests.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        StateTests.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    public void testPreserveCollapseAndSelectDeltaAfterSaveAndRestore() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        this.fViewer.setSelection((ISelection)new TreeSelection(model.findElement("3")));
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset(false, false);
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(256)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        TreePath path = model.findElement("2");
        this.fListener.addUpdates(null, path, (TestModel.TestElement)((Object)path.getLastSegment()), 0, 1024);
        path = model.findElement("3");
        this.fListener.addUpdates(null, path, (TestModel.TestElement)((Object)path.getLastSegment()), 0, 1024);
        while (!this.fListener.isFinished(33555552)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)model.makeElementDelta(model.findElement("2"), 0x2000000));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fListener.resetModelChanged();
        model.postDelta((IModelDelta)model.makeElementDelta(model.findElement("3"), 0x2000000));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.postDelta((IModelDelta)model.makeElementDelta(model.findElement("1"), 0x200000));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        while (!this.fListener.isFinished(512)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        StateTests.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("3")) ? 1 : 0) != 0);
        StateTests.assertEquals((Object)new TreeSelection(model.findElement("1")), (Object)this.fViewer.getSelection());
    }

    public void testSaveRestoreOrder() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        model.setDelayUpdates(true);
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY, true);
        TestModel copyModel = TestModel.simpleMultiLevel();
        this.fListener.reset();
        this.fListener.expectRestoreAfterSaveComplete();
        this.fViewer.setInput((Object)copyModel.getRootElement());
        while (!this.fListener.isFinished(0x2000000)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        StateTests.assertTrue((String)"RESTORE started before SAVE to complete", (boolean)this.fListener.isFinished(256));
    }

    public void testUpdateWithNullInput() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        ModelDelta expandedState = new ModelDelta((Object)model.getRootElement(), 0);
        this.fViewer.saveElementState(TreePath.EMPTY, expandedState, 0x100000);
        this.fListener.reset();
        this.fListener.addChildreCountUpdate(TreePath.EMPTY);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(80)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fViewer.setInput(null);
        this.fViewer.updateViewer((IModelDelta)expandedState);
        while (!this.fListener.isFinished(4154)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }
}

