/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.eclipe.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipe.debug.tests.viewer.model.TestModel;
import org.eclipe.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;

public abstract class UpdateTests
extends TestCase
implements ITestModelUpdatesListenerConstants {
    Display fDisplay;
    Shell fShell;
    ITreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    public UpdateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = new TestModelUpdatesListener(this.fViewer, false, false);
        this.fShell.open();
    }

    protected abstract ITreeModelViewer createViewer(Display var1, Shell var2);

    protected void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        while (!this.fShell.isDisposed()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            throw new ExecutionException("Test failed: " + t.getMessage() + "\n fListener = " + this.fListener.toString(), t);
        }
    }

    public void testRemoveElements() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement root = model.getRootElement();
        TreePath rootPath = new TreePath(new Object[0]);
        TestModel.TestElement[] newElements = new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0]), new TestModel.TestElement(model, "3", new TestModel.TestElement[0])};
        model.setElementChildren(rootPath, newElements);
        this.fListener.reset(rootPath, root, -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)root, 1024));
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testAddNewChildren() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        TreePath elementPath = new TreePath(new Object[]{element});
        TestModel.TestElement[] newChildren = new TestModel.TestElement[]{new TestModel.TestElement(model, "1.1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.2", new TestModel.TestElement[0]), new TestModel.TestElement(model, "1.3", new TestModel.TestElement[0])};
        model.setElementChildren(elementPath, newChildren);
        TreePath rootPath = TreePath.EMPTY;
        TestModel.TestElement rootElement = model.getRootElement();
        this.fListener.reset(rootPath, rootElement, -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)rootElement, 1024));
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    private void removeElement(TestModel model, int index, boolean validate) throws InterruptedException {
        ModelDelta delta = model.removeElementChild(TreePath.EMPTY, index);
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        if (validate) {
            model.validateData(this.fViewer, TreePath.EMPTY);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addElement(TestModel model, String label, int position, boolean validate) throws InterruptedException {
        block2: {
            delta = model.addElementChild(TreePath.EMPTY, null, position, new TestModel.TestElement(model, label, new TestModel.TestElement[0]));
            this.fListener.reset();
            model.postDelta((IModelDelta)delta);
            if (!validate) ** GOTO lbl13
            while (!this.fListener.isFinished(67)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            model.validateData(this.fViewer, TreePath.EMPTY);
            break block2;
lbl-1000:
            // 1 sources

            {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
lbl13:
                // 3 sources

                ** while (!this.fListener.isFinished((int)64))
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertElement(TestModel model, String label, int position, boolean validate) throws InterruptedException {
        block2: {
            delta = model.insertElementChild(TreePath.EMPTY, position, new TestModel.TestElement(model, label, new TestModel.TestElement[0]));
            this.fListener.reset();
            model.postDelta((IModelDelta)delta);
            if (!validate) ** GOTO lbl13
            while (!this.fListener.isFinished(67)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            model.validateData(this.fViewer, TreePath.EMPTY);
            break block2;
lbl-1000:
            // 1 sources

            {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
lbl13:
                // 3 sources

                ** while (!this.fListener.isFinished((int)64))
            }
        }
    }

    public void testRepeatedAddRemoveElement() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        this.removeElement(model, 2, true);
        this.addElement(model, "3-new", 3, true);
        this.removeElement(model, 4, true);
        this.addElement(model, "5-new", 5, true);
        this.removeElement(model, 1, true);
        this.addElement(model, "1-new", 1, true);
        this.removeElement(model, 3, true);
        this.addElement(model, "4-new", 4, true);
    }

    public void testNotifyUpdatesTartedOnModelChanged() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        this.fListener.reset();
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(64)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        Assert.assertTrue((boolean)this.fListener.isFinished(131072));
    }

    public void testContentPlusAddRemoveUpdateRaceConditionsElement() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        TestModelUpdatesListener childrenCountUpdateListener = new TestModelUpdatesListener(this.fViewer, false, false);
        int i = 0;
        while (i < 10) {
            String pass = "pass #" + i;
            childrenCountUpdateListener.reset();
            childrenCountUpdateListener.addChildreCountUpdate(TreePath.EMPTY);
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(64)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            this.removeElement(model, 5, false);
            this.removeElement(model, 4, false);
            this.removeElement(model, 3, false);
            this.removeElement(model, 2, false);
            this.removeElement(model, 1, false);
            this.removeElement(model, 0, false);
            while (!childrenCountUpdateListener.isFinished(16)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            this.insertElement(model, "1 - " + pass, 0, false);
            this.insertElement(model, "2 - " + pass, 1, false);
            this.insertElement(model, "3 - " + pass, 2, false);
            this.insertElement(model, "4 - " + pass, 3, false);
            this.insertElement(model, "5 - " + pass, 4, false);
            this.insertElement(model, "6 - " + pass, 5, false);
            while (!this.fListener.isFinished(64)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            model.validateData(this.fViewer, TreePath.EMPTY);
            ++i;
        }
        childrenCountUpdateListener.dispose();
    }

    public void testInsertAtInvalidIndex() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        final int insertIndex = model.getRootElement().getChildren().length;
        ModelDelta delta = model.insertElementChild(TreePath.EMPTY, insertIndex, new TestModel.TestElement(model, "last - invalid index", new TestModel.TestElement[0]));
        delta.accept(new IModelDeltaVisitor(){

            public boolean visit(IModelDelta visitorDelta, int depth) {
                if ((visitorDelta.getFlags() & 0x10) != 0) {
                    ((ModelDelta)visitorDelta).setIndex(insertIndex + 1);
                    return false;
                }
                return true;
            }
        });
        this.fListener.reset();
        model.postDelta((IModelDelta)delta);
        while (!this.fListener.isFinished(67)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
    }

    public void testRescheduleUpdates() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        int i = 0;
        while (i < 5) {
            TestModel.TestElement rootElement = model.getRootElement();
            this.fListener.reset();
            this.fListener.addUpdates(TreePath.EMPTY, model.getRootElement(), 1, 16);
            model.postDelta((IModelDelta)new ModelDelta((Object)rootElement, 1024));
            while (!this.fListener.isFinished(0x200050)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            this.removeElement(model, 0, true);
            this.addElement(model, "1", 0, true);
            ++i;
        }
    }

    public void testCanceledUpdates1() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(0x100040)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            ++i;
        }
        model.setQeueueingUpdate(false);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testCanceledUpdates2() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(0x100040)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            ++i;
        }
        ArrayList<IViewerUpdate> updates = new ArrayList<IViewerUpdate>(model.getQueuedUpdates());
        model.getQueuedUpdates().clear();
        int i2 = updates.size() - 1;
        while (i2 >= 0) {
            model.processUpdate(updates.get(i2));
            --i2;
        }
        model.setQeueueingUpdate(false);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testCanceledUpdates3() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(0x200040)) {
                this.completeQueuedUpdatesOfType(model, IChildrenCountUpdate.class);
                this.completeQueuedUpdatesOfType(model, IHasChildrenUpdate.class);
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            ++i;
        }
        model.setQeueueingUpdate(false);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testCanceledUpdates4() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(true);
        int i = 0;
        while (i < 5) {
            this.fListener.reset();
            model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
            while (!this.fListener.isFinished(0x200040)) {
                this.completeQueuedUpdatesOfType(model, IChildrenCountUpdate.class);
                this.completeQueuedUpdatesOfType(model, IHasChildrenUpdate.class);
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            ++i;
        }
        ArrayList<IViewerUpdate> updates = new ArrayList<IViewerUpdate>(model.getQueuedUpdates());
        model.getQueuedUpdates().clear();
        int i2 = updates.size() - 1;
        while (i2 >= 0) {
            model.processUpdate(updates.get(i2));
            --i2;
        }
        model.setQeueueingUpdate(false);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testCancelUpdatesOnRemoveElementWhileUpdatingSubTree() throws InterruptedException {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        this.fListener.reset();
        TreePath path = model.findElement("2");
        this.fListener.addUpdates(path, model.getElement(path), 1, 16);
        this.fListener.addChildreUpdate(path, 0);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(0x400050)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.removeElement(model, 1, true);
        while (!this.fListener.isFinished(12479)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testCanceledUpdatesOnSetInput() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(false);
        this.fListener.reset();
        this.fListener.addChildreCountUpdate(TreePath.EMPTY);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(80)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        TestModel model2 = new TestModel();
        model2.setRoot(new TestModel.TestElement(model2, "root", new TestModel.TestElement[0]));
        this.fViewer.setInput((Object)model2.getRootElement());
        while (!this.fListener.isFinished(4154)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    public void testCanceledUpdatesOnSetNullInput() throws InterruptedException {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        this.fViewer.setInput((Object)model.getRootElement());
        while (!this.fListener.isFinished()) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        model.validateData(this.fViewer, TreePath.EMPTY);
        model.setQeueueingUpdate(false);
        this.fListener.reset();
        this.fListener.addChildreCountUpdate(TreePath.EMPTY);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        while (!this.fListener.isFinished(80)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
        this.fViewer.setInput(null);
        while (!this.fListener.isFinished(4154)) {
            if (this.fDisplay.readAndDispatch()) continue;
            Thread.sleep(0L);
        }
    }

    private void completeQueuedUpdatesOfType(TestModel model, Class<?> updateClass) {
        LinkedList<IViewerUpdate> updatesToComplete = new LinkedList<IViewerUpdate>();
        Iterator<Object> itr = model.getQueuedUpdates().iterator();
        while (itr.hasNext()) {
            IViewerUpdate update = itr.next();
            if (!updateClass.isInstance(update)) continue;
            updatesToComplete.add(update);
            itr.remove();
        }
        if (updatesToComplete != null) {
            itr = updatesToComplete.iterator();
            while (itr.hasNext()) {
                model.processUpdate((IViewerUpdate)itr.next());
            }
        }
    }
}

