/*
 * Decompiled with CFR 0.152.
 */
package org.eclipe.debug.tests.viewer.model;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemValidator;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualItem;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTree;

public class VisibleVirtualItemValidator
implements IVirtualItemValidator {
    private int fStart = 0;
    private int fEnd = 0;

    public VisibleVirtualItemValidator(int startPosition, int length) {
        this.setVisibleRange(startPosition, length);
    }

    public void setVisibleRange(int startPosition, int length) {
        this.fStart = startPosition;
        this.fEnd = startPosition + length;
    }

    public int getStartPosition() {
        return this.fStart;
    }

    public int getLength() {
        return this.fEnd - this.fStart;
    }

    public boolean isItemVisible(VirtualItem item) {
        int position = 0;
        while (item.getParent() != null) {
            position += item.getIndex().intValue();
            item = item.getParent();
        }
        return position >= this.fStart && position < this.fEnd || this.isSelected(item);
    }

    public void showItem(VirtualItem item) {
        int length = this.fEnd - this.fStart;
        this.fStart = this.calcPosition(item);
        this.fEnd = this.fStart + length;
    }

    private int calcPosition(VirtualItem item) {
        int position = 0;
        while (item.getParent() != null) {
            position += item.getIndex().intValue();
            item = item.getParent();
        }
        return position;
    }

    private boolean isSelected(VirtualItem item) {
        VirtualItem[] selection = this.getSelection(item);
        int i = 0;
        while (i < selection.length) {
            VirtualItem selectionItem = selection[i];
            while (selectionItem != null) {
                if (item.equals(selectionItem)) {
                    return true;
                }
                selectionItem = selectionItem.getParent();
            }
            ++i;
        }
        return false;
    }

    private VirtualItem[] getSelection(VirtualItem item) {
        VirtualTree tree = this.getTree(item);
        if (tree != null) {
            return tree.getSelection();
        }
        return new VirtualItem[0];
    }

    private VirtualTree getTree(VirtualItem item) {
        while (item != null && !(item instanceof VirtualTree)) {
            item = item.getParent();
        }
        return (VirtualTree)item;
    }
}

