/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.tests.TestActivator;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class DefineCommandsTest
extends TestCase {
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    public void testCreateCommands() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        DefineCommandsTest.assertNotNull((Object)cs);
        DefineCommandsTest.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        DefineCommandsTest.assertNotNull((String)"need category", (Object)category);
        DefineCommandsTest.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        DefineCommandsTest.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        Command cmd1 = cs.getCommand(TEST_ID1);
        DefineCommandsTest.assertNotNull((String)"get command1", (Object)cmd1);
        DefineCommandsTest.assertEquals((String)"ID1", (String)cmd1.getName());
        DefineCommandsTest.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
        DefineCommandsTest.assertNotNull((String)"parameterized command", (Object)cs.createCommand(TEST_ID1, null));
    }

    public void testCreateWithSecondContexts() throws Exception {
        IEclipseContext localContext = this.workbenchContext.createChild();
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class);
        DefineCommandsTest.assertNotNull((Object)cs);
        DefineCommandsTest.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        DefineCommandsTest.assertNotNull((String)"need category", (Object)category);
        DefineCommandsTest.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        DefineCommandsTest.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        Command cmd1 = cs.getCommand(TEST_ID1);
        DefineCommandsTest.assertNotNull((String)"get command1", (Object)cmd1);
        DefineCommandsTest.assertEquals((String)"ID1", (String)cmd1.getName());
        DefineCommandsTest.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
    }

    public void testCreateWithTwoContexts() throws Exception {
        IEclipseContext localContext = this.workbenchContext.createChild("Level1");
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class);
        DefineCommandsTest.assertNotNull((Object)cs);
        DefineCommandsTest.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        DefineCommandsTest.assertNotNull((String)"need category", (Object)category);
        DefineCommandsTest.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        DefineCommandsTest.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Command cmd1 = cs.getCommand(TEST_ID1);
        DefineCommandsTest.assertNotNull((String)"get command1", (Object)cmd1);
        DefineCommandsTest.assertEquals((String)"ID1", (String)cmd1.getName());
        DefineCommandsTest.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
    }

    protected void setUp() throws Exception {
        IEclipseContext globalContext = TestActivator.getDefault().getGlobalContext();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
    }

    protected void tearDown() throws Exception {
        this.workbenchContext.dispose();
    }
}

