/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.internal.tests.contexts.ContextFunctionHigh;
import org.eclipse.e4.core.internal.tests.contexts.ContextFunctionLow;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class CoreTestsActivator
implements BundleActivator {
    private static CoreTestsActivator defaultInstance;
    private BundleContext bundleContext;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    private ServiceTracker<IPreferencesService, IPreferencesService> preferencesTracker = null;
    private ServiceTracker<EventAdmin, EventAdmin> eventAdminTracker;

    public CoreTestsActivator() {
        defaultInstance = this;
    }

    public static CoreTestsActivator getDefault() {
        return defaultInstance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.registerContextFunctions();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
            this.preferencesTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        this.bundleContext = null;
    }

    private void registerContextFunctions() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.context.key", "test.contextfunction.ranking");
        ((Dictionary)properties).put("service.ranking", 0);
        this.bundleContext.registerService(IContextFunction.SERVICE_NAME, (Object)new ContextFunctionLow(), properties);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.context.key", "test.contextfunction.ranking");
        ((Dictionary)properties).put("service.ranking", 100);
        this.bundleContext.registerService(IContextFunction.SERVICE_NAME, (Object)new ContextFunctionHigh(), properties);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IPreferencesService getPreferencesService() {
        if (this.preferencesTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.preferencesTracker = new ServiceTracker(this.bundleContext, IPreferencesService.class.getName(), null);
            this.preferencesTracker.open();
        }
        return (IPreferencesService)this.preferencesTracker.getService();
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        DebugOptions options;
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(this.bundleContext, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        if ((options = (DebugOptions)this.debugTracker.getService()) != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public EventAdmin getEventAdmin() {
        if (this.eventAdminTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.eventAdminTracker = new ServiceTracker(this.bundleContext, EventAdmin.class.getName(), null);
            this.eventAdminTracker.open();
        }
        return (EventAdmin)this.eventAdminTracker.getService();
    }
}

