/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.osgi.framework.BundleContext;

public class RunAndTrackTest
extends TestCase {
    static final String ACTIVE_CHILD = "activeChild";
    static final String ACTIVE_PART = "activePart";
    static final String ACTIVE_PART_ID = "activePartId";
    static final String INTERNAL_LOCAL_PART = "localPart";
    private List<IEclipseContext> createdContexts = new ArrayList<IEclipseContext>();

    private IEclipseContext createContext(IEclipseContext parentContext, String level) {
        IEclipseContext childContext = parentContext.createChild(level);
        this.createdContexts.add(childContext);
        return childContext;
    }

    private IEclipseContext getGlobalContext() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)CoreTestsActivator.getDefault().getBundleContext());
        IEclipseContext appContext = this.createContext(serviceContext, "globalContext");
        appContext.set("globalContext", (Object)appContext);
        return appContext;
    }

    private IEclipseContext[] createNextLevel(IEclipseContext parent, String prefix, int num) {
        RunAndTrackTest.assertTrue((num > 0 ? 1 : 0) != 0);
        IEclipseContext[] contexts = new IEclipseContext[num];
        int i = 0;
        while (i < num) {
            contexts[i] = this.createContext(parent, String.valueOf(prefix) + i);
            contexts[i].set(INTERNAL_LOCAL_PART, (Object)(String.valueOf(prefix) + i));
            ++i;
        }
        parent.set(ACTIVE_CHILD, (Object)contexts[0]);
        return contexts;
    }

    protected void tearDown() throws Exception {
        for (IEclipseContext context : this.createdContexts) {
            context.dispose();
        }
        this.createdContexts.clear();
        super.tearDown();
    }

    public void testActiveChain() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        this.createNextLevel(windows[0], "part", 2);
        RunAndTrackTest.assertEquals((Object)"part0", (Object)workbenchContext.get(ACTIVE_PART));
    }

    public void testActiveChange() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        IEclipseContext[] parts = this.createNextLevel(windows[0], "part", 2);
        RunAndTrackTest.assertEquals((Object)"part0", (Object)workbenchContext.get(ACTIVE_PART));
        windows[0].set(ACTIVE_CHILD, (Object)parts[1]);
        RunAndTrackTest.assertEquals((Object)"part1", (Object)workbenchContext.get(ACTIVE_PART));
    }

    public void testRunAndTrackComplex() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        final IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        windows[0].runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                Object part = windows[0].get(RunAndTrackTest.ACTIVE_PART);
                windows[0].set(RunAndTrackTest.ACTIVE_PART_ID, part);
                return true;
            }

            public String toString() {
                return RunAndTrackTest.ACTIVE_PART_ID;
            }
        });
        IEclipseContext[] mainSashes = this.createNextLevel(windows[0], "mainSash", 2);
        this.createNextLevel(mainSashes[1], "editorArea", 1);
        IEclipseContext[] viewSashes = this.createNextLevel(mainSashes[0], "viewSashes", 2);
        IEclipseContext[] packageStack = this.createNextLevel(viewSashes[0], "packageStack", 1);
        IEclipseContext[] packageViews = this.createNextLevel(packageStack[0], "packageViews", 3);
        RunAndTrackTest.assertNotNull((Object)packageViews);
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART_ID));
        IEclipseContext[] problemsStack = this.createNextLevel(viewSashes[1], "problemsStack", 1);
        IEclipseContext[] problemsViews = this.createNextLevel(problemsStack[0], "problemViews", 5);
        RunAndTrackTest.assertNotNull((Object)problemsViews);
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)windows[0].get(ACTIVE_PART_ID));
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)problemsStack[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)problemsStack[0].get(ACTIVE_PART_ID));
        problemsStack[0].set(ACTIVE_CHILD, (Object)problemsViews[0]);
        viewSashes[1].set(ACTIVE_CHILD, (Object)problemsStack[0]);
        mainSashes[0].set(ACTIVE_CHILD, (Object)viewSashes[1]);
        windows[0].set(ACTIVE_CHILD, (Object)mainSashes[0]);
        workbenchContext.set(ACTIVE_CHILD, (Object)windows[0]);
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)windows[0].get(ACTIVE_PART_ID));
        RunAndTrackTest.assertEquals((Object)"packageViews0", (Object)packageStack[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"problemViews0", (Object)packageStack[0].get(ACTIVE_PART_ID));
    }

    public void testRunAndTrackSimple() throws Exception {
        IEclipseContext workbenchContext = this.getGlobalContext();
        workbenchContext.set(ACTIVE_PART, (Object)new ActivePartLookupFunction());
        final IEclipseContext[] windows = this.createNextLevel(workbenchContext, "window", 1);
        windows[0].runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                Object part = windows[0].get(RunAndTrackTest.ACTIVE_PART);
                windows[0].set(RunAndTrackTest.ACTIVE_PART_ID, part);
                return true;
            }

            public String toString() {
                return RunAndTrackTest.ACTIVE_PART_ID;
            }
        });
        IEclipseContext[] parts = this.createNextLevel(windows[0], "part", 2);
        RunAndTrackTest.assertEquals((Object)"part0", (Object)workbenchContext.get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"part0", (Object)windows[0].get(ACTIVE_PART_ID));
        windows[0].set(ACTIVE_CHILD, (Object)parts[1]);
        RunAndTrackTest.assertEquals((Object)"part1", (Object)windows[0].get(ACTIVE_PART));
        RunAndTrackTest.assertEquals((Object)"part1", (Object)windows[0].get(ACTIVE_PART_ID));
    }

    public void testSetHiddenValueToChildObject() {
        this.doHiddenValueChangeTest("child");
    }

    public void testSetHiddenValueToDifferentObject() {
        this.doHiddenValueChangeTest("other");
    }

    public void testSetHiddenValueToObjectEqualToChild() {
        String newRootValue = new String("child");
        this.doHiddenValueChangeTest(newRootValue);
    }

    public void testSetHiddenValueToRootObject() {
        this.doHiddenValueChangeTest("root");
    }

    public void testSetHiddenValueToEqualRootObject() {
        String newRootValue = new String("root");
        this.doHiddenValueChangeTest(newRootValue);
    }

    public void testSetHiddenValueToNull() {
        String newRootValue = null;
        this.doHiddenValueChangeTest(newRootValue);
    }

    void doHiddenValueChangeTest(final String newRootValue) {
        this.doHiddenValueChangeTest(new ITestAction(){

            @Override
            public void execute(IEclipseContext root, String var) {
                root.set(var, (Object)newRootValue);
            }
        }, "child", 0);
    }

    void doHiddenValueChangeTest(ITestAction testAction, Object expectedValue, int expectedRATCalls) {
        IEclipseContext root = this.getGlobalContext();
        IEclipseContext child = root.createChild("child");
        root.set("v", (Object)"root");
        child.set("v", (Object)"child");
        TestRAT testRAT = new TestRAT("v");
        child.runAndTrack((RunAndTrack)testRAT);
        RunAndTrackTest.assertEquals((Object)"child", (Object)testRAT.getVarValue());
        RunAndTrackTest.assertEquals((int)1, (int)testRAT.getCalls());
        testRAT.resetCalls();
        testAction.execute(root, "v");
        RunAndTrackTest.assertEquals((Object)expectedValue, (Object)testRAT.getVarValue());
        RunAndTrackTest.assertEquals((int)expectedRATCalls, (int)testRAT.getCalls());
    }

    public void testRemoveHiddenVariable() {
        this.doHiddenValueChangeTest(new ITestAction(){

            @Override
            public void execute(IEclipseContext root, String var) {
                root.remove(var);
            }
        }, "child", 0);
    }

    public void testSetContextVarToSameObject() {
        this.doSingleContextChangeTest(new ITestAction(){

            @Override
            public void execute(IEclipseContext root, String var) {
                root.set(var, (Object)"root");
            }
        }, "root", 0);
    }

    public void testSetContextVarToEqualObject() {
        this.doSingleContextChangeTest(new ITestAction(){

            @Override
            public void execute(IEclipseContext root, String var) {
                root.set(var, (Object)new String("root"));
            }
        }, "root", 1);
    }

    public void testSetContextVarToOtherObject() {
        this.doSingleContextChangeTest(new ITestAction(){

            @Override
            public void execute(IEclipseContext root, String var) {
                root.set(var, (Object)"other");
            }
        }, "other", 1);
    }

    public void testRemoveContextVar() {
        this.doSingleContextChangeTest(new ITestAction(){

            @Override
            public void execute(IEclipseContext root, String var) {
                root.remove(var);
            }
        }, null, 1);
    }

    private void doSingleContextChangeTest(ITestAction testAction, Object expectedValue, int expectedRATCalls) {
        IEclipseContext root = this.getGlobalContext();
        root.set("v", (Object)"root");
        TestRAT testRAT = new TestRAT("v");
        root.runAndTrack((RunAndTrack)testRAT);
        RunAndTrackTest.assertEquals((Object)"root", (Object)testRAT.getVarValue());
        RunAndTrackTest.assertEquals((int)1, (int)testRAT.getCalls());
        testRAT.resetCalls();
        testAction.execute(root, "v");
        RunAndTrackTest.assertEquals((int)expectedRATCalls, (int)testRAT.getCalls());
        RunAndTrackTest.assertEquals((Object)expectedValue, (Object)testRAT.getVarValue());
    }

    private class ActivePartLookupFunction
    extends ContextFunction {
        private ActivePartLookupFunction() {
        }

        public Object compute(IEclipseContext context, String contextKey) {
            IEclipseContext childContext = (IEclipseContext)context.getLocal(RunAndTrackTest.ACTIVE_CHILD);
            if (childContext != null) {
                return childContext.get(RunAndTrackTest.ACTIVE_PART);
            }
            return context.get(RunAndTrackTest.INTERNAL_LOCAL_PART);
        }
    }

    private static interface ITestAction {
        public void execute(IEclipseContext var1, String var2);
    }

    private static final class TestRAT
    extends RunAndTrack {
        private String varName;
        private Object varValue;
        private int calls = 0;

        public TestRAT(String varName) {
            this.varName = varName;
        }

        public boolean changed(IEclipseContext context) {
            ++this.calls;
            this.varValue = context.get(this.varName);
            return true;
        }

        public int getCalls() {
            return this.calls;
        }

        public Object getVarValue() {
            return this.varValue;
        }

        public void resetCalls() {
            this.calls = 0;
        }
    }
}

