/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ComplexDisposalTest
extends TestCase {
    public void testU() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        parentContext.set(Test.class.getName(), (Object)new TestFunction());
        IEclipseContext context = parentContext.createChild();
        Test test = (Test)context.get(Test.class.getName());
        ComplexDisposalTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        ComplexDisposalTest.assertEquals((String)"Context disposed, @PreDestroy should've been called", (int)1, (int)test.getCount());
        parentContext.dispose();
        ComplexDisposalTest.assertEquals((String)"Parent context disposed, @PreDestroy should not have been called again", (int)1, (int)test.getCount());
    }

    public void testV() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        IEclipseContext context = parentContext.createChild();
        Test test = (Test)ContextInjectionFactory.make(Test.class, (IEclipseContext)context);
        ComplexDisposalTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        ComplexDisposalTest.assertEquals((String)"Context disposed, @PreDestroy should've been called", (int)1, (int)test.getCount());
        parentContext.dispose();
        ComplexDisposalTest.assertEquals((String)"Parent context disposed, @PreDestroy should not have been called again", (int)1, (int)test.getCount());
    }

    public void testW() throws Exception {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        IEclipseContext context = parentContext.createChild();
        Test test = new Test();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        ComplexDisposalTest.assertEquals((int)0, (int)test.getCount());
        context.dispose();
        ComplexDisposalTest.assertEquals((String)"Context disposed, @PreDestroy should've been called", (int)1, (int)test.getCount());
        parentContext.dispose();
        ComplexDisposalTest.assertEquals((String)"Parent context disposed, @PreDestroy should not have been called again", (int)1, (int)test.getCount());
    }

    public static class Test {
        private int count = 0;
        @Inject
        @Named(value="aString")
        String string;

        public int getCount() {
            return this.count;
        }

        @PreDestroy
        void preDestroy() {
            ++this.count;
        }
    }

    public static class TestFunction
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            return ContextInjectionFactory.make(Test.class, (IEclipseContext)context);
        }
    }
}

