/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.inject.Singleton;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.extensions.EventUtils;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class InjectionEventTest
extends TestCase {
    protected static boolean testFailed = false;
    private EventAdminHelper helper;

    protected void setUp() throws Exception {
        super.setUp();
        InjectionEventTest.ensureEventAdminStarted();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.helper = (EventAdminHelper)ContextInjectionFactory.make(EventAdminHelper.class, (IEclipseContext)localContext);
    }

    public void testEventInjection() throws InvocationTargetException, InstantiationException {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        InjectionEventTest.assertEquals((int)0, (int)target.counter1);
        InjectionEventTest.assertNull((Object)target.string1);
        InjectionEventTest.assertEquals((int)1, (int)target.counter3);
        InjectionEventTest.assertNull((Object)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "event1data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        InjectionEventTest.assertEquals((int)1, (int)target.counter3);
        InjectionEventTest.assertNull((Object)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event2", "event2data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        InjectionEventTest.assertEquals((int)1, (int)target.counter3);
        InjectionEventTest.assertNull((Object)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event3", "event3data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        InjectionEventTest.assertEquals((int)2, (int)target.counter3);
        InjectionEventTest.assertEquals((String)"event3data", (String)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "abc");
        InjectionEventTest.assertEquals((int)2, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"abc", (String)target.string1);
        InjectionEventTest.assertEquals((int)2, (int)target.counter3);
        InjectionEventTest.assertEquals((String)"event3data", (String)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
    }

    public void testInjectType() {
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetEvent target = (InjectTargetEvent)ContextInjectionFactory.make(InjectTargetEvent.class, (IEclipseContext)context);
        InjectionEventTest.assertEquals((int)0, (int)target.counter1);
        InjectionEventTest.assertNull((Object)target.event);
        String eventTopic = "e4/test/eventInjection";
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", eventTopic);
        ((Dictionary)d).put("data1", new Integer(5));
        ((Dictionary)d).put("data2", "sample");
        Event event = new Event(eventTopic, d);
        this.helper.sendEvent(event);
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((Object)event, (Object)target.event);
        InjectionEventTest.assertEquals((Object)new Integer(5), (Object)target.event.getProperty("data1"));
        InjectionEventTest.assertEquals((Object)"sample", (Object)target.event.getProperty("data2"));
    }

    public void testEventInjectionUnsubscribe() throws InvocationTargetException, InstantiationException {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        this.wrapSetup();
        System.gc();
        System.runFinalization();
        System.gc();
        this.helper.sendEvent("e4/test/event1", "wrong");
        InjectionEventTest.assertFalse((boolean)testFailed);
    }

    public void testInjectWildCard() {
        IEclipseContext context = EclipseContextFactory.create();
        InjectStarEvent target = (InjectStarEvent)ContextInjectionFactory.make(InjectStarEvent.class, (IEclipseContext)context);
        InjectionEventTest.assertEquals((int)0, (int)target.counter1);
        InjectionEventTest.assertNull((Object)target.event);
        String eventTopic = "e4/test/eventInjection";
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", eventTopic);
        ((Dictionary)d).put("data1", new Integer(5));
        ((Dictionary)d).put("data2", "sample");
        Event event = new Event(eventTopic, d);
        this.helper.sendEvent(event);
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((Object)event, (Object)target.event);
        InjectionEventTest.assertEquals((Object)new Integer(5), (Object)target.event.getProperty("data1"));
        InjectionEventTest.assertEquals((Object)"sample", (Object)target.event.getProperty("data2"));
    }

    private void wrapSetup() throws InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        this.helper.sendEvent("e4/test/event1", "event1data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        target.valid = false;
    }

    static void ensureEventAdminStarted() {
        if (CoreTestsActivator.getDefault().getEventAdmin() == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = CoreTestsActivator.getDefault().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public static class EventAdminHelper {
        @Inject
        public EventAdmin eventAdmin;

        public void sendEvent(String topic, Object data) {
            EventUtils.send((EventAdmin)this.eventAdmin, (String)topic, (Object)data);
        }

        public void sendEvent(Event event) {
            this.eventAdmin.sendEvent(event);
        }
    }

    static class InjectStarEvent {
        public int counter1 = 0;
        public Event event;

        InjectStarEvent() {
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/*") Event event) {
            ++this.counter1;
            this.event = event;
        }
    }

    static class InjectTarget {
        public int counter1 = 0;
        public int counter3 = 0;
        public String string1;
        public String string3;
        public boolean valid = true;
        public MyBinding myBinding;

        InjectTarget() {
        }

        public void resetCounters() {
            this.counter3 = 0;
            this.counter1 = 0;
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/event1") String string1) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter1;
            this.string1 = string1;
        }

        @Inject
        public void receivedOptionalEvent(MyBinding myBinding, @Optional @EventTopic(value="e4/test/event3") String string3) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter3;
            this.myBinding = myBinding;
            this.string3 = string3;
        }
    }

    static class InjectTargetEvent {
        public int counter1 = 0;
        public Event event;

        InjectTargetEvent() {
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/eventInjection") Event event) {
            ++this.counter1;
            this.event = event;
        }
    }

    @Singleton
    static class MyBinding {
        MyBinding() {
        }
    }
}

