/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.OSGiBundle;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InjectionOSGiTest
extends TestCase {
    private InjectionTarget target;
    private Bundle bundle;

    protected void tearDown() throws Exception {
        this.bundle.start();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.uninject((Object)this.target, (IEclipseContext)localContext);
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        this.bundle = bundleContext.getBundle();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.target = (InjectionTarget)ContextInjectionFactory.make(InjectionTarget.class, (IEclipseContext)localContext);
    }

    public void testInject() {
        InjectionOSGiTest.assertTrue((boolean)this.target.hasContext());
    }

    public void testUnInject() throws BundleException, InterruptedException {
        InjectionOSGiTest.assertTrue((boolean)this.target.hasContext());
        BundleContext firstContext = this.target.getContext();
        this.bundle.stop();
        InjectionOSGiTest.assertFalse((boolean)this.target.hasContext());
        this.bundle.start();
        InjectionOSGiTest.assertTrue((boolean)this.target.hasContext());
        BundleContext secondContext = this.target.getContext();
        InjectionOSGiTest.assertNotSame((Object)firstContext, (Object)secondContext);
    }

    public void testBundleInject() throws BundleException {
        InjectionOSGiTest.assertNotNull((Object)this.target.getBundle());
        this.bundle.stop();
        InjectionOSGiTest.assertNotNull((Object)this.target.getBundle());
        InjectionOSGiTest.assertTrue((this.target.getBundle().getState() == 4 ? 1 : 0) != 0);
        InjectionOSGiTest.assertNotNull((Object)this.target.getBundle().getSymbolicName());
        InjectionOSGiTest.assertNull((Object)this.target.getContext());
    }

    static class InjectionBundleTarget
    extends InjectionTarget {
        InjectionBundleTarget() {
        }
    }

    static class InjectionTarget {
        private BundleContext ctx;
        private Bundle b;

        InjectionTarget() {
        }

        @Inject
        public void setBundleContext(@OSGiBundle @Optional BundleContext ctx) {
            this.ctx = ctx;
        }

        public boolean hasContext() {
            return this.ctx != null;
        }

        public BundleContext getContext() {
            return this.ctx;
        }

        @Inject
        public void setBundle(@OSGiBundle Bundle b) {
            this.b = b;
        }

        public Bundle getBundle() {
            return this.b;
        }

        @Inject
        public void setFoo(@OSGiBundle Object o) {
        }
    }
}

