/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.osgi.service.prefs.BackingStoreException;

public class InjectionPreferencesTest
extends TestCase {
    private static final String TEST_PREFS_KEY = "testPreferencesQualifier";
    private static final String TEST_PREFS_NODE = "org.eclipse.e4.core.tests.ext";
    private static final String KEY_INT = "testPreferencesInt";
    private static final String KEY_BOOL = "testPreferencesBoolean";
    private static final String KEY_DOUBLE = "testPreferencesDouble";
    private static final String KEY_FLOAT = "testPreferencesFloat";
    private static final String KEY_LONG = "testPreferencesLong";

    public void testPreferencesQualifier() throws BackingStoreException {
        this.setPreference(TEST_PREFS_KEY, "abc");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "123");
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        InjectionPreferencesTest.assertEquals((int)1, (int)target.counter);
        InjectionPreferencesTest.assertEquals((String)"abc", (String)target.pref);
        InjectionPreferencesTest.assertEquals((int)1, (int)target.counterNode);
        InjectionPreferencesTest.assertEquals((String)"123", (String)target.prefNode);
        InjectionPreferencesTest.assertEquals((int)1, (int)target.counterOptional);
        InjectionPreferencesTest.assertNull((Object)target.prefOptional1);
        InjectionPreferencesTest.assertEquals((String)"abc", (String)target.prefOptional2);
        this.setPreference(TEST_PREFS_KEY, "xyz");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "456");
        InjectionPreferencesTest.assertEquals((int)2, (int)target.counter);
        InjectionPreferencesTest.assertEquals((String)"xyz", (String)target.pref);
        InjectionPreferencesTest.assertEquals((int)2, (int)target.counterNode);
        InjectionPreferencesTest.assertEquals((String)"456", (String)target.prefNode);
        InjectionPreferencesTest.assertEquals((int)2, (int)target.counterOptional);
        InjectionPreferencesTest.assertNull((Object)target.prefOptional1);
        InjectionPreferencesTest.assertEquals((String)"xyz", (String)target.prefOptional2);
    }

    public void testBaseTypeConversion() throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.putInt(KEY_INT, 12);
        node.putBoolean(KEY_BOOL, true);
        node.putDouble(KEY_DOUBLE, 12.35345345345);
        node.putFloat(KEY_FLOAT, 5.13f);
        node.putLong(KEY_LONG, 131232343453453L);
        node.flush();
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetPrimitive target = (InjectTargetPrimitive)ContextInjectionFactory.make(InjectTargetPrimitive.class, (IEclipseContext)context);
        InjectionPreferencesTest.assertEquals((int)12, (int)target.intField);
        InjectionPreferencesTest.assertEquals((boolean)true, (boolean)target.booleanField);
        InjectionPreferencesTest.assertEquals((Object)12.35345345345, (Object)target.doubleField);
        InjectionPreferencesTest.assertEquals((Object)Float.valueOf(5.13f), (Object)Float.valueOf(target.floatField));
        InjectionPreferencesTest.assertEquals((long)131232343453453L, (long)target.longField);
        InjectionPreferencesTest.assertEquals((int)12, (int)target.intArg);
        InjectionPreferencesTest.assertEquals((boolean)true, (boolean)target.booleanArg);
        node.putInt(KEY_INT, 777);
        node.putBoolean(KEY_BOOL, false);
        InjectionPreferencesTest.assertEquals((int)777, (int)target.intField);
        InjectionPreferencesTest.assertEquals((boolean)false, (boolean)target.booleanField);
        InjectionPreferencesTest.assertEquals((int)777, (int)target.intArg);
        InjectionPreferencesTest.assertEquals((boolean)false, (boolean)target.booleanArg);
    }

    public void testAutoConversion() throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.putInt(KEY_INT, 12);
        node.putBoolean(KEY_BOOL, true);
        node.putDouble(KEY_DOUBLE, 12.35345345345);
        node.putFloat(KEY_FLOAT, 5.13f);
        node.putLong(KEY_LONG, 131232343453453L);
        node.flush();
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetConversion target = (InjectTargetConversion)ContextInjectionFactory.make(InjectTargetConversion.class, (IEclipseContext)context);
        InjectionPreferencesTest.assertEquals((Object)new Integer(12), (Object)target.intField);
        InjectionPreferencesTest.assertEquals((Object)new Boolean(true), (Object)target.booleanField);
        InjectionPreferencesTest.assertEquals((Object)new Double(12.35345345345), (Object)target.doubleField);
        InjectionPreferencesTest.assertEquals((Object)new Float(5.13f), (Object)target.floatField);
        InjectionPreferencesTest.assertEquals((Object)new Long(131232343453453L), (Object)target.longField);
        InjectionPreferencesTest.assertEquals((Object)new Integer(12), (Object)target.intArg);
        InjectionPreferencesTest.assertEquals((Object)new Boolean(true), (Object)target.booleanArg);
        node.putInt(KEY_INT, 777);
        node.putBoolean(KEY_BOOL, false);
        InjectionPreferencesTest.assertEquals((Object)new Integer(777), (Object)target.intField);
        InjectionPreferencesTest.assertEquals((Object)new Boolean(false), (Object)target.booleanField);
        InjectionPreferencesTest.assertEquals((Object)new Integer(777), (Object)target.intArg);
        InjectionPreferencesTest.assertEquals((Object)new Boolean(false), (Object)target.booleanArg);
        InjectionPreferencesTest.assertNotNull((Object)target.preferences);
        InjectionPreferencesTest.assertEquals((String)"abc", (String)node.get("testOutValue", null));
    }

    private void setPreference(String key, String value) throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    private void setPreference(String key, String nodePath, String value) throws BackingStoreException {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    public void testPreferencesConstructor() throws BackingStoreException {
        this.setPreference(TEST_PREFS_KEY, "abc");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "123");
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetConstructor target = (InjectTargetConstructor)ContextInjectionFactory.make(InjectTargetConstructor.class, (IEclipseContext)context);
        InjectionPreferencesTest.assertEquals((String)"abc", (String)target.pref);
        InjectionPreferencesTest.assertEquals((String)"123", (String)target.prefNode);
        this.setPreference(TEST_PREFS_KEY, "xyz");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "456");
        InjectionPreferencesTest.assertEquals((String)"abc", (String)target.pref);
        InjectionPreferencesTest.assertEquals((String)"123", (String)target.prefNode);
    }

    static class InjectTarget {
        public int counter = 0;
        public int counterNode = 0;
        public int counterOptional = 0;
        public String pref;
        public String prefNode;
        public String prefOptional1;
        public String prefOptional2;

        InjectTarget() {
        }

        @Inject
        public void setPrefs(@Preference(value="testPreferencesQualifier") String string) {
            ++this.counter;
            this.pref = string;
        }

        @Inject
        public void setPrefsNode(@Preference(value="testPreferencesQualifier", nodePath="org.eclipse.e4.core.tests.ext") String string) {
            ++this.counterNode;
            this.prefNode = string;
        }

        @Inject
        public void setOptionalPrefs(@Optional @Preference(value="something") String string1, @Preference(value="testPreferencesQualifier") String string2) {
            ++this.counterOptional;
            this.prefOptional1 = string1;
            this.prefOptional2 = string2;
        }
    }

    static class InjectTargetConstructor {
        public String pref;
        public String prefNode;

        @Inject
        public InjectTargetConstructor(@Preference(value="testPreferencesQualifier") String string, @Preference(value="testPreferencesQualifier", nodePath="org.eclipse.e4.core.tests.ext") String stringNode) {
            this.pref = string;
            this.prefNode = stringNode;
        }
    }

    static class InjectTargetConversion {
        @Inject
        @Preference(value="testPreferencesInt")
        public Integer intField;
        @Inject
        @Preference(value="testPreferencesBoolean")
        public Boolean booleanField;
        @Inject
        @Preference(value="testPreferencesDouble")
        public Double doubleField;
        @Inject
        @Preference(value="testPreferencesFloat")
        public Float floatField;
        @Inject
        @Preference(value="testPreferencesLong")
        public Long longField;
        public IEclipsePreferences preferences;
        public Integer intArg;
        public Boolean booleanArg;

        InjectTargetConversion() {
        }

        @Inject
        public void set(@Preference(value="testPreferencesInt") Integer intArg, @Preference(value="testPreferencesBoolean") Boolean booleanArg) {
            this.intArg = intArg;
            this.booleanArg = booleanArg;
        }

        @Inject
        public void set2(@Preference IEclipsePreferences prefNode) {
            this.preferences = prefNode;
            prefNode.put("testOutValue", "abc");
        }
    }

    static class InjectTargetPrimitive {
        @Inject
        @Preference(value="testPreferencesInt")
        public int intField;
        @Inject
        @Preference(value="testPreferencesBoolean")
        public boolean booleanField;
        @Inject
        @Preference(value="testPreferencesDouble")
        public double doubleField;
        @Inject
        @Preference(value="testPreferencesFloat")
        public float floatField;
        @Inject
        @Preference(value="testPreferencesLong")
        public long longField;
        public int intArg;
        public boolean booleanArg;

        InjectTargetPrimitive() {
        }

        @Inject
        public void set(@Preference(value="testPreferencesInt") int intArg, @Preference(value="testPreferencesBoolean") boolean booleanArg) {
            this.intArg = intArg;
            this.booleanArg = booleanArg;
        }
    }
}

