/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.nls;

import java.util.Locale;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.eclipse.e4.core.internal.tests.nls.BundleMessages;
import org.eclipse.e4.core.internal.tests.nls.Messages;
import org.eclipse.e4.core.internal.tests.nls.ResourceBundleClassMessages;
import org.eclipse.e4.core.internal.tests.nls.ResourcesMessages;
import org.eclipse.e4.core.internal.tests.nls.SimpleMessages;
import org.eclipse.e4.core.services.nls.Translation;
import org.osgi.framework.BundleContext;

public class NLSTest
extends TestCase {
    private IEclipseContext context;
    private Locale beforeLocale;

    public void setUp() {
        this.context = EclipseContextFactory.getServiceContext((BundleContext)CoreTestsActivator.getDefault().getBundleContext());
        ContextInjectionFactory.setDefault((IEclipseContext)this.context);
        this.beforeLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en"));
    }

    public void tearDown() {
        Locale.setDefault(this.beforeLocale);
    }

    public void testSimpleMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.simpleMessages);
        NLSTest.assertNotNull((Object)o.simpleMessages.message);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_one);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_two);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageFour);
        NLSTest.assertEquals((String)"SimpleMessage", (String)o.simpleMessages.message);
        NLSTest.assertEquals((String)"SimpleMessageUnderscore", (String)o.simpleMessages.message_one);
        NLSTest.assertEquals((String)"SimpleMessageCamelCase", (String)o.simpleMessages.messageOne);
        NLSTest.assertEquals((String)"SimpleMessageUnderscoreDot", (String)o.simpleMessages.message_two);
        NLSTest.assertEquals((String)"SimpleMessageCamelCaseDot", (String)o.simpleMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.simpleMessages.messageFour);
    }

    public void testSimpleMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"de");
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.simpleMessages);
        NLSTest.assertNotNull((Object)o.simpleMessages.message);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_one);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_two);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageFour);
        NLSTest.assertEquals((String)"SimpleNachricht", (String)o.simpleMessages.message);
        NLSTest.assertEquals((String)"SimpleNachrichtUnderscore", (String)o.simpleMessages.message_one);
        NLSTest.assertEquals((String)"SimpleNachrichtCamelCase", (String)o.simpleMessages.messageOne);
        NLSTest.assertEquals((String)"SimpleNachrichtUnderscoreDot", (String)o.simpleMessages.message_two);
        NLSTest.assertEquals((String)"SimpleMessageCamelCaseDot", (String)o.simpleMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.simpleMessages.messageFour);
    }

    public void testSimpleMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.simpleMessages);
        NLSTest.assertNotNull((Object)o.simpleMessages.message);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_one);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_two);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageFour);
        NLSTest.assertEquals((String)"SimpleMessage", (String)o.simpleMessages.message);
        NLSTest.assertEquals((String)"SimpleMessageUnderscore", (String)o.simpleMessages.message_one);
        NLSTest.assertEquals((String)"SimpleMessageCamelCase", (String)o.simpleMessages.messageOne);
        NLSTest.assertEquals((String)"SimpleMessageUnderscoreDot", (String)o.simpleMessages.message_two);
        NLSTest.assertEquals((String)"SimpleMessageCamelCaseDot", (String)o.simpleMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.simpleMessages.messageFour);
    }

    public void testSimpleMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"fr");
        TestSimpleObject o = (TestSimpleObject)ContextInjectionFactory.make(TestSimpleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.simpleMessages);
        NLSTest.assertNotNull((Object)o.simpleMessages.message);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_one);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.simpleMessages.message_two);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.simpleMessages.messageFour);
        NLSTest.assertEquals((String)"SimpleNachricht", (String)o.simpleMessages.message);
        NLSTest.assertEquals((String)"SimpleNachrichtUnderscore", (String)o.simpleMessages.message_one);
        NLSTest.assertEquals((String)"SimpleNachrichtCamelCase", (String)o.simpleMessages.messageOne);
        NLSTest.assertEquals((String)"SimpleNachrichtUnderscoreDot", (String)o.simpleMessages.message_two);
        NLSTest.assertEquals((String)"SimpleMessageCamelCaseDot", (String)o.simpleMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.simpleMessages.messageFour);
    }

    public void testMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.Messages);
        NLSTest.assertNotNull((Object)o.Messages.message);
        NLSTest.assertNotNull((Object)o.Messages.message_one);
        NLSTest.assertNotNull((Object)o.Messages.messageOne);
        NLSTest.assertNotNull((Object)o.Messages.message_two);
        NLSTest.assertNotNull((Object)o.Messages.messageThree);
        NLSTest.assertNotNull((Object)o.Messages.messageFour);
        NLSTest.assertEquals((String)"Message", (String)o.Messages.message);
        NLSTest.assertEquals((String)"MessageUnderscore", (String)o.Messages.message_one);
        NLSTest.assertEquals((String)"MessageCamelCase", (String)o.Messages.messageOne);
        NLSTest.assertEquals((String)"MessageUnderscoreDot", (String)o.Messages.message_two);
        NLSTest.assertEquals((String)"MessageCamelCaseDot", (String)o.Messages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.Messages.messageFour);
    }

    public void testMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"de");
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.Messages);
        NLSTest.assertNotNull((Object)o.Messages.message);
        NLSTest.assertNotNull((Object)o.Messages.message_one);
        NLSTest.assertNotNull((Object)o.Messages.messageOne);
        NLSTest.assertNotNull((Object)o.Messages.message_two);
        NLSTest.assertNotNull((Object)o.Messages.messageThree);
        NLSTest.assertNotNull((Object)o.Messages.messageFour);
        NLSTest.assertEquals((String)"Nachricht", (String)o.Messages.message);
        NLSTest.assertEquals((String)"NachrichtUnderscore", (String)o.Messages.message_one);
        NLSTest.assertEquals((String)"NachrichtCamelCase", (String)o.Messages.messageOne);
        NLSTest.assertEquals((String)"NachrichtUnderscoreDot", (String)o.Messages.message_two);
        NLSTest.assertEquals((String)"MessageCamelCaseDot", (String)o.Messages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.Messages.messageFour);
    }

    public void testMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.Messages);
        NLSTest.assertNotNull((Object)o.Messages.message);
        NLSTest.assertNotNull((Object)o.Messages.message_one);
        NLSTest.assertNotNull((Object)o.Messages.messageOne);
        NLSTest.assertNotNull((Object)o.Messages.message_two);
        NLSTest.assertNotNull((Object)o.Messages.messageThree);
        NLSTest.assertNotNull((Object)o.Messages.messageFour);
        NLSTest.assertEquals((String)"Message", (String)o.Messages.message);
        NLSTest.assertEquals((String)"MessageUnderscore", (String)o.Messages.message_one);
        NLSTest.assertEquals((String)"MessageCamelCase", (String)o.Messages.messageOne);
        NLSTest.assertEquals((String)"MessageUnderscoreDot", (String)o.Messages.message_two);
        NLSTest.assertEquals((String)"MessageCamelCaseDot", (String)o.Messages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.Messages.messageFour);
    }

    public void testMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"fr");
        TestMessagesObject o = (TestMessagesObject)ContextInjectionFactory.make(TestMessagesObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.Messages);
        NLSTest.assertNotNull((Object)o.Messages.message);
        NLSTest.assertNotNull((Object)o.Messages.message_one);
        NLSTest.assertNotNull((Object)o.Messages.messageOne);
        NLSTest.assertNotNull((Object)o.Messages.message_two);
        NLSTest.assertNotNull((Object)o.Messages.messageThree);
        NLSTest.assertNotNull((Object)o.Messages.messageFour);
        NLSTest.assertEquals((String)"Nachricht", (String)o.Messages.message);
        NLSTest.assertEquals((String)"NachrichtUnderscore", (String)o.Messages.message_one);
        NLSTest.assertEquals((String)"NachrichtCamelCase", (String)o.Messages.messageOne);
        NLSTest.assertEquals((String)"NachrichtUnderscoreDot", (String)o.Messages.message_two);
        NLSTest.assertEquals((String)"MessageCamelCaseDot", (String)o.Messages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.Messages.messageFour);
    }

    public void testBundleMessages() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleMessages);
        NLSTest.assertNotNull((Object)o.bundleMessages.message);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageFour);
        NLSTest.assertEquals((String)"BundleMessage", (String)o.bundleMessages.message);
        NLSTest.assertEquals((String)"BundleMessageUnderscore", (String)o.bundleMessages.message_one);
        NLSTest.assertEquals((String)"BundleMessageCamelCase", (String)o.bundleMessages.messageOne);
        NLSTest.assertEquals((String)"BundleMessageUnderscoreDot", (String)o.bundleMessages.message_two);
        NLSTest.assertEquals((String)"BundleMessageCamelCaseDot", (String)o.bundleMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.bundleMessages.messageFour);
    }

    public void testBundleMessagesDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"de");
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleMessages);
        NLSTest.assertNotNull((Object)o.bundleMessages.message);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageFour);
        NLSTest.assertEquals((String)"BundleNachricht", (String)o.bundleMessages.message);
        NLSTest.assertEquals((String)"BundleNachrichtUnderscore", (String)o.bundleMessages.message_one);
        NLSTest.assertEquals((String)"BundleNachrichtCamelCase", (String)o.bundleMessages.messageOne);
        NLSTest.assertEquals((String)"BundleNachrichtUnderscoreDot", (String)o.bundleMessages.message_two);
        NLSTest.assertEquals((String)"BundleMessageCamelCaseDot", (String)o.bundleMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.bundleMessages.messageFour);
    }

    public void testBundleMessagesSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleMessages);
        NLSTest.assertNotNull((Object)o.bundleMessages.message);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageFour);
        NLSTest.assertEquals((String)"BundleMessage", (String)o.bundleMessages.message);
        NLSTest.assertEquals((String)"BundleMessageUnderscore", (String)o.bundleMessages.message_one);
        NLSTest.assertEquals((String)"BundleMessageCamelCase", (String)o.bundleMessages.messageOne);
        NLSTest.assertEquals((String)"BundleMessageUnderscoreDot", (String)o.bundleMessages.message_two);
        NLSTest.assertEquals((String)"BundleMessageCamelCaseDot", (String)o.bundleMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.bundleMessages.messageFour);
    }

    public void testBundleMessagesUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"fr");
        TestBundleObject o = (TestBundleObject)ContextInjectionFactory.make(TestBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleMessages);
        NLSTest.assertNotNull((Object)o.bundleMessages.message);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleMessages.messageFour);
        NLSTest.assertEquals((String)"BundleNachricht", (String)o.bundleMessages.message);
        NLSTest.assertEquals((String)"BundleNachrichtUnderscore", (String)o.bundleMessages.message_one);
        NLSTest.assertEquals((String)"BundleNachrichtCamelCase", (String)o.bundleMessages.messageOne);
        NLSTest.assertEquals((String)"BundleNachrichtUnderscoreDot", (String)o.bundleMessages.message_two);
        NLSTest.assertEquals((String)"BundleMessageCamelCaseDot", (String)o.bundleMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.bundleMessages.messageFour);
    }

    public void testClassBasedResourceBundle() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleClassMessages);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageFour);
        NLSTest.assertEquals((String)"ResourceBundleClassMessage", (String)o.bundleClassMessages.message);
        NLSTest.assertEquals((String)"ResourceBundleClassMessageUnderscore", (String)o.bundleClassMessages.message_one);
        NLSTest.assertEquals((String)"ResourceBundleClassMessageCamelCase", (String)o.bundleClassMessages.messageOne);
        NLSTest.assertEquals((String)"ResourceBundleClassMessageUnderscoreDot", (String)o.bundleClassMessages.message_two);
        NLSTest.assertEquals((String)"ResourceBundleClassCamelCaseDot", (String)o.bundleClassMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.bundleClassMessages.messageFour);
    }

    public void testClassBasedResourceBundleDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"de");
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleClassMessages);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageFour);
        NLSTest.assertEquals((String)"ResourceBundleClassNachricht", (String)o.bundleClassMessages.message);
        NLSTest.assertEquals((String)"ResourceBundleClassNachrichtUnderscore", (String)o.bundleClassMessages.message_one);
        NLSTest.assertEquals((String)"ResourceBundleClassNachrichtCamelCase", (String)o.bundleClassMessages.messageOne);
        NLSTest.assertEquals((String)"ResourceBundleNachrichtMessageUnderscoreDot", (String)o.bundleClassMessages.message_two);
        NLSTest.assertEquals((String)"ResourceBundleClassCamelCaseDot", (String)o.bundleClassMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.bundleClassMessages.messageFour);
    }

    public void testClassBasedResourceBundleSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleClassMessages);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageFour);
        NLSTest.assertEquals((String)"ResourceBundleClassMessage", (String)o.bundleClassMessages.message);
        NLSTest.assertEquals((String)"ResourceBundleClassMessageUnderscore", (String)o.bundleClassMessages.message_one);
        NLSTest.assertEquals((String)"ResourceBundleClassMessageCamelCase", (String)o.bundleClassMessages.messageOne);
        NLSTest.assertEquals((String)"ResourceBundleClassMessageUnderscoreDot", (String)o.bundleClassMessages.message_two);
        NLSTest.assertEquals((String)"ResourceBundleClassCamelCaseDot", (String)o.bundleClassMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.bundleClassMessages.messageFour);
    }

    public void testClassBasedResourceBundleUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"fr");
        TestResourceBundleClassObject o = (TestResourceBundleClassObject)ContextInjectionFactory.make(TestResourceBundleClassObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.bundleClassMessages);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_one);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageOne);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.message_two);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageThree);
        NLSTest.assertNotNull((Object)o.bundleClassMessages.messageFour);
        NLSTest.assertEquals((String)"ResourceBundleClassNachricht", (String)o.bundleClassMessages.message);
        NLSTest.assertEquals((String)"ResourceBundleClassNachrichtUnderscore", (String)o.bundleClassMessages.message_one);
        NLSTest.assertEquals((String)"ResourceBundleClassNachrichtCamelCase", (String)o.bundleClassMessages.messageOne);
        NLSTest.assertEquals((String)"ResourceBundleNachrichtMessageUnderscoreDot", (String)o.bundleClassMessages.message_two);
        NLSTest.assertEquals((String)"ResourceBundleClassCamelCaseDot", (String)o.bundleClassMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.bundleClassMessages.messageFour);
    }

    public void testResourcesBundle() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.resourcesMessages);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_one);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageOne);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_two);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageThree);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageFour);
        NLSTest.assertEquals((String)"ResourcesMessage", (String)o.resourcesMessages.message);
        NLSTest.assertEquals((String)"ResourcesMessageUnderscore", (String)o.resourcesMessages.message_one);
        NLSTest.assertEquals((String)"ResourcesMessageCamelCase", (String)o.resourcesMessages.messageOne);
        NLSTest.assertEquals((String)"ResourcesMessageUnderscoreDot", (String)o.resourcesMessages.message_two);
        NLSTest.assertEquals((String)"ResourcesMessageCamelCaseDot", (String)o.resourcesMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.resourcesMessages.messageFour);
    }

    public void testResourcesBundleDifferentLocale() {
        this.context.set("org.eclipse.e4.core.locale", (Object)"de");
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.resourcesMessages);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_one);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageOne);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_two);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageThree);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageFour);
        NLSTest.assertEquals((String)"ResourceNachricht", (String)o.resourcesMessages.message);
        NLSTest.assertEquals((String)"ResourceNachrichtUnderscore", (String)o.resourcesMessages.message_one);
        NLSTest.assertEquals((String)"ResourceNachrichtCamelCase", (String)o.resourcesMessages.messageOne);
        NLSTest.assertEquals((String)"ResourceNachrichtUnderscoreDot", (String)o.resourcesMessages.message_two);
        NLSTest.assertEquals((String)"ResourcesMessageCamelCaseDot", (String)o.resourcesMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.resourcesMessages.messageFour);
    }

    public void testResourcesBundleSkipDefaultLocaleForEquinoxRoot() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"en");
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.resourcesMessages);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_one);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageOne);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_two);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageThree);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageFour);
        NLSTest.assertEquals((String)"ResourcesMessage", (String)o.resourcesMessages.message);
        NLSTest.assertEquals((String)"ResourcesMessageUnderscore", (String)o.resourcesMessages.message_one);
        NLSTest.assertEquals((String)"ResourcesMessageCamelCase", (String)o.resourcesMessages.messageOne);
        NLSTest.assertEquals((String)"ResourcesMessageUnderscoreDot", (String)o.resourcesMessages.message_two);
        NLSTest.assertEquals((String)"ResourcesMessageCamelCaseDot", (String)o.resourcesMessages.messageThree);
        NLSTest.assertEquals((String)"The idea is from Tom", (String)o.resourcesMessages.messageFour);
    }

    public void testResourcesBundleUseDefaultLocaleForInvalidLocale() {
        Locale.setDefault(new Locale("de"));
        this.context.set("org.eclipse.e4.core.locale", (Object)"fr");
        TestResourcesBundleObject o = (TestResourcesBundleObject)ContextInjectionFactory.make(TestResourcesBundleObject.class, (IEclipseContext)this.context);
        NLSTest.assertNotNull((Object)o.resourcesMessages);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_one);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageOne);
        NLSTest.assertNotNull((Object)o.resourcesMessages.message_two);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageThree);
        NLSTest.assertNotNull((Object)o.resourcesMessages.messageFour);
        NLSTest.assertEquals((String)"ResourceNachricht", (String)o.resourcesMessages.message);
        NLSTest.assertEquals((String)"ResourceNachrichtUnderscore", (String)o.resourcesMessages.message_one);
        NLSTest.assertEquals((String)"ResourceNachrichtCamelCase", (String)o.resourcesMessages.messageOne);
        NLSTest.assertEquals((String)"ResourceNachrichtUnderscoreDot", (String)o.resourcesMessages.message_two);
        NLSTest.assertEquals((String)"ResourcesMessageCamelCaseDot", (String)o.resourcesMessages.messageThree);
        NLSTest.assertEquals((String)"Die Idee ist von Tom", (String)o.resourcesMessages.messageFour);
    }

    static class TestBundleObject {
        @Inject
        @Translation
        BundleMessages bundleMessages;

        TestBundleObject() {
        }
    }

    static class TestMessagesObject {
        @Inject
        @Translation
        Messages Messages;

        TestMessagesObject() {
        }
    }

    static class TestResourceBundleClassObject {
        @Inject
        @Translation
        ResourceBundleClassMessages bundleClassMessages;

        TestResourceBundleClassObject() {
        }
    }

    static class TestResourcesBundleObject {
        @Inject
        @Translation
        ResourcesMessages resourcesMessages;

        TestResourcesBundleObject() {
        }
    }

    static class TestSimpleObject {
        @Inject
        @Translation
        SimpleMessages simpleMessages;

        TestSimpleObject() {
        }
    }
}

