/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.e4.ui.bindings.tests.Activator;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;

public class BindingTableTests
extends TestCase {
    private static final String ID_DIALOG = "org.eclipse.ui.contexts.dialog";
    private static final String ID_DIALOG_AND_WINDOW = "org.eclipse.ui.contexts.dialogAndWindow";
    private static final String ID_WINDOW = "org.eclipse.ui.contexts.window";
    private static final String ID_TEXT = "org.eclipse.ui.textScope";
    private static final String ID_JAVA = "org.eclipse.jdt.ui.javaScope";
    private static final String ID_JS = "org.eclipse.wst.jsdt.ui.javaScriptScope";
    private static final String ABOUT_ID = "org.eclipse.ui.help.aboutAction";
    private static final String EXIT_ID = "org.eclipse.ui.file.exit";
    private static final String REFRESH_ID = "org.eclipse.ui.file.refresh";
    private static final String PASTE_ID = "org.eclipse.ui.edit.paste";
    private static final String CUT_ID = "org.eclipse.ui.edit.cut";
    private static final String COPY_ID = "org.eclipse.ui.edit.copy";
    private static final String TAG_ID = "org.eclipse.ui.text.wordCompletion";
    private static final String RENAME_ID = "org.eclipse.ui.file.rename";
    private static final String SHOW_TOOLTIP_ID = "org.eclipse.ui.text.showToolTip";
    private static final String CORR_INDENT_ID = "org.eclipse.jdt.ui.correctIndentation";
    private static final String INDENT_LINE_ID = "org.eclipse.wst.jsdt.ui.indentLine";
    static final String[] CONTEXTS;
    static final String[] ORDERED_IDS;
    static final String[] COMMANDS;
    static final String[] BINDINGS;
    static ArrayList<Binding> loadedBindings;
    static CommandManager commandManager;
    static ContextManager contextManager;
    static IEclipseContext workbenchContext;

    static {
        String[] stringArray = new String[18];
        stringArray[0] = ID_DIALOG_AND_WINDOW;
        stringArray[1] = "DAW";
        stringArray[3] = ID_DIALOG;
        stringArray[4] = "Dialog";
        stringArray[5] = ID_DIALOG_AND_WINDOW;
        stringArray[6] = ID_WINDOW;
        stringArray[7] = "Window";
        stringArray[8] = ID_DIALOG_AND_WINDOW;
        stringArray[9] = ID_TEXT;
        stringArray[10] = "Text Scope";
        stringArray[11] = ID_WINDOW;
        stringArray[12] = ID_JAVA;
        stringArray[13] = "Java scope";
        stringArray[14] = ID_TEXT;
        stringArray[15] = ID_JS;
        stringArray[16] = "JavaScript scope";
        stringArray[17] = ID_TEXT;
        CONTEXTS = stringArray;
        ORDERED_IDS = new String[]{ID_DIALOG_AND_WINDOW, ID_DIALOG, ID_WINDOW, ID_TEXT, ID_JAVA, ID_JS};
        COMMANDS = new String[]{COPY_ID, "Copy", CUT_ID, "Cut", PASTE_ID, "Paste", REFRESH_ID, "Refresh", EXIT_ID, "Exit", ABOUT_ID, "About", TAG_ID, "Word Completion", RENAME_ID, "Rename", SHOW_TOOLTIP_ID, "Show Tooltip Description", CORR_INDENT_ID, "Correct Indentation", INDENT_LINE_ID, "Indent Line"};
        BINDINGS = new String[]{COPY_ID, "M1+C", ID_WINDOW, CUT_ID, "M1+X", ID_WINDOW, PASTE_ID, "M1+V", ID_WINDOW, REFRESH_ID, "F5", ID_DIALOG_AND_WINDOW, EXIT_ID, "CTRL+Q", ID_DIALOG_AND_WINDOW, ABOUT_ID, "CTRL+5 A", ID_DIALOG_AND_WINDOW, TAG_ID, "ALT+/", ID_TEXT, RENAME_ID, "F2", ID_WINDOW, SHOW_TOOLTIP_ID, "F2", ID_TEXT, CORR_INDENT_ID, "CTRL+I", ID_JAVA, INDENT_LINE_ID, "CTRL+I", ID_JS, PASTE_ID, "SHIFT+Insert", ID_WINDOW, PASTE_ID, "CTRL+5 V", ID_TEXT};
        loadedBindings = null;
        commandManager = null;
        contextManager = null;
    }

    protected void setUp() throws Exception {
        if (loadedBindings == null) {
            IEclipseContext globalContext = Activator.getDefault().getGlobalContext();
            workbenchContext = globalContext.createChild("workbenchContext");
            loadedBindings = new ArrayList();
            contextManager = new ContextManager();
            ContextSet.setComparator((Comparator)new ContextSet.CComp(contextManager));
            int i = 0;
            while (i < CONTEXTS.length) {
                Context context = contextManager.getContext(CONTEXTS[i]);
                context.define(CONTEXTS[i + 1], null, CONTEXTS[i + 2]);
                i += 3;
            }
            commandManager = new CommandManager();
            Category category = commandManager.getCategory("bogus");
            category.define("Bogus", null);
            int i2 = 0;
            while (i2 < COMMANDS.length) {
                Command cmd = commandManager.getCommand(COMMANDS[i2]);
                cmd.define(COMMANDS[i2 + 1], null, category);
                i2 += 2;
            }
            i2 = 0;
            while (i2 < BINDINGS.length) {
                KeySequence seq = KeySequence.getInstance((String)BINDINGS[i2 + 1]);
                Command cmd = commandManager.getCommand(BINDINGS[i2]);
                loadedBindings.add((Binding)new KeyBinding(seq, new ParameterizedCommand(cmd, null), "org.eclipse.ui.defaultAcceleratorConfiguration", BINDINGS[i2 + 2], null, null, null, 0));
                i2 += 3;
            }
        }
    }

    public void testOneTable() throws Exception {
        Binding about = this.getTestBinding(ABOUT_ID);
        KeySequence aboutSeq = KeySequence.getInstance((String)"CTRL+5 A");
        KeySequence prefix = KeySequence.getInstance((String)"CTRL+5");
        BindingTable table = this.loadTable(ID_DIALOG_AND_WINDOW);
        BindingTableTests.assertNotNull((Object)about);
        Binding match = table.getPerfectMatch((TriggerSequence)aboutSeq);
        BindingTableTests.assertEquals((Object)about, (Object)match);
        BindingTableTests.assertEquals((Object)aboutSeq, (Object)table.getBestSequenceFor(about.getParameterizedCommand()).getTriggerSequence());
        Collection sequences = table.getSequencesFor(about.getParameterizedCommand());
        BindingTableTests.assertEquals((int)1, (int)sequences.size());
        BindingTableTests.assertEquals((Object)aboutSeq, (Object)((Binding)((ArrayList)sequences).get(0)).getTriggerSequence());
        Collection partialMatches = table.getPartialMatches((TriggerSequence)prefix);
        BindingTableTests.assertEquals((int)1, (int)partialMatches.size());
        BindingTableTests.assertEquals((Object)about, ((ArrayList)partialMatches).get(0));
    }

    public void testTwoKeysOneCommand() throws Exception {
        BindingTable table = this.loadTable(ID_WINDOW);
        Binding paste = this.getTestBinding(PASTE_ID);
        ParameterizedCommand pasteCmd = paste.getParameterizedCommand();
        KeySequence ctrlV = KeySequence.getInstance((String)"M1+V");
        KeySequence shiftIns = KeySequence.getInstance((String)"Shift+Insert");
        Binding match1 = table.getPerfectMatch((TriggerSequence)ctrlV);
        BindingTableTests.assertEquals((Object)pasteCmd, (Object)match1.getParameterizedCommand());
        Binding match2 = table.getPerfectMatch((TriggerSequence)shiftIns);
        BindingTableTests.assertFalse((match1 == match2 ? 1 : 0) != 0);
        BindingTableTests.assertEquals((Object)pasteCmd, (Object)match2.getParameterizedCommand());
    }

    public void testLookupShortcut() throws Exception {
        BindingTable table = this.loadTable(ID_WINDOW);
        Binding paste = this.getTestBinding(PASTE_ID);
        Binding match = table.getBestSequenceFor(paste.getParameterizedCommand());
        BindingTableTests.assertEquals((Object)paste, (Object)match);
    }

    public void testLookupShortcuts() throws Exception {
        BindingTable table = this.loadTable(ID_WINDOW);
        Binding paste = this.getTestBinding(PASTE_ID);
        Collection sequences = table.getSequencesFor(paste.getParameterizedCommand());
        BindingTableTests.assertEquals((int)2, (int)sequences.size());
        KeySequence second = KeySequence.getInstance((String)"SHIFT+INSERT");
        Iterator it = sequences.iterator();
        BindingTableTests.assertEquals((Object)paste.getTriggerSequence(), (Object)((Binding)it.next()).getTriggerSequence());
        BindingTableTests.assertEquals((Object)second, (Object)((Binding)it.next()).getTriggerSequence());
    }

    public void testPartialMatch() throws Exception {
        BindingTable table = this.loadTable(ID_DIALOG_AND_WINDOW);
        KeySequence ctrl5 = KeySequence.getInstance((String)"CTRL+5");
        KeySequence ctrl8 = KeySequence.getInstance((String)"CTRL+8");
        BindingTableTests.assertTrue((boolean)table.isPartialMatch((TriggerSequence)ctrl5));
        BindingTableTests.assertFalse((boolean)table.isPartialMatch((TriggerSequence)ctrl8));
    }

    public void testContextSet() throws Exception {
        BindingTableManager manager = (BindingTableManager)ContextInjectionFactory.make(BindingTableManager.class, (IEclipseContext)workbenchContext);
        ArrayList<Context> window = new ArrayList<Context>();
        Context winContext = contextManager.getContext(ID_WINDOW);
        Context dawContext = contextManager.getContext(ID_DIALOG_AND_WINDOW);
        window.add(winContext);
        window.add(dawContext);
        ContextSet windowSet = manager.createContextSet(window);
        this.assertContextSet(windowSet, new String[]{ID_DIALOG_AND_WINDOW, ID_WINDOW});
        ArrayList<Context> text = new ArrayList<Context>(window);
        Context textContext = contextManager.getContext(ID_TEXT);
        text.add(textContext);
        ContextSet textSet = manager.createContextSet(text);
        this.assertContextSet(textSet, new String[]{ID_DIALOG_AND_WINDOW, ID_WINDOW, ID_TEXT});
    }

    public void testContextSetSibling() throws Exception {
        BindingTableManager manager = (BindingTableManager)ContextInjectionFactory.make(BindingTableManager.class, (IEclipseContext)workbenchContext);
        ArrayList<Context> all = new ArrayList<Context>();
        int i = 0;
        while (i < CONTEXTS.length) {
            Context context = contextManager.getContext(CONTEXTS[i]);
            all.add(context);
            i += 3;
        }
        ContextSet set = manager.createContextSet(all);
        this.assertContextSet(set, ORDERED_IDS);
    }

    public void testSingleParentChainPerfectMatch() throws Exception {
        BindingTableManager manager = (BindingTableManager)ContextInjectionFactory.make(BindingTableManager.class, (IEclipseContext)workbenchContext);
        manager.addTable(this.loadTable(ID_DIALOG_AND_WINDOW));
        manager.addTable(this.loadTable(ID_WINDOW));
        manager.addTable(this.loadTable(ID_TEXT));
        ArrayList<Context> window = new ArrayList<Context>();
        Context winContext = contextManager.getContext(ID_WINDOW);
        Context dawContext = contextManager.getContext(ID_DIALOG_AND_WINDOW);
        window.add(winContext);
        window.add(dawContext);
        ContextSet windowSet = manager.createContextSet(window);
        ArrayList<Context> text = new ArrayList<Context>(window);
        Context textContext = contextManager.getContext(ID_TEXT);
        text.add(textContext);
        ContextSet textSet = manager.createContextSet(text);
        Binding rename = this.getTestBinding(RENAME_ID);
        BindingTableTests.assertNotNull((Object)rename);
        Binding showTooltip = this.getTestBinding(SHOW_TOOLTIP_ID);
        BindingTableTests.assertNotNull((Object)showTooltip);
        Binding match = manager.getPerfectMatch(windowSet, rename.getTriggerSequence());
        BindingTableTests.assertEquals((Object)rename, (Object)match);
        match = manager.getPerfectMatch(textSet, rename.getTriggerSequence());
        BindingTableTests.assertEquals((Object)showTooltip, (Object)match);
        Binding about = this.getTestBinding(ABOUT_ID);
        match = manager.getPerfectMatch(textSet, about.getTriggerSequence());
        BindingTableTests.assertEquals((Object)about, (Object)match);
    }

    public void testSiblingsPerfectMatch() throws Exception {
        BindingTableManager manager = this.createManager();
        Binding correctIndent = this.getTestBinding(CORR_INDENT_ID);
        Binding indentLine = this.getTestBinding(INDENT_LINE_ID);
        BindingTableTests.assertEquals((Object)correctIndent.getTriggerSequence(), (Object)indentLine.getTriggerSequence());
        ArrayList<Context> all = new ArrayList<Context>();
        int i = 0;
        while (i < CONTEXTS.length) {
            Context context = contextManager.getContext(CONTEXTS[i]);
            all.add(context);
            i += 3;
        }
        ContextSet set = manager.createContextSet(all);
        Binding match = manager.getPerfectMatch(set, correctIndent.getTriggerSequence());
        BindingTableTests.assertEquals((Object)indentLine, (Object)match);
    }

    public void testOneSiblingAtATimePerfectMatch() throws Exception {
        BindingTableManager manager = this.createManager();
        Binding correctIndent = this.getTestBinding(CORR_INDENT_ID);
        Binding indentLine = this.getTestBinding(INDENT_LINE_ID);
        BindingTableTests.assertEquals((Object)correctIndent.getTriggerSequence(), (Object)indentLine.getTriggerSequence());
        ContextSet javaSet = this.createJavaSet(manager);
        ArrayList<Context> jsList = new ArrayList<Context>();
        int i = 0;
        while (i < CONTEXTS.length) {
            Context context = contextManager.getContext(CONTEXTS[i]);
            if (!ID_JAVA.equals(context.getId())) {
                jsList.add(context);
            }
            i += 3;
        }
        ContextSet jsSet = manager.createContextSet(jsList);
        Binding match = manager.getPerfectMatch(javaSet, correctIndent.getTriggerSequence());
        BindingTableTests.assertEquals((Object)correctIndent, (Object)match);
        match = manager.getPerfectMatch(jsSet, correctIndent.getTriggerSequence());
        BindingTableTests.assertEquals((Object)indentLine, (Object)match);
    }

    public void testManagerLookupShortcut() throws Exception {
        BindingTableManager manager = this.createManager();
        Binding paste = this.getTestBinding(PASTE_ID);
        ArrayList<Context> window = new ArrayList<Context>();
        Context winContext = contextManager.getContext(ID_WINDOW);
        Context dawContext = contextManager.getContext(ID_DIALOG_AND_WINDOW);
        window.add(winContext);
        window.add(dawContext);
        ContextSet windowSet = manager.createContextSet(window);
        Binding match = manager.getBestSequenceFor(windowSet, paste.getParameterizedCommand());
        BindingTableTests.assertEquals((Object)paste, (Object)match);
    }

    public void testManagerLookupShortcutLongChain() throws Exception {
        BindingTableManager manager = this.createManager();
        Binding paste = this.getTestBinding(PASTE_ID);
        ContextSet javaSet = this.createJavaSet(manager);
        Binding match = manager.getBestSequenceFor(javaSet, paste.getParameterizedCommand());
        BindingTableTests.assertEquals((Object)paste, (Object)match);
    }

    public void testManagerLookupAllShortcuts() throws Exception {
        BindingTableManager manager = this.createManager();
        Binding paste = this.getTestBinding(PASTE_ID);
        ContextSet javaSet = this.createJavaSet(manager);
        Collection sequences = manager.getSequencesFor(javaSet, paste.getParameterizedCommand());
        BindingTableTests.assertEquals((int)3, (int)sequences.size());
        KeySequence second = KeySequence.getInstance((String)"SHIFT+INSERT");
        KeySequence third = KeySequence.getInstance((String)"CTRL+5 V");
        Iterator it = sequences.iterator();
        BindingTableTests.assertEquals((Object)paste.getTriggerSequence(), (Object)((Binding)it.next()).getTriggerSequence());
        BindingTableTests.assertEquals((Object)second, (Object)((Binding)it.next()).getTriggerSequence());
        BindingTableTests.assertEquals((Object)third, (Object)((Binding)it.next()).getTriggerSequence());
    }

    public void testManagerPartialMatch() throws Exception {
        BindingTableManager manager = this.createManager();
        Binding about = this.getTestBinding(ABOUT_ID);
        Binding paste = this.getTestBinding(PASTE_ID);
        ContextSet javaSet = this.createJavaSet(manager);
        Binding pasteCtrl5 = manager.getPerfectMatch(javaSet, (TriggerSequence)KeySequence.getInstance((String)"CTRL+5 V"));
        BindingTableTests.assertEquals((Object)paste.getParameterizedCommand(), (Object)pasteCtrl5.getParameterizedCommand());
        KeySequence ctrl5 = KeySequence.getInstance((String)"CTRL+5");
        KeySequence ctrl8 = KeySequence.getInstance((String)"CTRL+8");
        BindingTableTests.assertTrue((boolean)manager.isPartialMatch(javaSet, (TriggerSequence)ctrl5));
        BindingTableTests.assertFalse((boolean)manager.isPartialMatch(javaSet, (TriggerSequence)ctrl8));
        Collection partialMatches = manager.getPartialMatches(javaSet, (TriggerSequence)ctrl5);
        BindingTableTests.assertEquals((int)2, (int)partialMatches.size());
        Iterator it = partialMatches.iterator();
        BindingTableTests.assertEquals((Object)pasteCtrl5, it.next());
        BindingTableTests.assertEquals((Object)about, it.next());
    }

    private BindingTable loadTable(String contextId) {
        Context context = contextManager.getContext(contextId);
        BindingTable table = new BindingTable(context);
        for (Binding b : loadedBindings) {
            if (!context.getId().equals(b.getContextId())) continue;
            table.addBinding(b);
        }
        return table;
    }

    private Binding getTestBinding(String commandId) {
        for (Binding binding : loadedBindings) {
            if (!commandId.equals(binding.getParameterizedCommand().getId())) continue;
            return binding;
        }
        return null;
    }

    private void assertContextSet(ContextSet set, String[] contextIds) {
        List contexts = set.getContexts();
        BindingTableTests.assertEquals((String)contexts.toString(), (int)contextIds.length, (int)contexts.size());
        int i = 0;
        while (i < contextIds.length) {
            BindingTableTests.assertEquals((String)contextIds[i], (String)((Context)contexts.get(i)).getId());
            ++i;
        }
    }

    private BindingTableManager createManager() throws Exception {
        BindingTableManager manager = (BindingTableManager)ContextInjectionFactory.make(BindingTableManager.class, (IEclipseContext)workbenchContext);
        int i = 0;
        while (i < CONTEXTS.length) {
            manager.addTable(this.loadTable(CONTEXTS[i]));
            i += 3;
        }
        return manager;
    }

    private ContextSet createJavaSet(BindingTableManager manager) {
        ArrayList<Context> javaList = new ArrayList<Context>();
        int i = 0;
        while (i < CONTEXTS.length) {
            if (!CONTEXTS[i].equals(ID_JS) && !CONTEXTS[i].equals(ID_DIALOG)) {
                Context context = contextManager.getContext(CONTEXTS[i]);
                javaList.add(context);
            }
            i += 3;
        }
        return manager.createContextSet(javaList);
    }
}

