/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class ImportTest
extends TestCase {
    private CSSEngine engine;

    protected void setUp() throws Exception {
        this.engine = ParserTestUtil.createEngine();
    }

    public void testOverrideImportedRule() throws Exception {
        String importedCss = ".ClassAlpha {\n     property: value;\n  }\n  .ClassBeta {\n     property: value1;\n  }";
        File importedFile = this.createTempCssFile(importedCss);
        String importedFileName = importedFile.getName();
        String importedFilePath = importedFile.getParent();
        String importingCss = "@import url('" + importedFileName + "');\n" + "  .ClassBeta {\n" + "     property: value2;\n" + "  }";
        String importingUrl = "file:///" + importedFilePath + "/importing.css";
        ViewCSS viewCSS = this.createViewCss(importingUrl, importingCss);
        TestElement buttonAlpha = new TestElement("Button", this.engine);
        buttonAlpha.setClass("ClassAlpha");
        TestElement buttonBeta = new TestElement("Button", this.engine);
        buttonBeta.setClass("ClassBeta");
        CSSStyleDeclaration styleAlpha = viewCSS.getComputedStyle((Element)((Object)buttonAlpha), null);
        CSSStyleDeclaration styleBeta = viewCSS.getComputedStyle((Element)((Object)buttonBeta), null);
        ImportTest.assertEquals((String)"value", (String)styleAlpha.getPropertyCSSValue("property").getCssText());
        ImportTest.assertEquals((String)"value2", (String)styleBeta.getPropertyCSSValue("property").getCssText());
    }

    private File createTempCssFile(String cssString) throws Exception {
        File file;
        File result = File.createTempFile("e4.ui.tests-", ".css");
        FileWriter fileWriter = new FileWriter(result);
        try {
            fileWriter.write(cssString);
            file = result;
        }
        catch (Throwable throwable) {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    private ViewCSS createViewCss(String sourceUrl, String cssString) throws IOException {
        InputSource source = new InputSource();
        source.setURI(sourceUrl);
        source.setCharacterStream((Reader)new StringReader(cssString));
        StyleSheet styleSheet = this.engine.parseStyleSheet(source);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet(styleSheet);
        return new ViewCSSImpl((DocumentCSS)docCss);
    }
}

