/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class ViewCSSTest
extends TestCase {
    private Display display;
    private CSSSWTEngineImpl engine;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
        this.engine = new CSSSWTEngineImpl(this.display);
    }

    public void testGetComputedStyle() throws Exception {
        String css = "Label { color: black; }Button { color: blue; font-weight: bold; }\nButton { color: green; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        CSSStyleDeclaration shellStyle = viewCSS.getComputedStyle((Element)((Object)shell), null);
        ViewCSSTest.assertNull((Object)shellStyle);
        TestElement label = new TestElement("Label", (CSSEngine)this.engine);
        CSSStyleDeclaration labelStyle = viewCSS.getComputedStyle((Element)((Object)label), null);
        ViewCSSTest.assertNotNull((Object)labelStyle);
        ViewCSSTest.assertEquals((int)1, (int)labelStyle.getLength());
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        ViewCSSTest.assertNotNull((Object)buttonStyle);
        ViewCSSTest.assertEquals((int)2, (int)buttonStyle.getLength());
    }

    public void testBug419482_order1() throws Exception {
        String css = "Shell > * > * { color: red; }\nButton { color: blue; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, this.engine);
        TestElement button = new TestElement("Button", composite, this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        ViewCSSTest.assertNotNull((Object)buttonStyle);
        ViewCSSTest.assertEquals((int)1, (int)buttonStyle.getLength());
        ViewCSSTest.assertEquals((String)"color: blue;", (String)buttonStyle.getCssText());
    }

    public void testBug419482_order2() throws Exception {
        String css = "Button { color: blue; }\nShell > * > * { color: red; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, this.engine);
        TestElement button = new TestElement("Button", composite, this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        ViewCSSTest.assertNotNull((Object)buttonStyle);
        ViewCSSTest.assertEquals((int)1, (int)buttonStyle.getLength());
        ViewCSSTest.assertEquals((String)"color: red;", (String)buttonStyle.getCssText());
    }

    public void testBug419482_higherSpecificity() throws Exception {
        String css = "Shell > * > Button { color: blue; }\nShell > * > * { color: red; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, this.engine);
        TestElement button = new TestElement("Button", composite, this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        ViewCSSTest.assertNotNull((Object)buttonStyle);
        ViewCSSTest.assertEquals((int)1, (int)buttonStyle.getLength());
        ViewCSSTest.assertEquals((String)"color: blue;", (String)buttonStyle.getCssText());
    }

    private static ViewCSS createViewCss(String css) throws IOException {
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet((StyleSheet)styleSheet);
        return new ViewCSSImpl((DocumentCSS)docCss);
    }
}

